/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.excel;

import kd.epm.far.business.fidm.excel.ExcelConstants;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelConvertHelper {
    public static String convertColor(XSSFColor xssColor) {
        if (xssColor == null) {
            return "";
        }
        byte[] rgb = xssColor.getRGB();
        if (rgb == null) {
            short colorId = xssColor.getIndexed();
            if (colorId > 0) {
                if (ExcelConstants.IndexedColorsMap.get(colorId) == null) {
                    return "";
                }
                return ExcelConstants.IndexedColorsMap.get(colorId);
            }
            return "";
        }
        return String.format("#%02X%02X%02X", rgb[0], rgb[1], rgb[2]);
    }

    public static XSSFCell getSheetCell(XSSFSheet xssSheet, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            return null;
        }
        XSSFRow row = xssSheet.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        return row.getCell(columnIndex);
    }
}

