/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.excel;

import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFHeader;

public class ExcelDemoHelper {
    public static Map<String, String> openXML(byte[] outputStreamByte) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(10);
        map.put("header", "");
        map.put("footer", "");
        map.put("body", "");
        map.put("comment", "");
        map.put("chart", "");
        map.put("table", "");
        ByteArrayInputStream finalInputStream = new ByteArrayInputStream(outputStreamByte);
        NiceXWPFDocument newDoc = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)0.0);
            newDoc = new NiceXWPFDocument((InputStream)finalInputStream);
            if (newDoc.getHeaderFooterPolicy() != null) {
                XWPFComment[] footer;
                XWPFHeader header = newDoc.getHeaderFooterPolicy().getDefaultHeader();
                if (header != null) {
                    map.put("header", header.getXWPFDocument().getDocument().xmlText());
                }
                if ((footer = newDoc.getHeaderFooterPolicy().getDefaultFooter()) != null) {
                    map.put("footer", footer.getXWPFDocument().getDocument().xmlText());
                }
            }
            map.put("body", newDoc.getXWPFDocument().getDocument().xmlText());
            StringBuilder commentStr = new StringBuilder();
            try {
                for (XWPFComment comment : newDoc.getComments()) {
                    commentStr.append(comment.getPart().getPackagePart().getInputStream().toString());
                    commentStr.append("\r\nTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT\r\n");
                }
                map.put("comment", commentStr.toString());
            }
            catch (Exception footer) {
                // empty catch block
            }
            StringBuilder chartStr = new StringBuilder();
            for (XWPFChart chart : newDoc.getCharts()) {
                chartStr.append(chart.getCTChartSpace().toString());
                chartStr.append("\r\nTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT\r\n");
            }
            map.put("chart", chartStr.toString());
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
        catch (IOException ioex) {
            throw new KDBizException(ioex.getMessage());
        }
        catch (Exception ex1) {
            throw ex1;
        }
        finally {
            try {
                newDoc.close();
            }
            catch (Exception exception) {}
        }
    }
}

