/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.excel.dto;

import java.io.Serializable;
import kd.bos.util.StringUtils;
import kd.epm.far.common.common.util.ExcelUtils;

public class SelectedAreaInfo
implements Serializable {
    protected int rowStartIndex = -1;
    protected int rowEndIndex = -1;
    protected int columnStartIndex = -1;
    protected int columnEndIndex = -1;
    protected String selectedArea;
    protected boolean isALL = true;

    public SelectedAreaInfo(String selectedArea) {
        if (StringUtils.isEmpty((String)selectedArea) || "ALL".equalsIgnoreCase(selectedArea)) {
            this.initDefault();
        } else {
            try {
                String[] split = selectedArea.split(":");
                int[] startXY = ExcelUtils.pos2XY((String)split[0]);
                int[] endXY = ExcelUtils.pos2XY((String)split[1]);
                this.rowStartIndex = startXY[1];
                this.rowEndIndex = endXY[1];
                this.columnStartIndex = startXY[0];
                this.columnEndIndex = endXY[0];
                this.isALL = false;
            }
            catch (Exception ex) {
                this.initDefault();
            }
        }
    }

    private void initDefault() {
        this.rowStartIndex = -1;
        this.rowEndIndex = -1;
        this.columnStartIndex = -1;
        this.columnEndIndex = -1;
        this.selectedArea = null;
        this.isALL = true;
    }

    public boolean getIsALL() {
        return this.isALL;
    }

    public String getSelectedArea() {
        return this.selectedArea;
    }

    public int getRowStartIndex() {
        return this.rowStartIndex;
    }

    public int getRowEndIndex() {
        return this.rowEndIndex;
    }

    public int getColumnStartIndex() {
        return this.columnStartIndex;
    }

    public int getColumnEndIndex() {
        return this.columnEndIndex;
    }
}

