/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.gpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.config.DMConfigServiceHelper;
import kd.epm.far.business.common.enums.ConfigsettingEnum;
import kd.epm.far.business.common.enums.GPTPromptEnum;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.gpt.DiscloseGPTHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DiscloseGPTService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DiscloseGPTService.class);
    protected static final String GPETDEMO01 = "GPT-PL-TEST-001";

    public static JSONObject getGptConfig() {
        JSONObject jsonObject = new JSONObject();
        int status = 0;
        String gptSetting = DMConfigServiceHelper.getValueByNumber(0L, ConfigsettingEnum.FIDM03.getNumber());
        status = StringUtils.isEmpty((String)gptSetting) || "0".equalsIgnoreCase(gptSetting) ? 0 : 1;
        jsonObject.put("status", (Object)String.valueOf(status));
        return jsonObject;
    }

    public static JSONObject invokeGpt(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String command = jsonObject.getString("command");
        String content = jsonObject.getString("content");
        String type = jsonObject.getString("type");
        String primaryKey = jsonObject.getString("primaryKey");
        if (StringUtils.isEmpty((String)content)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DiscloseGPTService_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String data = null;
        if (StringUtils.isEmpty((String)type) || "0".equals(type)) {
            data = DiscloseGPTService.invokeGptText(content, command);
        } else if ("1".equals(type)) {
            data = DiscloseGPTService.invokeGptModule(content, command);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165GPT\u7c7b\u578b\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5\u524d\u540e\u7aef\u7248\u672c\u662f\u5426\u4e00\u81f4\u3002", (String)"DiscloseGPTService_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return DisclosureVueHelper.getAIResult(data, primaryKey);
    }

    public static String invokeGptModule(String input, String var1) {
        String promptNumber = DiscloseGPTService.getGptPromptNumber(GPTPromptEnum.Module.getNumber());
        if (GPETDEMO01.equalsIgnoreCase(promptNumber)) {
            return "From an enterprise perspective, respond quickly to management requirements, provide flexible and real-time chart display methods, empower managers, and strengthen decision support; From a product perspective, it fills the gap in online application of report display, improves the real-time and simplified application mode of data and charts, and enhances the applicability of multiple scenarios;";
        }
        HashMap<String, String> variableMap = new HashMap<String, String>(2);
        variableMap.put("var01", var1);
        return DiscloseGPTHelper.invoke(promptNumber, input, variableMap);
    }

    public static String invokeGptText(String input, String var1) {
        if (StringUtils.isEmpty((String)var1)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u8bed\u8a00\u98ce\u683c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DiscloseGPTService_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String promptNumber = DiscloseGPTService.getGptPromptNumber(GPTPromptEnum.Text.getNumber());
        if (GPETDEMO01.equalsIgnoreCase(promptNumber)) {
            return "This is GPT TEST,Free Spire XLS for Java is a Java component used for manipulating and processing Excel documents. Developers can use it to create, manipulate, transform, and print in Java applications!";
        }
        HashMap<String, String> variableMap = new HashMap<String, String>(2);
        variableMap.put("var01", var1);
        return DiscloseGPTHelper.invoke(promptNumber, input, variableMap);
    }

    private static String getGptPromptNumber(String gptNumber) {
        String gptSetting = DMConfigServiceHelper.getTextByNumber(0L, ConfigsettingEnum.FIDM04.getNumber());
        if (StringUtils.isEmpty((String)gptSetting)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5bf9\u5e94\u7684GPT\u63d0\u793a\u7f16\u7801\uff0c\u8bf7\u5230\u53c2\u6570\u8bbe\u7f6e\u4e2d\u8bbe\u7f6e\u3002", (String)"DiscloseGPTService_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        JSONObject jsonObject = JSON.parseObject((String)gptSetting);
        String promptNumber = jsonObject.getString(gptNumber);
        if (StringUtils.isEmpty((String)promptNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5bf9\u5e94\u7684GPT\u63d0\u793a\u7f16\u7801\uff0c\u8bf7\u5230\u53c2\u6570\u8bbe\u7f6e\u4e2d\u8bbe\u7f6e\u3002", (String)"DiscloseGPTService_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return promptNumber;
    }
}

