/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.html.base.HtmlUtils;
import kd.epm.far.business.fidm.html.helper.HtmlFontHelper;
import kd.epm.far.business.fidm.html.helper.HtmlParagraphHelper;
import kd.epm.far.business.fidm.html.helper.HtmlSpecilCharHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTableCellHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTableHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTextHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordPageBreakNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorders;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.WordWidthHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class HtmlConvert {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(HtmlConvert.class);
    private Map<String, JSONObject> itemPropertyList = new LinkedHashMap<String, JSONObject>(2);

    public HtmlConvert() {
    }

    public HtmlConvert(Map<String, JSONObject> itemPropertyList) {
        this.itemPropertyList = itemPropertyList;
        if (this.itemPropertyList == null) {
            this.itemPropertyList = new LinkedHashMap<String, JSONObject>(2);
        }
    }

    public WordRootNode fromHtml(String html, int contentType) {
        WordRootNode rootNode = new WordRootNode(contentType);
        if (StringUtils.isEmpty((String)html)) {
            return rootNode;
        }
        html = HtmlSpecilCharHelper.convertToHtmlTextByEmptyChar(html);
        Document doc = Jsoup.parse((String)html);
        Element body = doc.body();
        for (Element element : body.children()) {
            WordTableNode tableNode;
            String tagName = element.tagName().toLowerCase();
            if ("div".equals(tagName) && StringUtils.isNotEmpty((String)element.attr("class")) && "mce-toc".equals(element.attr("class"))) {
                element.tagName("p");
                element.clearAttributes();
                Element span = new Element("span");
                span.attr("id", element.attr("id"));
                span.attr("class", "bookmark");
                span.attr("data-module-id", element.attr("data-module-id"));
                span.attr("data-module-resultcode", element.attr("data-module-resultcode"));
                span.text("Table of Contents");
                element.html("");
                element.appendChild((Node)span);
                tagName = element.tagName().toLowerCase();
            }
            if ("p".equals(tagName) || tagName.length() == 2 || tagName.startsWith("h")) {
                List<WordParagraphNode> paragraphNodes = this.fromParagraphNumId(element);
                if (paragraphNodes.size() == 0) {
                    WordParagraphNode paragraphNode = this.createWordParagraph(element, tagName);
                    paragraphNodes.add(paragraphNode);
                }
                if (paragraphNodes.size() <= 0) continue;
                rootNode.getChilds().addAll(paragraphNodes);
                continue;
            }
            if (!"table".equals(tagName) || (tableNode = this.createTableNode(element)) == null) continue;
            rootNode.getChilds().add(tableNode);
        }
        return rootNode;
    }

    private WordTableNode createTableNode(Element element) {
        return this.createTableNode(element, false);
    }

    public WordTableNode createTableNode(Element element, boolean isAddElement) {
        String widthStr;
        WordTableNode tableNode = new WordTableNode();
        Element tbody = element.children().stream().filter(m -> "tbody".equalsIgnoreCase(m.tagName())).findFirst().orElse(null);
        if (tbody == null) {
            return null;
        }
        HtmlUtils.setCommonElementAttribute(tableNode, element);
        Element caption = element.children().stream().filter(m -> "caption".equalsIgnoreCase(m.tagName())).findFirst().orElse(null);
        if (caption != null) {
            WordTableRowNode rowNode = new WordTableRowNode();
            rowNode.setHeight(325.5);
            WordTableCellNode cellNode = new WordTableCellNode();
            int cellMaxCount = 0;
            if (tbody.children().size() > 0) {
                for (Element cellElement : tbody.children().first().children()) {
                    int colSpan = TypeUtils.convertValueToInt(cellElement.attr("colspan"));
                    if (colSpan > 1) {
                        cellMaxCount += colSpan;
                        continue;
                    }
                    ++cellMaxCount;
                }
            }
            if (cellMaxCount > 0) {
                cellNode.setColumnSpan(cellMaxCount);
            }
            WordTableCellBorders headCellBorders = new WordTableCellBorders();
            headCellBorders.getLeft().setType(WordConstants.WordBorderType.None.getType());
            headCellBorders.getRight().setType(WordConstants.WordBorderType.None.getType());
            headCellBorders.getTop().setType(WordConstants.WordBorderType.None.getType());
            headCellBorders.getBottom().setType(WordConstants.WordBorderType.None.getType());
            cellNode.setBorders(headCellBorders);
            if (isAddElement) {
                cellNode.setUserFlag(caption);
            }
            rowNode.getChilds().add(cellNode);
            WordParagraphNode paragraphNode = new WordParagraphNode();
            paragraphNode.setAlignment(ParagraphAlignment.CENTER);
            cellNode.getChilds().add(paragraphNode);
            HtmlTextHelper.createTextNodeList(paragraphNode, (Node)caption, null, this.itemPropertyList);
            tableNode.getChilds().add(rowNode);
        }
        double tableWidth = 542.0;
        Map<String, String> tableStyleData = HtmlUtils.fromStyle(element.attr("style"));
        if (tableStyleData.containsKey("width") && StringUtils.isNotEmpty((String)(widthStr = tableStyleData.get("width")))) {
            if (widthStr.contains("%")) {
                tableWidth = TypeUtils.convertValueToDoule(widthStr.replace("%", ""));
                if (tableWidth <= 0.0) {
                    tableWidth = 0.99;
                }
                tableNode.setWidth(tableWidth / 100.0);
                tableNode.setWidthType(WordConstants.WordWidthType.Percentage.getType());
            } else {
                double width = HtmlFontHelper.convertHtmlLength(tableStyleData.get("width"));
                if (width > 0.0) {
                    tableWidth = width;
                }
                tableNode.setWidth(tableWidth * 15.5);
                tableNode.setWidthType(WordConstants.WordWidthType.Absolute.getType());
            }
        }
        if (tableNode.getWidthType() == WordConstants.WordWidthType.Absolute.getType()) {
            tableNode.setWidth(tableWidth * 15.5);
        }
        double tableBorder = TypeUtils.convertValueToDoule(element.attr("border"));
        String tableAlignment = tableStyleData.get("float");
        if ("center".equals(tableAlignment)) {
            tableNode.setAlignment(2);
        } else if ("right".equals(tableAlignment)) {
            tableNode.setAlignment(3);
        } else {
            double leftInd = TypeUtils.convertValueToDoule(HtmlFontHelper.removeHtmlLengthTag(tableStyleData.get("margin-left")));
            if (leftInd != 0.0) {
                tableNode.setLeftInd(leftInd * 567.0 / 36.14);
            }
        }
        for (Element rowElement : tbody.children()) {
            double height;
            WordTableRowNode rowNode = new WordTableRowNode();
            Map<String, String> rowStyleData = HtmlUtils.fromStyle(rowElement.attr("style"));
            if (rowStyleData.containsKey("height") && (height = HtmlFontHelper.convertHtmlLength(rowStyleData.get("height"))) > 0.0) {
                rowNode.setHeight(height * 15.5);
            }
            boolean isPercentageLength = false;
            double rowWidth = 0.0;
            for (Element cellElement : rowElement.children()) {
                int colSpan;
                int rowSpan;
                String textAlign;
                List<WordParagraphNode> paragraphNodes;
                String hightlightColor;
                Map<String, String> cellStyleData = HtmlUtils.fromStyle(cellElement.attr("style"));
                WordTableCellNode cellNode = new WordTableCellNode();
                if (cellStyleData.containsKey("background-color") && StringUtils.isNotEmpty((String)(hightlightColor = cellStyleData.get("background-color").replace("#", "")))) {
                    cellNode.setHightlightColor(hightlightColor);
                }
                if ((paragraphNodes = HtmlTableCellHelper.createWordCellParagraphList(cellElement, textAlign = cellStyleData.get("text-align"), this.itemPropertyList)).size() > 0) {
                    cellNode.getChilds().addAll(paragraphNodes);
                }
                if (cellStyleData.containsKey("width")) {
                    double cellWidth = 0.0;
                    if (cellStyleData.get("width").contains("%")) {
                        cellWidth = TypeUtils.convertValueToDoule(cellStyleData.get("width").replace("%", "")) / 100.0;
                        if (cellWidth > 0.0) {
                            cellNode.setWidth(cellWidth);
                            cellNode.setWidthType(WordConstants.WordWidthType.Percentage.getType());
                            isPercentageLength = true;
                        }
                    } else {
                        cellWidth = HtmlFontHelper.convertHtmlLength(cellStyleData.get("width"));
                        if (cellWidth > 0.0) {
                            cellNode.setWidth(cellWidth * 15.5);
                            cellNode.setWidthType(WordConstants.WordWidthType.Absolute.getType());
                        }
                    }
                    rowWidth += cellNode.getWidth();
                }
                if ((rowSpan = TypeUtils.convertValueToInt(cellElement.attr("rowspan")).intValue()) > 1) {
                    cellNode.setRowSpan(rowSpan);
                }
                if ((colSpan = TypeUtils.convertValueToInt(cellElement.attr("colspan")).intValue()) > 1) {
                    cellNode.setColumnSpan(colSpan);
                }
                if (cellStyleData.get("border-width") == null && tableBorder > 0.0 && tableBorder != 1.0) {
                    cellStyleData.put("border-width", String.valueOf(tableBorder));
                }
                cellNode.setBorders(HtmlTableCellHelper.createWordCellBorders(cellStyleData));
                if (isAddElement) {
                    cellNode.setUserFlag(cellElement);
                }
                if (cellNode == null) continue;
                rowNode.getChilds().add(cellNode);
            }
            rowNode.setWidth(rowWidth);
            rowNode.setWidthType(isPercentageLength ? WordConstants.WordWidthType.Percentage.getType() : WordConstants.WordWidthType.Absolute.getType());
            tableNode.getChilds().add(rowNode);
        }
        WordWidthHelper.resetTableCellZeroWidth(tableNode);
        return tableNode;
    }

    private WordParagraphNode createWordParagraph(Element element, String tagName) {
        double lineHeight;
        String lineHeightStr;
        int leftChars;
        WordParagraphNode paragraphNode = new WordParagraphNode();
        paragraphNode.setAlignment(HtmlParagraphHelper.fromParagraphAlignment(element));
        paragraphNode.setTitleStyle(this.fromParagraphHtmlTag(tagName));
        Map<String, String> style = HtmlUtils.fromStyle(element.attr("style"));
        String paddingLeft = style.get("padding-left");
        if (StringUtils.isNotEmpty((String)paddingLeft) && (leftChars = TypeUtils.convertValueToInt(HtmlFontHelper.removeHtmlLengthTag(paddingLeft)) / 40) > 1) {
            paragraphNode.setLeftChars(leftChars);
        }
        if (StringUtils.isNotEmpty((String)(lineHeightStr = style.get("line-height"))) && (lineHeight = TypeUtils.convertValueToDoule(lineHeightStr).doubleValue()) > 0.0) {
            paragraphNode.setLineHegiht(lineHeight);
        }
        HtmlTextHelper.createTextNodeList(paragraphNode, (Node)element, null, this.itemPropertyList);
        if (element.html().contains("<!-- pagebreak -->")) {
            WordTextNode textNode = new WordTextNode();
            textNode.getChilds().add(new WordPageBreakNode());
            paragraphNode.getChilds().add(textNode);
        }
        return paragraphNode;
    }

    private List<WordParagraphNode> fromParagraphNumId(Element element) {
        String id = String.valueOf(GlobalIdUtil.genGlobalLongId());
        ArrayList<WordParagraphNode> paragraphNodes = new ArrayList<WordParagraphNode>(2);
        String parentTag = "ul";
        Element ul = element.select(parentTag).first();
        if (ul == null) {
            parentTag = "ol";
            ul = element.select("ol").first();
        }
        if (ul == null) {
            return paragraphNodes;
        }
        if (ul.children().size() == 0) {
            return paragraphNodes;
        }
        Elements liElements = ul.select("li");
        LinkedHashMap<Element, Integer> elementMap = new LinkedHashMap<Element, Integer>(2);
        for (Element li : liElements) {
            int level = 0;
            for (Element liParent = li.parent(); liParent != null && !ul.equals((Object)liParent); liParent = liParent.parent()) {
                if (parentTag.equals(liParent.tagName())) {
                    ++level;
                }
                if (liParent == null) break;
            }
            elementMap.put(li, level);
        }
        for (Map.Entry entry : elementMap.entrySet()) {
            Element copyLi = new Element("li");
            for (Node child : ((Element)entry.getKey()).childNodes()) {
                if (child instanceof Element && parentTag.equals(((Element)child).tagName())) continue;
                copyLi.appendChild(child);
            }
            WordParagraphNode paragraphNode = this.createWordParagraph(copyLi, copyLi.tagName());
            if (paragraphNode == null) continue;
            if ("ol".equals(parentTag)) {
                paragraphNode.setNumIdStr("ol-" + id);
            } else {
                paragraphNode.setNumIdStr("ul");
            }
            if ((Integer)entry.getValue() > 0) {
                paragraphNode.setLeft((Integer)entry.getValue());
            }
            paragraphNodes.add(paragraphNode);
        }
        return paragraphNodes;
    }

    private int fromParagraphHtmlTag(String tagName) {
        int titleStyle = 0;
        if (tagName.startsWith("h") && tagName.length() > 1) {
            titleStyle = TypeUtils.convertValueToInt(tagName.replace("h", ""));
        }
        if (titleStyle < 0) {
            titleStyle = 0;
        }
        return titleStyle;
    }

    public String toHtml(WordRootNode rootNode) {
        if (rootNode == null || rootNode.getChilds().size() == 0) {
            return "";
        }
        Document doc = Jsoup.parse((String)"");
        Element body = doc.body();
        for (WordNode node : rootNode.getChilds()) {
            WordTableNode table;
            if (node.getType() == WordConstants.WordNodeType.Paragraph.getType()) {
                WordParagraphNode paragraph = (WordParagraphNode)node;
                if (paragraph == null) continue;
                HtmlParagraphHelper.toParagraphHtml(paragraph, body);
                continue;
            }
            if (node.getType() != WordConstants.WordNodeType.Table.getType() || (table = (WordTableNode)node) == null) continue;
            HtmlTableHelper.toTableHtml(table, body);
        }
        return HtmlSpecilCharHelper.convertToHtmlBody(body.html());
    }
}

