/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.html.base.HtmlUtils;
import kd.epm.far.business.fidm.html.helper.HtmlSpecilCharHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTableHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTextHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTocHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.dto.WordImageNode;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.WordBookmarkHelper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class HtmlReplaceHelper {
    private static List<Element> getRealElement(Element body) {
        ArrayList<Element> elementList = new ArrayList<Element>(500);
        if (body == null) {
            return elementList;
        }
        Elements bookmarks = body.getAllElements();
        for (Element element : bookmarks) {
            String moduleId = element.attr("data-module-id");
            String bookmarkKey = element.attr("id");
            if (StringUtils.isEmpty((String)bookmarkKey) && StringUtils.isEmpty((String)moduleId) || StringUtils.isEmpty((String)moduleId) && !StringUtils.isEmpty((String)bookmarkKey) && !WordBookmarkHelper.isOwnerBookmark(bookmarkKey)) continue;
            elementList.add(element);
        }
        return elementList;
    }

    public static String changeBookmarkElement(String html, Map<String, JSONObject> itemPropertyMap) {
        if (StringUtils.isEmpty((String)html)) {
            return html;
        }
        Document doc = Jsoup.parse((String)html);
        Element body = doc.body();
        List<Element> elementList = HtmlReplaceHelper.getRealElement(body);
        for (Element element : elementList) {
            List attributeKey;
            JSONObject itemProperty = null;
            String moduleId = element.attr("data-module-id");
            String bookmarkKey = element.attr("id");
            if (StringUtils.isEmpty((String)moduleId)) {
                itemProperty = itemPropertyMap.get(bookmarkKey);
                if (itemProperty == null) continue;
                moduleId = itemProperty.getString("id");
            }
            if ((itemProperty = itemPropertyMap.get(moduleId)) == null) continue;
            if ("img".equals(element.tagName()) || "input".equals(element.tagName())) {
                attributeKey = element.attributes().asList().stream().map(m -> m.getKey()).collect(Collectors.toList());
                for (String key : attributeKey) {
                    element.removeAttr(key);
                }
                element.children().remove();
                element.attr("id", bookmarkKey);
                element.attr("class", "bookmark");
                element.attr("type", "button");
                element.attr("value", "{{" + itemProperty.getString("name") + "}}");
                element.tagName("input");
                continue;
            }
            if (!"table".equals(element.tagName())) continue;
            attributeKey = element.attributes().asList().stream().map(m -> m.getKey()).collect(Collectors.toList());
            for (String key : attributeKey) {
                element.removeAttr(key);
            }
            element.children().remove();
            element.tagName("p");
            Element input = new Element("input");
            input.attr("id", bookmarkKey);
            input.attr("class", "bookmark");
            input.attr("type", "button");
            input.attr("value", "{{" + itemProperty.getString("name") + "}}");
            element.appendChild((Node)input);
        }
        return HtmlSpecilCharHelper.convertToHtmlBody(body.html());
    }

    public static String replaceBookmark(String html, Map<String, WordNode> imageBookmarks, boolean nullNodeExists) {
        WordNode node;
        Document doc = Jsoup.parse((String)html);
        Element body = doc.body();
        List<Element> elementList = HtmlReplaceHelper.getRealElement(body);
        for (Element element : elementList) {
            String moduleName;
            String id = element.attr("id");
            String moduleId = element.attr("data-module-id");
            node = imageBookmarks.get(id);
            if (node == null && StringUtils.isNotEmpty((String)(moduleName = element.attr("value")))) {
                moduleName = moduleName.replace("{", "").replace("}", "");
                for (Map.Entry<String, WordNode> entry : imageBookmarks.entrySet()) {
                    Map userFlag = (Map)entry.getValue().getUserFlag();
                    if (userFlag == null || !((String)userFlag.get("moduleName")).equalsIgnoreCase(moduleName)) continue;
                    node = entry.getValue();
                    id = entry.getKey();
                    moduleId = entry.getValue().getDataModeuleId();
                    break;
                }
            }
            if (node == null && !nullNodeExists) {
                WordTextNode textNode = new WordTextNode();
                textNode.setId(id);
                textNode.setDataModeuleId(moduleId);
                textNode.setDataModeuleResultCode("0001");
                String moduleNameTips = element.attr("value");
                if (StringUtils.isNotEmpty((String)moduleNameTips)) {
                    if (moduleNameTips.startsWith("{{") && moduleNameTips.endsWith("}}")) {
                        moduleNameTips = moduleNameTips.replace("{", "").replace("}", "") + ":Module Not Find!";
                    }
                } else {
                    moduleNameTips = "Module Not Find!";
                }
                textNode.setContent(HtmlSpecilCharHelper.convertToWordNodeText(moduleNameTips));
                node = textNode;
            }
            if (node == null) continue;
            HtmlReplaceHelper.replaceElement(body, element, node, id);
        }
        Elements spans = body.select("span");
        for (Element element : spans) {
            String className = element.attr("class");
            if (StringUtils.isNotEmpty((String)className) && className.indexOf("bookmark") >= 0) continue;
            node = null;
            String id = "";
            String moduleName = element.text();
            for (Map.Entry<String, WordNode> entry : imageBookmarks.entrySet()) {
                Map userFlag = (Map)entry.getValue().getUserFlag();
                if (userFlag == null || !((String)userFlag.get("moduleName")).equalsIgnoreCase(moduleName)) continue;
                node = entry.getValue();
                id = entry.getKey();
                break;
            }
            HtmlReplaceHelper.replaceElement(body, element, node, id);
        }
        return HtmlSpecilCharHelper.convertToHtmlBody(body.html());
    }

    private static void replaceElement(Element body, Element element, WordNode node, String bookmarkKey) {
        WordTableNode tableNode;
        Element newElement;
        if (element == null || node == null) {
            return;
        }
        HashMap userFlag = (HashMap)node.getUserFlag();
        if (userFlag == null) {
            userFlag = new HashMap(2);
        }
        String moduleId = (String)userFlag.get("moduleId");
        element.attr("id", bookmarkKey);
        element.attr("data-module-id", node.getDataModeuleId());
        element.attr("data-module-resultcode", node.getDataModeuleResultCode());
        if (node instanceof WordTextNode) {
            if (ModuleEnum.TOC.getType().equals(userFlag.get("moduleType"))) {
                HtmlTocHelper.createToc(body, element);
            } else {
                WordTextNode textNode = (WordTextNode)node;
                element.tagName("span");
                element.text(HtmlSpecilCharHelper.convertToHtmlText(textNode.getContent()));
                if (!node.getDataModeuleResultCode().equals("0000")) {
                    Map<String, String> styleData = HtmlUtils.fromStyle(element.attr("style"));
                    styleData.put("background-color", "#FFFF00");
                    element.attr("style", HtmlUtils.toStyle(styleData));
                    HtmlUtils.setCommonElementAttribute(textNode, element);
                    element.removeAttr("value");
                    element.removeAttr("type");
                } else {
                    Element oldParent;
                    int index;
                    Element newP = new Element("p");
                    HtmlTextHelper.toTextHtml(textNode, newP);
                    if (element.parent() != null && newP.children().size() > 0 && (index = (oldParent = element.parent()).childNodes().indexOf(element)) >= 0) {
                        element.remove();
                        for (int i = 0; i < newP.children().size(); ++i) {
                            oldParent.insertChildren(index, new Node[]{(Node)newP.children().get(i)});
                        }
                    }
                }
            }
        } else if (node instanceof WordImageNode) {
            WordImageNode imageNode = (WordImageNode)node;
            element.tagName("img");
            element.text("");
            element.attr("src", "imagewordmoduleid" + moduleId);
            element.attr("alt", imageNode.getDescription());
            element.attr("width", String.valueOf(imageNode.getHtmlWidth()));
            element.attr("height", String.valueOf(imageNode.getHtmlHeight()));
            element.removeAttr("value");
            element.removeAttr("type");
        } else if (node instanceof WordTableNode && (newElement = HtmlTableHelper.toTableHtml(tableNode = (WordTableNode)node, element.parent())) != null && element.parent() != null) {
            int index = element.parent().childNodes().indexOf(element);
            if (index >= 0) {
                element.parent().insertChildren(index, new Node[]{newElement});
            }
            element.remove();
        }
    }

    public static List<Map<String, String>> getBookmarkEntitys(String html) {
        Document doc = Jsoup.parse((String)html);
        Element body = doc.body();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(2);
        List<Element> elementList = HtmlReplaceHelper.getRealElement(body);
        for (Element element : elementList) {
            HashMap<String, String> item = new HashMap<String, String>(2);
            item.put("id", element.attr("id"));
            item.put("moduleId", element.attr("data-module-id"));
            item.put("tagName", element.tagName());
            list.add(item);
        }
        return list;
    }

    public static String replaceImageTicket(String html, String ticket) {
        if (StringUtils.isEmpty((String)html)) {
            return html;
        }
        boolean isChange = false;
        Document doc = Jsoup.parse((String)html);
        Elements images = doc.select("img");
        for (Element img : images) {
            int startIndex;
            String src = img.attr("src");
            if (StringUtils.isEmpty((String)src) || src.startsWith("data:image") || (startIndex = src.indexOf("kd_cs_ticket")) <= 0) continue;
            src = src.substring(0, startIndex) + "kd_cs_ticket" + "=" + ticket;
            img.attr("src", src);
            isChange = true;
        }
        if (isChange) {
            return doc.body().html();
        }
        return html;
    }

    public static String replaceInputToIamge(String html) {
        if (StringUtils.isEmpty((String)html)) {
            return html;
        }
        boolean isChange = false;
        Document doc = Jsoup.parse((String)html);
        Elements inputs = doc.select("input");
        for (Element element : inputs) {
            String id = element.attr("id");
            if (StringUtils.isEmpty((String)id)) continue;
            String heightStr = element.attr("height");
            String widthStr = element.attr("width");
            if (StringUtils.isEmpty((String)heightStr) || StringUtils.isEmpty((String)widthStr)) continue;
            int height = TypeUtils.convertValueToInt(heightStr);
            int width = TypeUtils.convertValueToInt(widthStr);
            if (width <= 0 || height <= 0) continue;
            element.tagName("img");
            element.text("");
            element.attr("alt", "");
            element.removeAttr("value");
            element.removeAttr("type");
            isChange = true;
        }
        if (isChange) {
            return doc.body().html();
        }
        return html;
    }
}

