/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html.base;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.word.dto.WordNode;
import org.jsoup.nodes.Element;

public class HtmlUtils {
    public static String toStyle(Map<String, String> styleData) {
        if (styleData == null || styleData.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : styleData.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
            sb.append(";");
        }
        return sb.toString();
    }

    public static Map<String, String> fromStyle(String styleStr) {
        String[] array;
        LinkedHashMap<String, String> styleData = new LinkedHashMap<String, String>(2);
        if (!StringUtils.isNotEmpty((String)styleStr)) {
            return styleData;
        }
        for (String item : array = styleStr.split(";")) {
            int index;
            if (!StringUtils.isNotEmpty((String)(item = item.toLowerCase())) || (index = item.indexOf(":")) <= 0) continue;
            styleData.put(item.substring(0, index).trim(), item.substring(index + 1).trim());
        }
        return styleData;
    }

    public static Map<String, String> fromStyleForMutilValue(String styleStr) {
        String[] array;
        LinkedHashMap<String, String> styleData = new LinkedHashMap<String, String>(2);
        if (!StringUtils.isNotEmpty((String)styleStr)) {
            return styleData;
        }
        for (String item : array = styleStr.split(";")) {
            int index;
            if (!StringUtils.isNotEmpty((String)(item = item.toLowerCase())) || (index = item.indexOf(":")) <= 0) continue;
            String key = item.substring(0, index).trim();
            String value = item.substring(index + 1).trim();
            if (styleData.containsKey(key)) {
                value = (String)styleData.get(key) + ";" + value;
            }
            styleData.put(key, value);
        }
        return styleData;
    }

    public static void setCommonElementAttribute(WordNode node, Element item) {
        if (StringUtils.isNotEmpty((String)node.getId())) {
            item.attr("id", node.getId());
        }
        if (StringUtils.isNotEmpty((String)node.getDataModeuleId())) {
            item.attr("data-module-id", node.getDataModeuleId());
        }
        if (StringUtils.isNotEmpty((String)node.getDataModeuleResultCode())) {
            item.attr("data-module-resultcode", node.getDataModeuleResultCode());
        }
    }

    public static void setCommonNodeProperty(Element item, WordNode node) {
        if (StringUtils.isNotEmpty((String)item.attr("id"))) {
            node.setId(item.attr("id"));
        }
        if (StringUtils.isNotEmpty((String)item.attr("data-module-id"))) {
            node.setDataModeuleId(item.attr("data-module-id"));
        }
        if (StringUtils.isNotEmpty((String)item.attr("data-module-resultcode"))) {
            node.setDataModeuleResultCode(item.attr("data-module-resultcode"));
        }
    }
}

