/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html.helper;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordTextNode;

public class HtmlFontHelper {
    public static final Map<Double, Double> SimsunFontConvertMap = new LinkedHashMap<Double, Double>(){
        {
            this.put(12.0, 9.0);
            this.put(14.0, 11.0);
            this.put(16.0, 12.0);
            this.put(18.0, 14.0);
            this.put(24.0, 18.0);
            this.put(36.0, 25.0);
        }
    };

    public static double convertToHtmlFontSize(String htmlFontfamily, WordTextNode textNode) {
        double wpsFontSize = textNode.getFontSize();
        Double realFontSize = wpsFontSize;
        return realFontSize;
    }

    public static double convertToWordFontSize(String htmlFontfamily, String fontSizeStr) {
        if (fontSizeStr == null) {
            fontSizeStr = "";
        }
        double fontSize = HtmlFontHelper.convertHtmlLength(fontSizeStr);
        Double realFontSize = fontSize;
        return realFontSize;
    }

    public static double convetToWordFont(double fontSize) {
        if (fontSize <= 0.0) {
            return 12.0;
        }
        Double realFontSize = SimsunFontConvertMap.get(fontSize);
        if (realFontSize == null) {
            realFontSize = fontSize;
        }
        return realFontSize;
    }

    public static double convertHtmlLength(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return 0.0;
        }
        return TypeUtils.convertValueToDoule(HtmlFontHelper.removeHtmlLengthTag(input));
    }

    public static String removeHtmlLengthTag(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return input;
        }
        for (String len : WordConstants.HtmlLengths) {
            input = input.toLowerCase().replace(len, "");
        }
        input = input.replace("%", "");
        return input;
    }

    public static String convertToWordFontFamily(String htmlFontFamily) {
        if (htmlFontFamily == null) {
            htmlFontFamily = "";
        }
        String wordFontFamily = WordConstants.YaheiFont;
        if ((htmlFontFamily = htmlFontFamily.toLowerCase().trim()).contains("yahei")) {
            wordFontFamily = WordConstants.YaheiFont;
        } else if (htmlFontFamily.contains("fangsong")) {
            wordFontFamily = WordConstants.FangsongFont;
        } else if (htmlFontFamily.contains("simhei")) {
            wordFontFamily = WordConstants.SansFont;
        } else if (htmlFontFamily.contains("times") && htmlFontFamily.contains("roman")) {
            wordFontFamily = "Times New Roman";
        } else if (htmlFontFamily.contains("courier")) {
            wordFontFamily = "Courier New";
        } else if (htmlFontFamily.contains("simsun")) {
            wordFontFamily = WordConstants.SimsunFont;
        }
        return wordFontFamily;
    }

    public static String convertToHtmlFontFamily(String wordFontFamily) {
        if (StringUtils.isEmpty((String)wordFontFamily)) {
            wordFontFamily = "";
        }
        String htmlFontFamily = "";
        if ((wordFontFamily = wordFontFamily.toLowerCase().trim()).contains("yahei") || wordFontFamily.contains(WordConstants.YaheiFont)) {
            htmlFontFamily = "Microsoft YaHei";
        } else if (wordFontFamily.contains("fangsong") || wordFontFamily.contains(WordConstants.FangsongFont)) {
            htmlFontFamily = "FangSong, serif";
        } else if (wordFontFamily.contains("simhei") || wordFontFamily.contains(WordConstants.SansFont)) {
            htmlFontFamily = "SimHei, sans-serif";
        } else if (wordFontFamily.contains("times") && wordFontFamily.contains("roman")) {
            htmlFontFamily = "times new roman";
        } else if (wordFontFamily.contains("courier")) {
            htmlFontFamily = "courier new";
        } else if (wordFontFamily.contains("simsun") || wordFontFamily.contains(WordConstants.SimsunFont)) {
            htmlFontFamily = "simsun, serif";
        }
        return htmlFontFamily;
    }
}

