/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html.helper;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.html.base.HtmlUtils;
import kd.epm.far.business.fidm.html.helper.HtmlTextHelper;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class HtmlParagraphHelper {
    public static Element toParagraphHtml(WordParagraphNode paragraphNode, Element firstParent) {
        Element parent = firstParent;
        String tag = HtmlParagraphHelper.toParagraphHtmlTag(paragraphNode);
        Element paragraphTag = new Element(tag);
        Map<String, String> styleData = HtmlParagraphHelper.toParagraphAlignment(paragraphNode);
        if (StringUtils.isNotEmpty((String)paragraphNode.getFontColor())) {
            styleData.put("color", paragraphNode.getFontColor());
        }
        if (StringUtils.isNotEmpty((String)paragraphNode.getHightlightColor())) {
            styleData.put("background-color", paragraphNode.getHightlightColor());
        }
        if (parent != null) {
            parent.appendChild((Node)paragraphTag);
        }
        parent = paragraphTag;
        if (StringUtils.isNotEmpty((String)paragraphNode.getNumIdStr())) {
            parent = HtmlParagraphHelper.toListHtml(paragraphNode, parent);
        } else {
            int leftChars = paragraphNode.getLeftChars();
            if (leftChars > 0) {
                styleData.put("padding-left", 40 * leftChars + "px");
            }
        }
        if (paragraphNode.getLineHegiht() > 0.0 && paragraphNode.getLineHegiht() != 1.0) {
            styleData.put("line-height", String.valueOf(paragraphNode.getLineHegiht()));
        }
        if (styleData.size() > 0) {
            paragraphTag.attr("style", HtmlUtils.toStyle(styleData));
        }
        for (WordNode node : paragraphNode.getChilds()) {
            if (node.getType() != WordConstants.WordNodeType.Text.getType()) continue;
            HtmlTextHelper.toTextHtml((WordTextNode)node, parent);
        }
        if (firstParent != null && "body".equals(firstParent.tagName()) && StringUtils.isNotEmpty((String)paragraphNode.getNumIdStr()) && paragraphTag.children().size() > 0) {
            paragraphTag = (Element)paragraphTag.children().get(0);
        }
        return paragraphTag;
    }

    private static Element toListHtml(WordParagraphNode paragraphNode, Element parent) {
        if (StringUtils.isNotEmpty((String)paragraphNode.getNumIdStr())) {
            int left = paragraphNode.getLeft();
            String numStyle = "";
            String listTag = "ul";
            if (paragraphNode.getNumIdStr().startsWith("ol")) {
                listTag = "ol";
            }
            for (int i = 0; i < left + 1; ++i) {
                Element li;
                Element ul;
                if (i == left) {
                    ul = new Element(listTag);
                    if (StringUtils.isNotEmpty((String)numStyle)) {
                        ul.attr("style", numStyle);
                    }
                    li = new Element("li");
                    ul.appendChild((Node)li);
                    parent.appendChild((Node)ul);
                    parent = li;
                    continue;
                }
                ul = new Element(listTag);
                li = new Element("li");
                li.attr("style", "list-style-type: none;");
                ul.appendChild((Node)li);
                parent.appendChild((Node)ul);
                parent = ul;
            }
        }
        return parent;
    }

    private static String toParagraphHtmlTag(WordParagraphNode paragraphNode) {
        String tag = "p";
        if (paragraphNode.getTitleStyle() > 0) {
            tag = paragraphNode.getTitleStyle() > 6 ? "h6" : "h" + paragraphNode.getTitleStyle();
        }
        return tag;
    }

    private static Map<String, String> toParagraphAlignment(WordParagraphNode paragraphNode) {
        LinkedHashMap<String, String> styleData = new LinkedHashMap<String, String>(2);
        String alignmentStr = "";
        ParagraphAlignment alignment = paragraphNode.getAlignment();
        if (alignment == ParagraphAlignment.CENTER) {
            alignmentStr = "center";
        } else if (alignment == ParagraphAlignment.RIGHT) {
            alignmentStr = "right";
        } else if (alignment == ParagraphAlignment.DISTRIBUTE || alignment == ParagraphAlignment.BOTH) {
            alignmentStr = "justify";
        }
        if (StringUtils.isNotEmpty((String)alignmentStr)) {
            styleData.put("text-align", alignmentStr);
        }
        return styleData;
    }

    public static ParagraphAlignment fromParagraphAlignment(Element child) {
        ParagraphAlignment paragraphAlignment = ParagraphAlignment.LEFT;
        Map<String, String> style = HtmlUtils.fromStyle(child.attr("style"));
        if (style.containsKey("text-align")) {
            String alignmentStr = style.get("text-align");
            if ("center".equals(alignmentStr)) {
                paragraphAlignment = ParagraphAlignment.CENTER;
            } else if ("right".equals(alignmentStr)) {
                paragraphAlignment = ParagraphAlignment.RIGHT;
            } else if ("justify".equals(alignmentStr)) {
                paragraphAlignment = ParagraphAlignment.BOTH;
            }
        }
        return paragraphAlignment;
    }
}

