/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.html.base.HtmlUtils;
import kd.epm.far.business.fidm.html.helper.HtmlFontHelper;
import kd.epm.far.business.fidm.html.helper.HtmlParagraphHelper;
import kd.epm.far.business.fidm.html.helper.HtmlSpecilCharHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTextHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorder;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorders;
import kd.epm.far.business.fidm.word.dto.WordTableCellMargins;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class HtmlTableCellHelper {
    private static final String Zero = "0";

    public static String getCellMargin(WordTableCellMargins margins) {
        if (margins == null || margins.isDefault()) {
            return null;
        }
        CharSequence[] marginData = new String[]{margins.getTop() != null && margins.getTop().getWidth() != 0.0 ? margins.getTop().getWidth() * 36.14 / 567.0 + "px" : Zero, margins.getRight() != null && margins.getRight().getWidth() != 0.0 ? margins.getRight().getWidth() * 36.14 / 567.0 + "px" : Zero, margins.getBottom() != null && margins.getBottom().getWidth() != 0.0 ? margins.getBottom().getWidth() * 36.14 / 567.0 + "px" : Zero, margins.getLeft() != null && margins.getLeft().getWidth() != 0.0 ? margins.getLeft().getWidth() * 36.14 / 567.0 + "px" : Zero};
        return String.join((CharSequence)" ", marginData);
    }

    public static Map<String, String> toTableCellBorderStyles(WordTableCellNode cellNode) {
        LinkedHashMap<String, String> borderStyle = new LinkedHashMap<String, String>(2);
        if (cellNode == null) {
            return borderStyle;
        }
        if (cellNode.getBorders() == null) {
            return borderStyle;
        }
        if (cellNode.getBorders().isDefault()) {
            return borderStyle;
        }
        borderStyle.putAll(HtmlTableCellHelper.toTableCellBorderStyle(cellNode.getBorders().getLeft(), "left"));
        borderStyle.putAll(HtmlTableCellHelper.toTableCellBorderStyle(cellNode.getBorders().getRight(), "right"));
        borderStyle.putAll(HtmlTableCellHelper.toTableCellBorderStyle(cellNode.getBorders().getTop(), "top"));
        borderStyle.putAll(HtmlTableCellHelper.toTableCellBorderStyle(cellNode.getBorders().getBottom(), "bottom"));
        return borderStyle;
    }

    private static Map<String, String> toTableCellBorderStyle(WordTableCellBorder border, String tag) {
        LinkedHashMap<String, String> cellStyleData = new LinkedHashMap<String, String>(2);
        if (!border.isDefault()) {
            int witdh;
            String style = "solid";
            if (border.getType() == WordConstants.WordBorderType.None.getType()) {
                style = "none";
            } else if (border.getType() == WordConstants.WordBorderType.Dashed.getType()) {
                style = "dashed";
            } else if (border.getType() == WordConstants.WordBorderType.Dotted.getType()) {
                style = "dotted";
            }
            if (StringUtils.isNotEmpty((String)border.getColor())) {
                cellStyleData.put("border-" + tag + "-color", border.getColor());
            }
            if ((witdh = (int)(border.getWidth() * 2.0)) > 1) {
                cellStyleData.put("border-" + tag + "-width", witdh + "px;");
            }
            if ("solid".equalsIgnoreCase(style)) {
                if (cellStyleData.size() > 0) {
                    cellStyleData.put("border-" + tag + "-style", style);
                }
            } else {
                cellStyleData.put("border-" + tag + "-style", style);
            }
        }
        return cellStyleData;
    }

    public static WordTableCellBorders createWordCellBorders(Map<String, String> cellStyleData) {
        WordTableCellBorders borders = new WordTableCellBorders();
        if (cellStyleData == null || cellStyleData.size() == 0) {
            return borders;
        }
        String firstKey = cellStyleData.keySet().stream().filter(m -> m.startsWith("border-")).findFirst().orElse(null);
        if (StringUtils.isEmpty((String)firstKey)) {
            return borders;
        }
        HtmlTableCellHelper.createWordCellBordersSingle(cellStyleData, borders.getLeft(), "left");
        HtmlTableCellHelper.createWordCellBordersSingle(cellStyleData, borders.getRight(), "right");
        HtmlTableCellHelper.createWordCellBordersSingle(cellStyleData, borders.getTop(), "top");
        HtmlTableCellHelper.createWordCellBordersSingle(cellStyleData, borders.getBottom(), "bottom");
        return borders;
    }

    private static void createWordCellBordersSingle(Map<String, String> cellStyleData, WordTableCellBorder border, String tag) {
        if (cellStyleData == null) {
            return;
        }
        String style = cellStyleData.get("border-" + tag + "-style");
        if (StringUtils.isEmpty((String)style)) {
            style = cellStyleData.get("border-style");
        }
        if (StringUtils.isEmpty((String)style) || !style.equals("none")) {
            String width;
            String color = cellStyleData.get("border-" + tag + "-color");
            if (StringUtils.isEmpty((String)color) && StringUtils.isNotEmpty((String)(color = cellStyleData.get("border-color")))) {
                String[] colors = color.split(" ");
                if (colors.length > 1 && colors.length < 4) {
                    color = "left".equals(tag) || "right".equals(tag) ? colors[1] : colors[0];
                } else if (colors.length >= 4) {
                    color = "right".equals(tag) ? colors[1] : ("bottom".equals(tag) ? colors[2] : ("left".equals(tag) ? colors[3] : colors[0]));
                }
            }
            if (StringUtils.isNotEmpty((String)color)) {
                border.setColor(color);
            }
            if (StringUtils.isEmpty((String)(width = cellStyleData.get("border-" + tag + "-width")))) {
                width = cellStyleData.get("border-width");
            }
            border.setWidth(TypeUtils.convertValueToDoule(width) / 2.0);
            if ("dashed".equalsIgnoreCase(style)) {
                border.setType(WordConstants.WordBorderType.Dashed.getType());
            } else if ("dotted".equalsIgnoreCase(style)) {
                border.setType(WordConstants.WordBorderType.Dotted.getType());
            } else {
                border.setType(WordConstants.WordBorderType.Solid.getType());
            }
        } else {
            border.setType(WordConstants.WordBorderType.None.getType());
        }
    }

    public static List<WordParagraphNode> createWordCellParagraphList(Element cellElement, String textAlign, Map<String, JSONObject> itemPropertyList) {
        WordParagraphNode paragraphNode;
        ArrayList<WordParagraphNode> paragraphNodes = new ArrayList<WordParagraphNode>(cellElement.children().size());
        ArrayList<Object> textNodeList = new ArrayList<TextNode>(10);
        for (Node node : cellElement.childNodes()) {
            if (node instanceof Element) {
                WordParagraphNode paragraphNode2;
                Element element;
                if (textNodeList.size() > 0) {
                    WordParagraphNode paragraphNode3 = HtmlTableCellHelper.createWordCellParagraphByTextNode(textNodeList);
                    if (paragraphNode3 != null) {
                        paragraphNodes.add(paragraphNode3);
                    }
                    textNodeList = new ArrayList(10);
                }
                if (!"p".equals((element = (Element)node).tagName())) {
                    Element parent = new Element("p");
                    parent.append(element.toString());
                    element = parent;
                }
                if ((paragraphNode2 = HtmlTableCellHelper.createWordCellParagraph(element)) == null) continue;
                if ("center".equalsIgnoreCase(textAlign)) {
                    paragraphNode2.setAlignment(ParagraphAlignment.CENTER);
                } else if ("right".equalsIgnoreCase(textAlign)) {
                    paragraphNode2.setAlignment(ParagraphAlignment.RIGHT);
                }
                HtmlTextHelper.createTextNodeList(paragraphNode2, (Node)element, null, itemPropertyList);
                paragraphNodes.add(paragraphNode2);
                continue;
            }
            if (!(node instanceof TextNode)) continue;
            textNodeList.add((TextNode)node);
        }
        if (textNodeList.size() > 0 && (paragraphNode = HtmlTableCellHelper.createWordCellParagraphByTextNode(textNodeList)) != null) {
            paragraphNodes.add(paragraphNode);
        }
        return paragraphNodes;
    }

    private static WordParagraphNode createWordCellParagraphByTextNode(List<TextNode> textNodeList) {
        WordParagraphNode paragraphNode = null;
        if (textNodeList.size() == 0) {
            return paragraphNode;
        }
        StringBuilder sb = new StringBuilder();
        for (TextNode textNode : textNodeList) {
            sb.append(textNode.text() == null ? "" : textNode.text());
        }
        if (sb.length() > 0) {
            paragraphNode = new WordParagraphNode();
            WordTextNode textNode = new WordTextNode();
            textNode.setContent(HtmlSpecilCharHelper.convertToWordNodeText(sb.toString()));
            paragraphNode.getChilds().add(textNode);
        }
        return paragraphNode;
    }

    private static WordParagraphNode createWordCellParagraph(Element p) {
        double lineHeight;
        int leftChars;
        if (p == null) {
            return null;
        }
        WordParagraphNode paragraphNode = new WordParagraphNode();
        Map<String, String> style = HtmlUtils.fromStyle(p.attr("style"));
        String leftStr = style.get("padding-left");
        if (StringUtils.isNotEmpty((String)leftStr) && (leftChars = TypeUtils.convertValueToInt(HtmlFontHelper.removeHtmlLengthTag(leftStr)) / 40) > 0) {
            paragraphNode.setLeftChars(leftChars);
        }
        paragraphNode.setAlignment(HtmlParagraphHelper.fromParagraphAlignment(p));
        String lineHeightStr = style.get("line-height");
        if (StringUtils.isNotEmpty((String)lineHeightStr) && (lineHeight = TypeUtils.convertValueToDoule(lineHeightStr).doubleValue()) > 0.0) {
            paragraphNode.setLineHegiht(lineHeight);
        }
        return paragraphNode;
    }
}

