/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html.helper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.html.HtmlConvert;
import kd.epm.far.business.fidm.html.base.HtmlUtils;
import kd.epm.far.business.fidm.html.helper.HtmlParagraphHelper;
import kd.epm.far.business.fidm.html.helper.HtmlSpecilCharHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTableCellHelper;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class HtmlTableHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(HtmlTableHelper.class);

    public static Tuple<List<WordTableNode>, Element, String> getTableNodes(String html) {
        ArrayList<WordTableNode> tableNodes = new ArrayList<WordTableNode>(100);
        if (StringUtils.isEmpty((String)html)) {
            return new Tuple(tableNodes, null, null);
        }
        html = HtmlSpecilCharHelper.convertToHtmlTextByEmptyChar(html);
        HtmlConvert htmlConvert = new HtmlConvert();
        Document doc = Jsoup.parse((String)html);
        Element body = doc.body();
        for (Element element : body.children()) {
            WordTableNode tableNode;
            String tagName = element.tagName().toLowerCase();
            if (!"table".equals(tagName) || (tableNode = htmlConvert.createTableNode(element, true)) == null) continue;
            tableNodes.add(tableNode);
        }
        return new Tuple(tableNodes, (Object)body, null);
    }

    public static String toNewTableHtml(WordTableNode tableNode, String id) {
        String html = "";
        if (tableNode == null) {
            return html;
        }
        Document doc = Jsoup.parse((String)"");
        Element body = doc.body();
        Element tableElement = HtmlTableHelper.toTableHtml(tableNode, body);
        if (tableElement == null) {
            return "";
        }
        if (StringUtils.isNotEmpty((String)id)) {
            tableElement.attr("id", id);
        }
        return HtmlSpecilCharHelper.convertToHtmlBody(body.html());
    }

    public static Element toTableHtml(WordTableNode tableNode, Element parent) {
        Element table = new Element("table");
        try {
            LinkedHashMap<String, String> tableStyleData = new LinkedHashMap<String, String>(2);
            tableStyleData.put("border-collapse", "collapse");
            tableStyleData.put("border-style", "none");
            if (tableNode.getWidth() <= 0.0) {
                tableStyleData.put("width", "99.7797%");
            } else if (WordConstants.WordWidthType.Percentage.getType() == tableNode.getWidthType()) {
                tableStyleData.put("width", tableNode.getWidth() * 100.0 + "%");
            } else {
                tableStyleData.put("width", tableNode.getHtmlWidth() + "px");
            }
            if (tableNode.getAlignment() == 2) {
                tableStyleData.put("float", "none");
                tableStyleData.put("margin-left", "auto");
                tableStyleData.put("margin-right", "auto");
            } else if (tableNode.getAlignment() == 3) {
                tableStyleData.put("float", "right");
                tableStyleData.put("margin-left", "auto");
                tableStyleData.put("margin-right", "auto");
            } else if (tableNode.getLeftInd() != 0.0) {
                tableStyleData.put("margin-left", tableNode.getLeftInd() * 36.14 / 567.0 + "px");
            }
            HtmlUtils.setCommonElementAttribute(tableNode, table);
            table.attr("style", HtmlUtils.toStyle(tableStyleData));
            table.attr("border", "1");
            if (StringUtils.isNotEmpty((String)tableNode.getId()) && StringUtils.isNotEmpty((String)tableNode.getDataModeuleId())) {
                table.attr("class", "bookmark");
            }
            parent.appendChild((Node)table);
            parent = table;
            Element tbody = new Element("tbody");
            parent.appendChild((Node)tbody);
            for (int rowIndex = 0; rowIndex < tableNode.getChilds().size(); ++rowIndex) {
                WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
                if (rowNode == null) continue;
                Element tr = new Element("tr");
                LinkedHashMap<String, String> rowStyleData = new LinkedHashMap<String, String>(2);
                if (rowNode.getHeight() > 0.0) {
                    rowStyleData.put("height", rowNode.getHtmlHeight() + "px");
                }
                if (rowStyleData.size() > 0) {
                    tr.attr("style", HtmlUtils.toStyle(rowStyleData));
                }
                tbody.appendChild((Node)tr);
                for (int cellIndex = 0; cellIndex < rowNode.getChilds().size(); ++cellIndex) {
                    String marginStr;
                    WordTableCellNode cellNode = (WordTableCellNode)rowNode.getChilds().get(cellIndex);
                    if (cellNode == null) continue;
                    Element td = new Element("td");
                    LinkedHashMap<String, String> cellStyleData = new LinkedHashMap<String, String>(2);
                    if (StringUtils.isNotEmpty((String)cellNode.getFontColor())) {
                        cellStyleData.put("color", cellNode.getFontColor());
                    }
                    if (StringUtils.isNotEmpty((String)cellNode.getHightlightColor())) {
                        cellStyleData.put("background-color", cellNode.getHightlightColor());
                    }
                    if (cellNode.getWidth() >= 0.0) {
                        if (WordConstants.WordWidthType.Percentage.getType() == tableNode.getWidthType()) {
                            cellStyleData.put("width", cellNode.getWidth() * 100.0 + "%");
                        } else {
                            cellStyleData.put("width", cellNode.getHtmlWidth() + "px");
                        }
                    }
                    cellStyleData.put("word-break", "break-all");
                    cellStyleData.putAll(HtmlTableCellHelper.toTableCellBorderStyles(cellNode));
                    if (tableNode.getMargins() != null && !StringUtils.isEmpty((String)(marginStr = HtmlTableCellHelper.getCellMargin(tableNode.getMargins())))) {
                        cellStyleData.put("padding", marginStr);
                    }
                    if (cellStyleData.size() > 0) {
                        td.attr("style", HtmlUtils.toStyle(cellStyleData));
                    }
                    if (cellNode.getColumnSpan() > 1) {
                        td.attr("colspan", String.valueOf(cellNode.getColumnSpan()));
                    }
                    if (cellNode.getRowSpan() > 1) {
                        td.attr("rowspan", String.valueOf(cellNode.getRowSpan()));
                    }
                    tr.appendChild((Node)td);
                    for (WordNode paragraph : cellNode.getChilds()) {
                        WordParagraphNode paragraphNode = (WordParagraphNode)paragraph;
                        if (paragraphNode == null) continue;
                        HtmlParagraphHelper.toParagraphHtml(paragraphNode, td);
                    }
                }
                HtmlTableHelper.resetTdRowspan(tr);
            }
        }
        catch (Exception ex) {
            logger.error("dm html createtable error", (Throwable)ex);
        }
        return table;
    }

    private static void resetTdRowspan(Element tr) {
        Element td;
        if (tr == null) {
            return;
        }
        Element fisrtTd = tr.children().first();
        if (fisrtTd == null) {
            return;
        }
        String fisrtRowspan = fisrtTd.attr("rowspan");
        if (StringUtils.isEmpty((String)fisrtRowspan)) {
            return;
        }
        for (Node tdItem : tr.children()) {
            td = (Element)tdItem;
            if (td == null) continue;
            String rowspanTd = td.attr("rowspan");
            if (StringUtils.isEmpty((String)rowspanTd)) {
                return;
            }
            if (fisrtRowspan.equals(rowspanTd)) continue;
            return;
        }
        for (Node tdItem : tr.children()) {
            td = (Element)tdItem;
            if (td == null) continue;
            td.removeAttr("rowspan");
        }
    }
}

