/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.html.base.HtmlUtils;
import kd.epm.far.business.fidm.html.helper.HtmlFontHelper;
import kd.epm.far.business.fidm.html.helper.HtmlSpecilCharHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordImageNode;
import kd.epm.far.business.fidm.word.dto.WordModuleNode;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.ColorStyleHelper;
import kd.epm.far.business.fidm.word.helper.WordBookmarkHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class HtmlTextHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(HtmlTextHelper.class);

    public static Element toTextHtml(WordTextNode textNode, Element parent) {
        Map<String, String> styleData;
        boolean isModule;
        if (textNode.getChilds().size() > 0) {
            for (WordNode node : textNode.getChilds()) {
                if (node.getType() == WordConstants.WordNodeType.Image.getType()) {
                    try {
                        WordImageNode image = (WordImageNode)node;
                        String base64 = "data:image/png;base64," + Base64.getEncoder().encodeToString(image.getData());
                        Element imageElement = new Element("img");
                        HtmlUtils.setCommonElementAttribute(image, imageElement);
                        imageElement.attr("src", base64);
                        imageElement.attr("alt", image.getDescription());
                        imageElement.attr("width", String.valueOf(image.getHtmlWidth()));
                        imageElement.attr("height", String.valueOf(image.getHtmlHeight()));
                        parent.appendChild((Node)imageElement);
                    }
                    catch (Exception ex) {
                        logger.error("dm htmlconvert fail", (Throwable)ex);
                    }
                    continue;
                }
                if (node.getType() != WordConstants.WordNodeType.PageBreak.getType()) continue;
                HtmlTextHelper.toPageBreakHtml(parent);
            }
        }
        if (textNode.getUnderline()) {
            Element span = new Element("span");
            span.attr("style", "text-decoration: underline;");
            parent.appendChild((Node)span);
            parent = span;
        }
        if (textNode.getItalic()) {
            Element em = new Element("em");
            parent.appendChild((Node)em);
            parent = em;
        }
        if ("superscript".equals(textNode.getVerticalAlignment())) {
            Element sup = new Element("sup");
            parent.appendChild((Node)sup);
            parent = sup;
        } else if ("subscript".equals(textNode.getVerticalAlignment())) {
            Element sub = new Element("sub");
            parent.appendChild((Node)sub);
            parent = sub;
        }
        if (textNode.getBold()) {
            Element strong = new Element("strong");
            parent.appendChild((Node)strong);
            parent = strong;
        }
        if (isModule = HtmlTextHelper.isModule(textNode)) {
            Element input = new Element("input");
            HtmlUtils.setCommonElementAttribute(textNode, input);
            if (textNode.getBookMarkKeys().size() > 0) {
                input.attr("id", textNode.getBookMarkKeys().get(textNode.getBookMarkKeys().size() - 1));
            }
            input.attr("class", "bookmark");
            input.attr("type", "button");
            input.attr("value", textNode.getContent() == null ? "" : textNode.getContent().replace("{", "").replace("}", ""));
            styleData = HtmlTextHelper.toTextFont(textNode);
            if (styleData.size() > 0) {
                input.attr("style", HtmlUtils.toStyle(styleData));
            }
            parent.appendChild((Node)input);
            parent = input;
        } else {
            Element span = new Element("span");
            styleData = HtmlTextHelper.toTextFont(textNode);
            if (styleData.size() > 0) {
                span.attr("style", HtmlUtils.toStyle(styleData));
            }
            HtmlUtils.setCommonElementAttribute(textNode, span);
            span.text(HtmlSpecilCharHelper.convertToHtmlText(textNode.getContent()));
            parent.appendChild((Node)span);
            parent = span;
        }
        return parent;
    }

    private static boolean isModule(WordTextNode textNode) {
        if (textNode.getBookMarkKeys().size() > 0) {
            for (String bookKey : textNode.getBookMarkKeys()) {
                if (!WordBookmarkHelper.isOwnerBookmark(bookKey)) continue;
                return true;
            }
        }
        return textNode.getContent().startsWith("{{") && textNode.getContent().endsWith("}}") && textNode.getChilds().size() == 0;
    }

    public static Map<String, String> toTextFont(WordTextNode textNode) {
        String hightlightColor;
        String fontColor;
        double fontSize;
        LinkedHashMap<String, String> styleData = new LinkedHashMap<String, String>(2);
        String fontfamily = HtmlFontHelper.convertToHtmlFontFamily(textNode.getFontFamily());
        if (StringUtils.isNotEmpty((String)fontfamily)) {
            styleData.put("font-family", fontfamily);
        }
        if ((fontSize = HtmlFontHelper.convertToHtmlFontSize(fontfamily, textNode)) > 0.0) {
            styleData.put("font-size", fontSize + "pt");
        }
        if (StringUtils.isNotEmpty((String)(fontColor = textNode.getFontColor()))) {
            styleData.put("color", fontColor);
        }
        if (StringUtils.isNotEmpty((String)(hightlightColor = textNode.getHightlightColor()))) {
            styleData.put("background-color", hightlightColor);
        }
        if (textNode.getStrikeThrough()) {
            styleData.put("text-decoration", "line-through");
        } else if (textNode.getUnderline()) {
            styleData.put("text-decoration", " underline;");
        }
        return styleData;
    }

    private static void toPageBreakHtml(Element parent) {
        parent.html("<!-- pagebreak -->");
    }

    public static void createTextNodeList(WordParagraphNode paragraphNode, Node parent, Map<String, String> parentStyle, Map<String, JSONObject> itemPropertyList) {
        HashMap<String, String> oldParentStyle = new HashMap<String, String>(2);
        if (parentStyle == null) {
            parentStyle = new HashMap<String, String>(2);
        }
        for (Map.Entry<String, String> entry : parentStyle.entrySet()) {
            oldParentStyle.put(entry.getKey(), entry.getValue());
        }
        for (Node node : parent.childNodes()) {
            Object textNode;
            if (node instanceof TextNode) {
                String text = ((TextNode)node).text();
                if (!StringUtils.isNotEmpty((String)text)) continue;
                Element textElement = new Element("span");
                textElement.text(text);
                textNode = HtmlTextHelper.createTextNode(textElement, parentStyle, itemPropertyList);
                if (textNode == null) continue;
                paragraphNode.getChilds().add((WordNode)textNode);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            ArrayList<String> removeKeys = new ArrayList<String>(2);
            if ("strong".equalsIgnoreCase(element.tagName())) {
                parentStyle.put("strong", "1");
                removeKeys.add("strong");
                HtmlTextHelper.createTextNodeListForSpan(element, parentStyle, removeKeys);
            } else if ("em".equalsIgnoreCase(element.tagName())) {
                parentStyle.put("italic", "1");
                removeKeys.add("italic");
            } else if ("sup".equalsIgnoreCase(element.tagName())) {
                parentStyle.put("sup", "1");
                removeKeys.add("sup");
            } else if ("sub".equalsIgnoreCase(element.tagName())) {
                parentStyle.put("sub", "1");
                removeKeys.add("sub");
            } else if ("span".equalsIgnoreCase(element.tagName())) {
                HtmlTextHelper.createTextNodeListForSpan(element, parentStyle, removeKeys);
            }
            if (element.childNodes().size() > 0) {
                HtmlTextHelper.createTextNodeList(paragraphNode, (Node)element, parentStyle, itemPropertyList);
                for (String key : removeKeys) {
                    if (oldParentStyle.containsKey(key)) {
                        parentStyle.put(key, (String)oldParentStyle.get(key));
                        continue;
                    }
                    parentStyle.remove(key);
                }
                continue;
            }
            textNode = HtmlTextHelper.createTextNode(element, parentStyle, itemPropertyList);
            if (textNode == null) continue;
            paragraphNode.getChilds().add((WordNode)textNode);
        }
    }

    public static void createTextNodeListForSpan(Element element, Map<String, String> parentStyle, List<String> removeKeys) {
        if (element == null) {
            return;
        }
        String spanStypleStr = element.attr("style");
        if (parentStyle.get("span") != null) {
            spanStypleStr = parentStyle.get("span") + ";" + (spanStypleStr == null ? "" : spanStypleStr);
        }
        parentStyle.put("span", spanStypleStr);
        removeKeys.add("span");
    }

    public static WordTextNode createTextNode(Element element, Map<String, String> parentStyle, Map<String, JSONObject> itemPropertyList) {
        List<WordNode> images;
        double fontSize;
        String stypleStr;
        WordTextNode textNode = new WordTextNode();
        String string = stypleStr = parentStyle.get("span") == null ? "" : parentStyle.get("span");
        if (element.attr("style") != null) {
            stypleStr = stypleStr + ";" + element.attr("style");
        }
        Map<String, String> style = HtmlUtils.fromStyle(stypleStr);
        String fontfamily = style.get("font-family");
        String fontSizeStr = style.get("font-size");
        String fontColorStr = style.get("color");
        String hightlightColorStr = style.get("background-color");
        boolean isBold = "1".equals(parentStyle.get("strong"));
        boolean isItalic = "1".equals(parentStyle.get("italic"));
        boolean isSup = "1".equals(parentStyle.get("sup"));
        boolean isSub = "1".equals(parentStyle.get("sub"));
        Map<String, String> mutilValueStyle = HtmlUtils.fromStyleForMutilValue(stypleStr);
        boolean isStrikeThrough = mutilValueStyle.get("text-decoration") == null ? false : mutilValueStyle.get("text-decoration").contains("line-through");
        boolean underline = mutilValueStyle.get("text-decoration") == null ? false : mutilValueStyle.get("text-decoration").contains("underline");
        HtmlUtils.setCommonNodeProperty(element, textNode);
        String wordFontfamily = HtmlFontHelper.convertToWordFontFamily(fontfamily);
        if (StringUtils.isNotEmpty((String)wordFontfamily)) {
            textNode.setFontFamily(wordFontfamily);
        }
        if ((fontSize = HtmlFontHelper.convertToWordFontSize(fontfamily, fontSizeStr)) > 0.0) {
            textNode.setFontSize(fontSize);
        }
        textNode.setFontColor(ColorStyleHelper.getHexadecimalColor(fontColorStr));
        textNode.setHightlightColor(ColorStyleHelper.getHexadecimalColor(hightlightColorStr));
        textNode.setBold(isBold);
        textNode.setItalic(isItalic);
        textNode.setStrikeThrough(isStrikeThrough);
        textNode.setUnderline(underline);
        if (isSub) {
            textNode.setVerticalAlignment("subscript");
        }
        if (isSup) {
            textNode.setVerticalAlignment("superscript");
        }
        textNode.setContent(HtmlSpecilCharHelper.convertToWordNodeText(element.text()));
        String instrText = HtmlTextHelper.fromInstrText(element);
        textNode.setInstrText(instrText);
        if ("input".equalsIgnoreCase(element.tagName()) && "bookmark".equalsIgnoreCase(element.attr("class")) && "button".equalsIgnoreCase(element.attr("type"))) {
            String value;
            String id = element.attr("id");
            if (StringUtils.isNotEmpty((String)id)) {
                textNode.getBookMarkKeys().add(id);
            }
            if (StringUtils.isNotEmpty((String)(value = element.attr("value")))) {
                textNode.setContent(HtmlSpecilCharHelper.convertToWordNodeText(value));
            }
        }
        if ((images = HtmlTextHelper.createImageAndModuleNode(element, itemPropertyList)).size() > 0) {
            textNode.getChilds().addAll(images);
        }
        return textNode;
    }

    private static String fromInstrText(Element element) {
        String instrText = "";
        return instrText;
    }

    private static List<WordNode> createImageAndModuleNode(Element element, Map<String, JSONObject> itemPropertyList) {
        if (itemPropertyList == null) {
            itemPropertyList = new LinkedHashMap<String, JSONObject>(2);
        }
        ArrayList<WordNode> imageNodes = new ArrayList<WordNode>(2);
        Elements images = element.select("img");
        for (Element img : images) {
            double height;
            double width = TypeUtils.convertValueToDoule(img.attr("width"));
            if (width <= 0.0) {
                width = 530.0;
            }
            if ((height = TypeUtils.convertValueToDoule(img.attr("height")).doubleValue()) <= 0.0) {
                height = 300.0;
            }
            String moduleId = img.attr("data-module-id");
            JSONObject itemProperty = itemPropertyList.get(moduleId);
            if (StringUtils.isNotEmpty((String)moduleId) && itemProperty != null) {
                WordModuleNode moduleNode = new WordModuleNode();
                moduleNode.setWidth(width / 35.3);
                moduleNode.setHeight(height / 35.3);
                itemProperty.put("width", (Object)((int)moduleNode.getWidth()));
                itemProperty.put("height", (Object)((int)moduleNode.getHeight()));
                moduleNode.setModuleProperties(itemPropertyList.get(moduleId));
                HtmlUtils.setCommonNodeProperty(img, moduleNode);
                imageNodes.add(moduleNode);
                continue;
            }
            WordImageNode imageNode = new WordImageNode();
            imageNode.setName("");
            String srcData = img.attr("src");
            if (StringUtils.isNotEmpty((String)srcData)) {
                byte[] fileData = DisclosureFileHelper.base64ConvertToBytes(srcData);
                if (fileData == null) {
                    fileData = DisclosureFileHelper.urlConvertToBytes(srcData);
                }
                if (fileData != null) {
                    imageNode.setData(fileData);
                }
            }
            imageNode.setWidth(width / 1.28);
            imageNode.setHeight(height / 1.28);
            imageNode.setDescription(img.attr("alt"));
            HtmlUtils.setCommonNodeProperty(img, imageNode);
            imageNodes.add(imageNode);
        }
        return imageNodes;
    }

    public static String getText(Node node) {
        String content = null;
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            String text = textNode.text();
            content = HtmlSpecilCharHelper.convertToWordNodeText(text);
        } else if (node instanceof Element) {
            Element element = (Element)node;
            String text = element.text();
            content = HtmlSpecilCharHelper.convertToWordNodeText(text);
        }
        return content;
    }

    public static void setText(Node node, String text) {
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            textNode.text(text);
        } else if (node instanceof Element) {
            Element element = (Element)node;
            element.text(text);
        }
    }
}

