/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.html.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.html.helper.HtmlSpecilCharHelper;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordTocNode;
import kd.epm.far.common.common.util.GlobalIdUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlTocHelper {
    public static String refreshToc(String html) {
        if (StringUtils.isEmpty((String)html)) {
            return html;
        }
        String newHtml = HtmlSpecilCharHelper.convertToHtmlTextByEmptyChar(html);
        Document doc = Jsoup.parse((String)newHtml);
        Element body = doc.body();
        Elements elements = body.select(".mce-toc");
        ArrayList<Element> tocList = new ArrayList<Element>(5);
        for (Element element : elements) {
            String moduleId = element.attr("data-module-id");
            String bookmarkKey = element.attr("id");
            if (StringUtils.isEmpty((String)bookmarkKey) && StringUtils.isEmpty((String)moduleId)) continue;
            tocList.add(element);
        }
        if (tocList.size() == 0) {
            return html;
        }
        for (Element element : tocList) {
            HtmlTocHelper.createToc(body, element);
        }
        return HtmlSpecilCharHelper.convertToHtmlBody(body.html());
    }

    public static void createToc(Element body, Element tocElement) {
        tocElement.tagName("div");
        tocElement.removeAttr("style");
        tocElement.removeAttr("type");
        tocElement.removeAttr("value");
        tocElement.attr("class", "mce-toc");
        tocElement.attr("contenteditable", "false");
        tocElement.attr("data-mce-selected", "0");
        StringBuilder tocHtml = new StringBuilder();
        List<WordTocNode> tocNodes = HtmlTocHelper.createTocNode(body);
        if (tocNodes.size() == 0) {
            tocElement.html(tocHtml.toString());
            return;
        }
        tocHtml.append("<h2>");
        tocHtml.append(WordConstants.OtherLanguage.Toc.getName());
        tocHtml.append("</h2>");
        tocHtml.append("<ul>");
        int prevLevel = (Integer)Collections.min(tocNodes.stream().map(m -> m.getLevel()).collect(Collectors.toList()));
        Integer nextLevel = 0;
        for (int i = 0; i < tocNodes.size(); ++i) {
            int j;
            WordTocNode h = tocNodes.get(i);
            Element item = h.getElement();
            String id = h.getId();
            item.attr("id", id);
            nextLevel = i < tocNodes.size() - 1 ? Integer.valueOf(tocNodes.get(i + 1).getLevel()) : null;
            if (prevLevel == h.getLevel()) {
                tocHtml.append("<li>");
            } else {
                for (j = prevLevel; j < h.getLevel(); ++j) {
                    tocHtml.append("<ul><li>");
                }
            }
            tocHtml.append("<a href=\"#");
            tocHtml.append(h.getId());
            tocHtml.append("\">");
            tocHtml.append(h.getTitle());
            tocHtml.append("</a>");
            if (nextLevel == null || nextLevel.intValue() == h.getLevel()) {
                tocHtml.append("</li>");
                if (nextLevel == null) {
                    tocHtml.append("</ul>");
                }
            } else {
                for (j = h.getLevel(); j > nextLevel; --j) {
                    tocHtml.append("</li></ul><li>");
                }
            }
            prevLevel = h.getLevel();
        }
        tocHtml.append("</ul>");
        String last = tocHtml.toString().replace("<li></li>", "").replace("<ul></ul>", "");
        tocElement.html(last);
    }

    public static List<WordTocNode> createTocNode(Element body) {
        ArrayList<WordTocNode> tocNodes = new ArrayList<WordTocNode>(2);
        if (body == null) {
            return tocNodes;
        }
        int maxLevel = 3;
        ArrayList<String> tagList = new ArrayList<String>(2);
        for (int i = 0; i < maxLevel; ++i) {
            tagList.add("h" + String.valueOf(i + 1));
        }
        Elements elements = body.select(String.join((CharSequence)",", tagList));
        for (Element element : elements) {
            WordTocNode tocNode = new WordTocNode();
            tocNode.setId(StringUtils.isEmpty((String)element.attr("id")) ? String.valueOf(GlobalIdUtil.genGlobalLongId()) : element.attr("id"));
            tocNode.setLevel(Integer.parseInt(element.tagName().replace("h", "").replace("H", "")));
            tocNode.setTitle(element.text());
            tocNode.setElement(element);
            if (tocNode.getLevel() == 2 && ModuleEnum.TOC.getName().equalsIgnoreCase(tocNode.getTitle()) || ModuleEnum.TOC.getName().equalsIgnoreCase(tocNode.getTitle()) && !StringUtils.isEmpty((String)element.attr("id"))) continue;
            tocNodes.add(tocNode);
        }
        return tocNodes;
    }
}

