/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureOldModuleHelper;
import kd.epm.far.business.fidm.module.EBReportSectionHelper;
import kd.epm.far.business.fidm.module.ReportSectionHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.common.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class DisclosureModuleHelper {
    private static final String ModuleSelectFieldString = "id,number,name,template.id,scope,copyfrom,properties,type";

    public static JSONObject getModule(Long dmModelId, Long moduleId) {
        DynamicObject moduleDy = QueryServiceHelper.queryOne((String)"fidm_modulerepository", (String)ModuleSelectFieldString, (QFilter[])new QFilter("id", "=", (Object)moduleId).toArray());
        if (moduleDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728", (String)"DisclosureServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String moduleNumber = moduleDy.getString("number");
        String moduleName = moduleDy.getString("name");
        String modulePropertiesStr = moduleDy.getString("properties");
        HashMap<String, Object> moduleMap = new HashMap<String, Object>(2);
        moduleMap.put("id", moduleId);
        moduleMap.put("number", moduleNumber);
        moduleMap.put("name", moduleName);
        moduleMap.put("properties", modulePropertiesStr);
        JSONObject moduleProperties = DisclosureOldModuleHelper.converToNewVersion(dmModelId, 0L, moduleMap);
        moduleProperties.put("name", (Object)(moduleNumber + "-" + moduleName));
        return moduleProperties;
    }

    public static List<DimensionInfo> getPreviewVars(Long dmModelId, JSONObject module) {
        ArrayList<DimensionInfo> filterDims = new ArrayList<DimensionInfo>(100);
        String moduleType = DisclosureJsonHelper.getValue(module, "type", "");
        if (kd.epm.far.business.common.enums.ModuleEnum.REPORT_SECTION.getType().equals(moduleType)) {
            DisclosureModuleHelper.previewModuleByReportSection(dmModelId, module, filterDims);
        } else if (kd.epm.far.business.common.enums.ModuleEnum.EB_REPORT_SECTION.getType().equals(moduleType)) {
            DisclosureModuleHelper.previewModuleByEBReportSection(dmModelId, module, filterDims);
        }
        Long datasetId = DisclosureJsonHelper.getValue(module, "dataset", "id", 0L);
        if (datasetId > 0L) {
            DisclosureModuleHelper.previewModuleForDimsAndMembers(dmModelId, datasetId, module, filterDims);
        }
        return filterDims;
    }

    public static String getEBDataset(Long dmModelId, JSONObject module) {
        String defaultDataSet = "";
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(modelInfo.getModelType())) {
            String moduleType = DisclosureJsonHelper.getValue(module, "type", "");
            if (kd.epm.far.business.common.enums.ModuleEnum.EB_REPORT_SECTION.getType().equals(moduleType)) {
                defaultDataSet = DisclosureJsonHelper.getValue(module, "reportSection", "defaultDataSet", "");
            } else {
                Long datasetId = DisclosureJsonHelper.getValue(module, "dataset", "id", 0L);
                if (datasetId > 0L) {
                    IModel strategy = ModelStrategy.getStrategy(DisModelTypeEnum.EB);
                    defaultDataSet = strategy.getDefaultDataSetByModelIdAndDataSetId(modelInfo.getModelId(), datasetId);
                }
            }
        }
        return defaultDataSet;
    }

    public static void previewModuleForDimsAndMembers(Long dmModelId, Long datasetId, JSONObject moduleProperties, List<DimensionInfo> filterDims) {
        if (datasetId == null || datasetId <= 0L) {
            return;
        }
        Map<String, Object> varAndDimResult = DatasetServiceHelper.getVarAndDimVars(dmModelId, datasetId, 0L, false);
        List shortNumberList = (List)varAndDimResult.get("shortNumberList");
        if (shortNumberList.contains("P") && shortNumberList.contains("S")) {
            shortNumberList.remove("S");
            shortNumberList.add(shortNumberList.indexOf("P"), "S");
        }
        JSONArray dimparams = DisclosureJsonHelper.getJSONArray(moduleProperties, "dataset", "dimParams");
        List<DimensionInfo> dimList = new ModelStrategyEx(dmModelId).getDim().getDimList();
        for (String shortNumber : shortNumberList) {
            JSONObject member;
            Object findObject;
            DimensionInfo dim = dimList.stream().filter(x -> x.getShortNumber().equalsIgnoreCase(shortNumber)).findAny().orElse(null);
            if (dim == null) continue;
            DimensionInfo findDim = filterDims.stream().filter(x -> x.getShortNumber().equalsIgnoreCase(shortNumber)).findAny().orElse(null);
            if (findDim == null) {
                filterDims.add(dim);
                findDim = dim;
            } else if (findDim.getMembers().size() > 0) continue;
            if (dimparams == null || (findObject = dimparams.stream().filter(g -> dim.getNumber().equals(((JSONObject)g).getString("number"))).findAny().orElse(null)) == null || (member = ((JSONObject)findObject).getJSONObject("member")) == null || StringUtils.isEmpty((String)member.getString("id"))) continue;
            DimMemberInfo memberInfo = new DimMemberInfo();
            memberInfo.setId(member.getLong("id"));
            memberInfo.setNumber(member.getString("number"));
            memberInfo.setName(member.getString("name"));
            findDim.getMembers().add(memberInfo);
        }
    }

    public static void previewModuleByReportSection(Long dmModelId, JSONObject moduleProperties, List<DimensionInfo> filterDims) {
        if (moduleProperties == null) {
            return;
        }
        String moduleType = DisclosureJsonHelper.getValue(moduleProperties, "type", "");
        if (!kd.epm.far.business.common.enums.ModuleEnum.REPORT_SECTION.getType().equals(moduleType)) {
            return;
        }
        List<DimensionInfo> reportDims = ReportSectionHelper.getDimList(dmModelId, moduleProperties);
        for (DimensionInfo reportSection : reportDims) {
            DimensionInfo find = DimensionUtils.getDimByNumber(filterDims, reportSection.getNumber());
            if (find == null) {
                filterDims.add(reportSection);
                continue;
            }
            if (reportSection.getMembers().size() <= 0 || find.getMembers().size() != 0) continue;
            find.setMembers(reportSection.getMembers());
        }
    }

    public static void previewModuleByEBReportSection(Long dmModelId, JSONObject moduleProperties, List<DimensionInfo> filterDims) {
        if (moduleProperties == null) {
            return;
        }
        String moduleType = DisclosureJsonHelper.getValue(moduleProperties, "type", "");
        if (!kd.epm.far.business.common.enums.ModuleEnum.EB_REPORT_SECTION.getType().equals(moduleType)) {
            return;
        }
        List<DimensionInfo> reportDims = EBReportSectionHelper.getDimList(dmModelId, moduleProperties);
        for (DimensionInfo reportSection : reportDims) {
            DimensionInfo find = DimensionUtils.getDimByNumber(filterDims, reportSection.getNumber());
            if (find == null) {
                filterDims.add(reportSection);
                continue;
            }
            if (reportSection.getMembers().size() <= 0 || find.getMembers().size() != 0) continue;
            find.setMembers(reportSection.getMembers());
        }
    }

    public static List<Map<String, Object>> getModuleList(Long dmModelId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String catalogFields = "id,name,number,parent,catalogtype";
        QFBuilder catalogBuilder = new QFBuilder("model", "=", (Object)dmModelId);
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"fidm_modulecatalog", (String)catalogFields, (QFilter[])catalogBuilder.toArray(), (String)"level,sequence");
        if (CollectionUtils.isEmpty((Collection)catalogs)) {
            return result;
        }
        for (DynamicObject catalogDy : catalogs) {
            HashMap<String, String> catalog = new HashMap<String, String>(6);
            catalog.put("id", catalogDy.getString("id"));
            if ("0".equals(catalogDy.getString("parent"))) {
                catalog.put("name", ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u7c7b", (String)"AbstractModuleTreePlugin_6", (String)"epm-far-business", (Object[])new Object[0]));
            } else {
                catalog.put("name", catalogDy.getString("name"));
            }
            catalog.put("number", catalogDy.getString("number"));
            catalog.put("parent", catalogDy.getString("parent"));
            catalog.put("type", "");
            catalog.put("moduleType", "0");
            if ("root".equals(catalogDy.getString("number")) && "2".equals(catalogDy.getString("catalogtype"))) continue;
            result.add(catalog);
        }
        String moduleFields = "id,name,number,catalog.id,type,scope,comefrom";
        QFBuilder moduleBuilder = new QFBuilder("model", "=", (Object)dmModelId).add("status", "=", (Object)"1");
        moduleBuilder.add("catalog.id", "!=", (Object)0L);
        List<Long> noPermIds = PermClassBaseHelper.getNoPermIds(dmModelId, "fidm", "fidm_modulerepository");
        if (noPermIds.size() > 0) {
            moduleBuilder.and(new QFilter("id", "not in", noPermIds));
        }
        DynamicObjectCollection modules = QueryServiceHelper.query((String)"fidm_modulerepository", (String)moduleFields, (QFilter[])moduleBuilder.toArray());
        for (DynamicObject moduleDy : modules) {
            String modelType = moduleDy.getString("type");
            String scope = moduleDy.getString("scope").trim();
            String comefrom = moduleDy.getString("comefrom").trim();
            if (!"1".equalsIgnoreCase(scope)) {
                if (!"2".equalsIgnoreCase(scope)) continue;
                if (ModuleEnum.Analysis_PIE_CHART_PIE.getType().equalsIgnoreCase(modelType) || ModuleEnum.Analysis_PIE_CHART_PIE_ROSE.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.PIE.getType();
                } else if (ModuleEnum.Analysis_PIE_CHART_DOUGHNUT.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.DOUGHNUT.getType();
                } else if (ModuleEnum.Analysis_COMPONENT_TABLE.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.TABLE.getType();
                } else if (ModuleEnum.Analysis_BAR_CHART_BAR.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.STACKED_COLUMNAR.getType();
                } else if (ModuleEnum.Analysis_BAR_CHART_BAR_AREATA.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.CLUSTERED_COLUMNAR.getType();
                } else if (ModuleEnum.Analysis_BAR_CHART_BAR_POLYLINE_STACK.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.LINE_STACKED_COLUMNAR.getType();
                } else if (ModuleEnum.Analysis_BAR_CHART_BAR_POLYLINE_AREATA.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType();
                } else if (ModuleEnum.Analysis_BAR_CHART_AREATA_BAR_CHART.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.CLUSTERED_BAR.getType();
                } else if (ModuleEnum.Analysis_BAR_CHART_STACK_BAR_CHART.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.STACKED_BAR.getType();
                } else if (ModuleEnum.Analysis_LINE_CHART_STACK_SQUARE.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.AREA.getType();
                } else if (ModuleEnum.Analysis_LINE_CHART_POLYLINE.getType().equalsIgnoreCase(modelType)) {
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.LINE.getType();
                } else {
                    if (!ModuleEnum.Analysis_DATA_POINT.getType().equalsIgnoreCase(modelType)) continue;
                    modelType = kd.epm.far.business.common.enums.ModuleEnum.VAR.getType();
                }
            }
            HashMap<String, String> module = new HashMap<String, String>(6);
            module.put("id", moduleDy.getString("id"));
            module.put("name", moduleDy.getString("name"));
            module.put("number", moduleDy.getString("number"));
            module.put("parent", moduleDy.getString("catalog.id"));
            module.put("scope", scope);
            module.put("comefrom", comefrom);
            module.put("type", modelType);
            module.put("moduleType", "1");
            result.add(module);
        }
        return result;
    }
}

