/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DatalabelEnum;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.ReportSectionHelper;
import kd.epm.far.business.fidm.module.dto.CommonProperty;
import kd.epm.far.business.fidm.module.dto.ModuleProperty;
import kd.epm.far.common.common.json.JacksonUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class DisclosureOldModuleHelper {
    public static final String commonPropertyName = "commonProperty";
    public static final String specialPropertyName = "specialProperty";
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureOldModuleHelper.class);

    public static JSONObject converToNewVersion(Long dmModelId, Long chapterId, Map<String, Object> oldModuleDy) {
        if (oldModuleDy == null) {
            return null;
        }
        String modulePropertiesStr = oldModuleDy.get("properties") == null ? "" : oldModuleDy.get("properties").toString();
        String moduleType = oldModuleDy.get("type") == null ? "" : oldModuleDy.get("type").toString();
        String moduleId = oldModuleDy.get("id") == null ? "" : oldModuleDy.get("id").toString();
        String moduleNumber = oldModuleDy.get("number") == null ? "" : oldModuleDy.get("number").toString();
        String moduleName = oldModuleDy.get("name") == null ? "" : oldModuleDy.get("name").toString();
        JSONObject newModule = new JSONObject();
        newModule.put("id", (Object)moduleId);
        newModule.put("number", (Object)moduleNumber);
        newModule.put("name", (Object)moduleName);
        if (StringUtils.isEmpty((String)modulePropertiesStr) || modulePropertiesStr.equals("null")) {
            if (ModuleEnum.TOC.getType().equals(moduleType)) {
                return newModule;
            }
            return null;
        }
        JSONObject oldModule = JSON.parseObject((String)modulePropertiesStr);
        if (oldModule.get((Object)commonPropertyName) == null && oldModule.get((Object)specialPropertyName) == null) {
            DisclosureOldModuleHelper.repair(oldModule);
            DisclosureJsonHelper.convertLongToStringFromJson(oldModule);
            return oldModule;
        }
        String type = DisclosureJsonHelper.getValue(oldModule, specialPropertyName, "type", "");
        newModule.put("type", (Object)DisclosureJsonHelper.getValue(oldModule, specialPropertyName, "type", ""));
        newModule.put("alignment", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "alignment", "2"));
        newModule.put("width", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "width", 15));
        newModule.put("height", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "height", 10));
        JSONObject title = DisclosureOldModuleHelper.createTitle(oldModule);
        newModule.put("title", (Object)title);
        JSONObject legend = DisclosureOldModuleHelper.createLegend(oldModule);
        newModule.put("legend", (Object)legend);
        JSONObject dataFormat = new JSONObject();
        newModule.put("dataFormat", (Object)dataFormat);
        if (ModuleEnum.VAR.getType().equals(type)) {
            JSONObject dataPoint = DisclosureOldModuleHelper.createGeneralDataFormat(oldModule, DatalabelEnum.DISPLAY);
            dataFormat.put("dataPoint", (Object)dataPoint);
        }
        if (ModuleEnum.PIE.getType().equals(type) || ModuleEnum.DOUGHNUT.getType().equals(type)) {
            JSONObject pie = DisclosureOldModuleHelper.createGeneralDataFormat(oldModule, DatalabelEnum.DISPLAY);
            dataFormat.put("pie", (Object)pie);
        }
        if (ModuleEnum.TABLE.getType().equals(type)) {
            JSONObject table = DisclosureOldModuleHelper.createTalbe(oldModule);
            newModule.put("table", (Object)table);
            JSONObject tableDataFormat = DisclosureOldModuleHelper.createGeneralDataFormat(oldModule, DatalabelEnum.DISPLAY);
            dataFormat.put("table", (Object)tableDataFormat);
        }
        if (ModuleEnum.STACKED_COLUMNAR.getType().equals(type) || ModuleEnum.STACKED_BAR.getType().equals(type) || ModuleEnum.CLUSTERED_BAR.getType().equals(type) || ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(type) || ModuleEnum.LINE.getType().equals(type) || ModuleEnum.LINE_STACKED_COLUMNAR.getType().equals(type) || ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equals(type) || ModuleEnum.AREA.getType().equals(type)) {
            dataFormat.put("y1", (Object)DisclosureOldModuleHelper.createGeneralDataFormat(oldModule, DatalabelEnum.CTR));
            dataFormat.put("y2", (Object)DisclosureOldModuleHelper.createGeneralDataFormat(oldModule, DatalabelEnum.CTR));
            JSONObject axis = DisclosureOldModuleHelper.createAxis(oldModule);
            newModule.put("axis", (Object)axis);
            JSONObject gridLine = DisclosureOldModuleHelper.createGridLine(oldModule);
            newModule.put("gridLine", (Object)gridLine);
        }
        if (ModuleEnum.REPORT_SECTION.getType().equals(type)) {
            JSONObject reportSection = ReportSectionHelper.createReportSection(dmModelId, oldModule);
            newModule.put("reportSection", (Object)reportSection);
        }
        JSONObject border = DisclosureOldModuleHelper.createBorder();
        newModule.put("border", (Object)border);
        JSONObject specialMap = new JSONObject();
        if (oldModule.getJSONObject(specialPropertyName) != null) {
            specialMap = oldModule.getJSONObject(specialPropertyName).getJSONObject("specialMap");
        }
        newModule.put("specialMap", (Object)specialMap);
        JSONObject dataset = DisclosureOldModuleHelper.createDatasetNode(dmModelId, chapterId, modulePropertiesStr);
        newModule.put("dataset", (Object)dataset);
        newModule = JSONObject.parseObject((String)newModule.toJSONString());
        DisclosureJsonHelper.convertLongToStringFromJson(newModule);
        DisclosureOldModuleHelper.repair(newModule);
        DisclosureJsonHelper.convertLongToStringFromJson(newModule);
        return newModule;
    }

    public static void repair(JSONObject moduleProperties) {
        String moduleType = moduleProperties.getString("type");
        if (ModuleEnum.REPORT_SECTION.getType().equals(moduleType)) {
            ReportSectionHelper.repairReportSection(moduleProperties);
        }
    }

    private static JSONObject createTitle(JSONObject oldModule) {
        JSONObject title = new JSONObject();
        title.put("name", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "title", ""));
        title.put("visible", (Object)(DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "title", "") != "" ? 1 : 0));
        title.put("fontSize", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "titileSize", 10));
        return title;
    }

    private static JSONObject createLegend(JSONObject oldModule) {
        JSONObject legend = new JSONObject();
        legend.put("overlay", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "legendOverlay", false));
        legend.put("visible", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "legendVisibale", false));
        legend.put("position", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "legendPosition", "1"));
        legend.put("fontSize", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "legendSize", 10));
        return legend;
    }

    private static JSONObject createGeneralDataFormat(JSONObject oldModule, DatalabelEnum defaultDatalabel) {
        boolean visible = true;
        String dataLabel = DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "dataLabel", defaultDatalabel.getNumber());
        if (StringUtils.isEmpty((String)dataLabel) || dataLabel.equals(DatalabelEnum.NULL.getNumber())) {
            visible = false;
            dataLabel = defaultDatalabel.getNumber();
        }
        JSONObject dataFormat = new JSONObject();
        dataFormat.put("dataLabel", (Object)dataLabel);
        dataFormat.put("unit", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "dataPattern", "unit", "1"));
        dataFormat.put("decimal", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "dataPattern", "decimal", "2"));
        dataFormat.put("thousandth", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "dataPattern", "thousandth", true));
        dataFormat.put("numbertype", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "dataPattern", "numbertype", "1"));
        dataFormat.put("currencysign", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "dataPattern", "currencysign", ""));
        dataFormat.put("visible", (Object)visible);
        return dataFormat;
    }

    private static JSONObject createTalbe(JSONObject oldModule) {
        JSONObject table = new JSONObject();
        JSONArray property = null;
        if (oldModule.getJSONObject(specialPropertyName) != null && oldModule.getJSONObject(specialPropertyName).getJSONArray("tableProperty") != null) {
            property = oldModule.getJSONObject(specialPropertyName).getJSONArray("tableProperty");
        }
        table.put("property", property);
        return table;
    }

    private static JSONObject createAxis(JSONObject oldModule) {
        JSONObject axis = new JSONObject();
        JSONObject xAxis = new JSONObject();
        xAxis.put("angle", (Object)0);
        xAxis.put("title", (Object)"");
        xAxis.put("fontSize", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "axisSize", 10));
        xAxis.put("visible", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "bottomAxisTitleVisible", false));
        xAxis.put("dataFormat", (Object)DisclosureOldModuleHelper.createAxisDataFormat(oldModule));
        axis.put("x", (Object)xAxis);
        JSONObject y1Axis = new JSONObject();
        y1Axis.put("angle", (Object)0);
        y1Axis.put("title", (Object)"");
        y1Axis.put("fontSize", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "axisSize", 10));
        y1Axis.put("visible", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "leftAxisTitleVisible", false));
        y1Axis.put("min", (Object)-1);
        y1Axis.put("max", (Object)-1);
        y1Axis.put("dataFormat", (Object)DisclosureOldModuleHelper.createAxisDataFormat(oldModule));
        axis.put("y1", (Object)y1Axis);
        JSONObject y2Axis = new JSONObject();
        y2Axis.put("angle", (Object)0);
        y2Axis.put("title", (Object)"");
        y2Axis.put("fontSize", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "axisSize", 10));
        y2Axis.put("visible", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "leftAxisTitleVisible", false));
        y2Axis.put("min", (Object)-1);
        y2Axis.put("max", (Object)-1);
        y2Axis.put("dataFormat", (Object)DisclosureOldModuleHelper.createAxisDataFormat(oldModule));
        axis.put("y2", (Object)y2Axis);
        return axis;
    }

    private static JSONObject createAxisDataFormat(JSONObject oldModule) {
        JSONObject dataFormat = new JSONObject();
        dataFormat.put("unit", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "axisDataPattern", "unit", "1"));
        dataFormat.put("decimal", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "axisDataPattern", "decimal", "2"));
        dataFormat.put("thousandth", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "axisDataPattern", "thousandth", true));
        dataFormat.put("numbertype", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "axisDataPattern", "numbertype", "1"));
        dataFormat.put("currencysign", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "axisDataPattern", "currencysign", ""));
        return dataFormat;
    }

    private static JSONObject createGridLine(JSONObject oldModule) {
        JSONObject gridLine = new JSONObject();
        gridLine.put("visible", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "cbxShownetline", false));
        gridLine.put("x", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "cbxShownetline", false));
        gridLine.put("y1", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "cbxShownetline", false));
        gridLine.put("y2", (Object)DisclosureJsonHelper.getValue(oldModule, commonPropertyName, "cbxShownetline", false));
        return gridLine;
    }

    private static JSONObject createBorder() {
        JSONObject border = new JSONObject();
        border.put("visible", (Object)true);
        return border;
    }

    private static JSONObject createDatasetNode(Long dmModelId, Long chapterId, String propertieStr) {
        ModuleProperty moduleProperty = (ModuleProperty)JacksonUtils.fromJson((String)propertieStr, ModuleProperty.class);
        CommonProperty commonProperty = moduleProperty.getCommonProperty();
        if (commonProperty == null || commonProperty.getDatasetId() <= 0L) {
            return null;
        }
        JSONObject jsonObject = JSON.parseObject((String)"{}");
        String id = "";
        String number = "";
        String name = "";
        String type = "";
        LinkedHashMap<String, String> formula = new LinkedHashMap<String, String>(2);
        List<Object> details = new ArrayList(2);
        ArrayList<Map<String, Object>> varParams = new ArrayList<Map<String, Object>>(2);
        ArrayList<Map<String, Object>> dimParams = new ArrayList<Map<String, Object>>(2);
        ArrayList<DatasetFilterItem> datesetFilterItems = new ArrayList<DatasetFilterItem>(2);
        String datesetFilterItemsStr = "";
        DynamicObject datasetDy = DatasetDataReader.getDataSet(commonProperty.getDatasetId(), false);
        if (datasetDy != null) {
            DynamicObject datasetMutiDy;
            Long datasetId = datasetDy.getLong("id");
            id = datasetDy.getString("id");
            number = datasetDy.getString("number");
            name = datasetDy.getString("name");
            type = datasetDy.getString("type");
            if (commonProperty.getDatasetMultiId() > 0L && (datasetMutiDy = DatasetDataReader.getMultiDataSetValue(commonProperty.getDatasetMultiId(), false)) != null) {
                formula.put("id", datasetMutiDy.getString("id"));
                formula.put("number", datasetMutiDy.getString("number"));
                formula.put("name", datasetMutiDy.getString("name"));
            }
            if ("2".equals(type)) {
                details = DatasetFilterHelper.invokeDatasetFilterColumn(dmModelId, datasetId);
                details.forEach(m -> m.put("id", m.get("number").toString()));
            }
            DisclosureOldModuleHelper.createVarParams(dmModelId, chapterId, datasetId, commonProperty, varParams, dimParams);
            datesetFilterItemsStr = DisclosureOldModuleHelper.createDatasetFilters(dmModelId, datasetId, commonProperty, datesetFilterItems);
        }
        jsonObject.put("id", (Object)id);
        jsonObject.put("number", (Object)number);
        jsonObject.put("name", (Object)name);
        jsonObject.put("type", (Object)type);
        jsonObject.put("formula", formula);
        jsonObject.put("varParams", varParams);
        jsonObject.put("dimParams", dimParams);
        jsonObject.put("detail", details);
        jsonObject.put("datesetFilterItems", datesetFilterItems);
        jsonObject.put("datesetFilterItemsStr", (Object)datesetFilterItemsStr);
        return jsonObject;
    }

    private static void createVarParams(Long dmModelId, Long chapterId, Long datasetId, CommonProperty commonProperty, List<Map<String, Object>> variableList, List<Map<String, Object>> dimParamList) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> dimList = modelStrategyEx.getDim().getDimList();
        Map<String, Object> varAndDimResult = DatasetServiceHelper.getVarAndDimVars(dmModelId, datasetId, chapterId, false);
        List varSourceList = (List)varAndDimResult.get("variableList");
        List shortNumberList = (List)varAndDimResult.get("shortNumberList");
        Map<String, Object> sourceVarParams = commonProperty.getVarParams();
        for (Map varObject : varSourceList) {
            String varNumber = varObject.get("number").toString();
            String valuetype = varObject.get("valuetype").toString();
            varObject.put("modifyvalue", null);
            if (varObject.get("valuetype").equals(DmVariableTypeEnum.DIM.getIndex())) {
                DimensionInfo findDim = dimList.stream().filter(m -> m.getId().toString().equals(varObject.get("disc_dim"))).findAny().orElse(null);
                if (findDim != null) {
                    varObject.put("dim", findDim);
                } else {
                    varObject.put("dim", dimList.get(0));
                }
            }
            ArrayList entryentity = new ArrayList(2);
            if (varObject.get("entryentity") != null) {
                for (DynamicObject entry : (DynamicObjectCollection)varObject.get("entryentity")) {
                    HashMap<String, String> newItem = new HashMap<String, String>(3);
                    newItem.put("id", entry.getString("id"));
                    newItem.put("enum_number", new LocaleString(entry.getString("enum_number")).getLocaleValue());
                    newItem.put("enum_name", new LocaleString(entry.getString("enum_name")).getLocaleValue());
                    entryentity.add(newItem);
                }
                varObject.put("entryentity", entryentity);
            }
            if (sourceVarParams.get(varNumber) != null) {
                varObject.put("modifyvalue", sourceVarParams.get(varNumber));
            }
            variableList.add(varObject);
        }
        List<Map<String, String>> sourceDimParams = commonProperty.getReportDims();
        for (String shortNumber : shortNumberList) {
            DimMemberInfo sourceMember;
            DimensionInfo findDim = dimList.stream().filter(m -> m.getShortNumber().equals(shortNumber)).findAny().orElse(null);
            if (findDim == null) continue;
            LinkedHashMap member = new LinkedHashMap(2);
            Map sourceDimParam = sourceDimParams.stream().filter(m -> ((String)m.get("shortnumber")).equals(shortNumber)).findAny().orElse(null);
            if (sourceDimParam != null && !StringUtils.isEmpty((String)((String)sourceDimParam.get("member_id"))) && (sourceMember = modelStrategyEx.getDimMember().findMemberById(findDim.getEntityName(), LongUtil.toLong(sourceDimParam.get("member_id")), false)) != null) {
                member.put("number", sourceDimParam.get("member_number"));
                member.put("name", sourceMember.getName());
                member.put("id", sourceDimParam.get("member_id"));
            }
            Map<String, Object> item = DimensionUtils.dimConvertToMap(findDim);
            item.put("member", member);
            dimParamList.add(item);
        }
    }

    private static String createDatasetFilters(Long dmModelId, Long datasetId, CommonProperty commonProperty, List<DatasetFilterItem> datesetFilterItems) {
        List<DatasetFilterItem> filterEntry = commonProperty.getDatasetFilterItems();
        if (filterEntry == null || filterEntry.size() == 0) {
            return "";
        }
        String filterView = DatasetFilterHelper.getFilterView(dmModelId, datasetId, filterEntry);
        datesetFilterItems.addAll(filterEntry);
        return filterView;
    }
}

