/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.ComeFromEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.eb.EBReportsectionReader;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;

public class EBReportSectionHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(EBReportSectionHelper.class);
    private static String notExistModuleName = "NotExistModule";

    public static void sync(Long dmModelId) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        DynamicObjectCollection bizModelList = EBReportsectionReader.getBusinessmodel(dmModelId);
        List<Long> bizModelIds = bizModelList.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection rptsections = EBReportsectionReader.getRptsections(dmModelId, bizModelIds);
        QFilter filter = new QFilter("model", "=", (Object)modelStrategyEx.getModel().getModelInfo().getModelId());
        filter.and(new QFilter("template", "=", (Object)0L));
        filter.and(new QFilter("type", "=", (Object)ModuleEnum.EB_REPORT_SECTION.getType()));
        DynamicObjectCollection moduleDys = QueryServiceHelper.query((String)"fidm_modulerepository", (String)"id,name,copyfrom", (QFilter[])filter.toArray());
        List moduleIds = moduleDys.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        List<Long> newReportsectionIds = rptsections.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        ArrayList<Long> deleteModuleIds = new ArrayList<Long>(moduleIds.size());
        for (DynamicObject moduleDy : moduleDys) {
            Long moduleId = moduleDy.getLong("id");
            Long oldReportSectionId = moduleDy.getLong("copyfrom");
            if (newReportsectionIds.contains(oldReportSectionId)) continue;
            deleteModuleIds.add(moduleId);
        }
        if (deleteModuleIds.size() > 0) {
            EBReportSectionHelper.deleteRptsection(modelInfo, deleteModuleIds);
        }
        if (newReportsectionIds.size() > 0) {
            DynamicObject root = ModuleServiceHelper.addCatalogRoot(modelStrategyEx.getModel().getModelInfo().getId(), "1");
            String refDimParamStrs = EbServiceHelper.getRefDimParams(newReportsectionIds);
            if (StringUtils.isEmpty((String)refDimParamStrs)) {
                return;
            }
            JSONObject refDimParamMap = JSONObject.parseObject((String)refDimParamStrs);
            for (Long ebRptSectionId : newReportsectionIds) {
                JSONObject refDimParam = refDimParamMap.getJSONObject(ebRptSectionId.toString());
                EBReportSectionHelper.syncOne(modelStrategyEx, root.getLong("id"), ebRptSectionId, refDimParam, "update");
            }
        }
    }

    private static void deleteRptsection(ModelInfo modelInfo, List<Long> moduleIds) {
        if (moduleIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fidm_modulerepository"), (Object[])moduleIds.toArray());
            EBReportSectionHelper.writeOpLog(modelInfo, OperationName.SYNC, OperationResult.SUCCESS, JSON.toJSONString(moduleIds), 0L, "delete");
        }
    }

    public static void sync(Long modelId, List<Long> rptSectionIds, String eventType, JSONObject refDimParamsJsonObject) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        DynamicObject root = ModuleServiceHelper.addCatalogRoot(modelStrategyEx.getModel().getModelInfo().getId(), "1");
        for (Long ebRptSectionId : rptSectionIds) {
            JSONObject refDimParam = refDimParamsJsonObject.getJSONObject(ebRptSectionId.toString());
            EBReportSectionHelper.syncOne(modelStrategyEx, root.getLong("id"), ebRptSectionId, refDimParam, eventType);
        }
    }

    private static void syncOne(ModelStrategyEx modelStrategyEx, Long catelogRootId, Long ebRptSectionId, JSONObject refDimParam, String eventType) {
        QFilter filter = new QFilter("model", "=", (Object)modelStrategyEx.getModel().getModelInfo().getModelId());
        filter.and(new QFilter("template", "=", (Object)0L));
        filter.and(new QFilter("copyfrom", "=", (Object)ebRptSectionId));
        DynamicObject moduleDy = QueryServiceHelper.queryOne((String)"fidm_modulerepository", (String)"id,name", (QFilter[])filter.toArray());
        Long moduleId = moduleDy == null ? 0L : moduleDy.getLong("id");
        String moduleName = moduleDy == null ? notExistModuleName : moduleDy.getString("name");
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        if ("delete".equalsIgnoreCase(eventType)) {
            if (moduleDy != null) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fidm_modulerepository"), (Object[])Collections.singletonList(moduleId).toArray());
                EBReportSectionHelper.writeOpLog(modelInfo, OperationName.SYNC, OperationResult.SUCCESS, moduleName, ebRptSectionId, eventType);
            } else {
                EBReportSectionHelper.writeOpLog(modelInfo, OperationName.SYNC, OperationResult.FAILURE, moduleName, ebRptSectionId, eventType);
            }
        } else {
            try {
                moduleDy = EBReportSectionHelper.addAndUpdate(modelStrategyEx, catelogRootId, ebRptSectionId, refDimParam, moduleId);
                EBReportSectionHelper.writeOpLog(modelInfo, OperationName.SYNC, OperationResult.SUCCESS, moduleName, ebRptSectionId, eventType, "moduleId:" + moduleDy.getString("id"));
            }
            catch (KDBizException bizException) {
                EBReportSectionHelper.writeOpLog(modelInfo, OperationName.SYNC, OperationResult.FAILURE, moduleName, ebRptSectionId, eventType, bizException.getMessage());
            }
            catch (Exception ex) {
                logger.error("dm ebreportsection error", (Throwable)ex);
                EBReportSectionHelper.writeOpLog(modelInfo, OperationName.SYNC, OperationResult.FAILURE, moduleName, ebRptSectionId, eventType, "error");
            }
        }
    }

    private static DynamicObject addAndUpdate(ModelStrategyEx modelStrategyEx, Long catelogRootId, Long ebRptSectionId, JSONObject refDimParam, Long moduleId) {
        String msg = "";
        DynamicObject ebRptSectionDy = EBReportsectionReader.getRptsection(ebRptSectionId, true);
        if (refDimParam == null) {
            msg = ResManager.loadKDString((String)"\u9884\u7b97\u62a5\u8868\u5207\u7247\u62a5\u8868\u5207\u7247\u7684\u5173\u952e\u6570\u636e\u6b8b\u7f3a\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"EBReportSectionHelper_2", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        DynamicObject moduleDy = null;
        moduleDy = LongUtil.isvalidLong((Object)moduleId) ? BusinessDataServiceHelper.loadSingle((Object)moduleId, (String)"fidm_modulerepository") : EBReportSectionHelper.createNewModule(modelStrategyEx.getModel().getModelInfo().getId(), catelogRootId, ebRptSectionDy);
        String number = ebRptSectionDy.getString("number");
        String name = ebRptSectionDy.getString("name");
        moduleDy.set("number", (Object)number);
        moduleDy.set("name", (Object)name);
        JSONObject moduleProperty = JSON.parseObject((String)moduleDy.getString("properties"));
        JSONObject reportSection = moduleProperty.getJSONObject("reportSection");
        if (reportSection == null) {
            msg = ResManager.loadKDString((String)"\u9884\u7b97\u62a5\u8868\u5207\u7247\u62a5\u8868\u5207\u7247\u7684\u5173\u952e\u6570\u636e\u6b8b\u7f3a\uff0c\u8bf7\u91cd\u65b0\u65b0\u589e\u6216\u5c06\u65e7\u5207\u7247\u5220\u9664\u540e\u91cd\u65b0\u65b0\u589e\u3002", (String)"EBReportSectionHelper_3", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        DynamicObject ebRptTemplate = EBReportsectionReader.getRptTemplate(ebRptSectionDy.getLong("template.id"));
        JSONObject report = new JSONObject();
        report.put("name", (Object)(ebRptTemplate == null ? "" : ebRptTemplate.getString("name")));
        report.put("range", (Object)"ALL");
        reportSection.put("report", (Object)report);
        reportSection.put("defaultDataSet", (Object)(ebRptTemplate == null ? "" : ebRptTemplate.getString("dataset.number")));
        List<DimensionInfo> allDimsions = modelStrategyEx.getDim().getDimList();
        JSONArray oldReportDims = reportSection.getJSONArray("reportDims");
        JSONArray paramDimNums = refDimParam.getJSONArray("paramDimNums");
        JSONArray reportDims = new JSONArray();
        for (Object item : paramDimNums) {
            String dimNumer = item.toString();
            DimensionInfo dim = DimensionUtils.getDimByNumber(allDimsions, dimNumer);
            if (dim == null) continue;
            JSONObject dimItem = new JSONObject();
            dimItem.put("dim_id", (Object)dim.getId().toString());
            dimItem.put("dim_number", (Object)dim.getNumber());
            dimItem.put("dim_name", (Object)dim.getName());
            dimItem.put("memberentitynumber", (Object)dim.getEntityName());
            dimItem.put("dataentitynumber", (Object)modelStrategyEx.getDim().getDimEntity());
            JSONObject oldDimData = EBReportSectionHelper.findDimFromOld(oldReportDims, dim.getNumber());
            if (oldDimData != null) {
                dimItem.put("member_id", (Object)oldDimData.getString("member_id"));
                dimItem.put("member_number", (Object)oldDimData.getString("member_number"));
                dimItem.put("member_name", (Object)oldDimData.getString("member_name"));
            }
            reportDims.add((Object)dimItem);
        }
        reportSection.put("reportDims", (Object)reportDims);
        JSONArray oldReportVars = reportSection.getJSONArray("reportVars");
        JSONObject dimVars = refDimParam.getJSONObject("dimVars");
        JSONArray reportVars = new JSONArray();
        if (dimVars != null) {
            for (Map.Entry item : dimVars.entrySet()) {
                String dimNumer;
                DimensionInfo dim;
                if (item.getValue() == null || (dim = DimensionUtils.getDimByNumber(allDimsions, dimNumer = (String)item.getKey())) == null) continue;
                JSONObject dimItem = new JSONObject();
                dimItem.put("dim_id", (Object)dim.getId().toString());
                dimItem.put("dim_number", (Object)dim.getNumber());
                dimItem.put("dim_name", (Object)dim.getName());
                dimItem.put("memberentitynumber", (Object)dim.getEntityName());
                dimItem.put("dataentitynumber", (Object)modelStrategyEx.getDim().getDimEntity());
                for (Object varNumber : (JSONArray)item.getValue()) {
                    if (varNumber == null || varNumber == "") continue;
                    dimItem.put("name", (Object)varNumber.toString());
                    dimItem.put("number", (Object)varNumber.toString());
                    JSONObject oldDimData = EBReportSectionHelper.findDimFromOld(oldReportVars, dim.getNumber(), varNumber.toString());
                    if (oldDimData != null) {
                        dimItem.put("member_id", (Object)oldDimData.getString("member_id"));
                        dimItem.put("member_number", (Object)oldDimData.getString("member_number"));
                        dimItem.put("member_name", (Object)oldDimData.getString("member_name"));
                    }
                    reportVars.add((Object)dimItem);
                }
            }
            reportSection.put("reportVars", (Object)reportVars);
        }
        moduleDy.set("properties", (Object)moduleProperty.toJSONString());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{moduleDy});
        return moduleDy;
    }

    private static JSONObject findDimFromOld(JSONArray oldReportDims, String dimNumber) {
        if (oldReportDims == null || oldReportDims.size() == 0) {
            return null;
        }
        for (Object itemObject : oldReportDims) {
            JSONObject item;
            if (!(itemObject instanceof JSONObject) || !dimNumber.equalsIgnoreCase((item = (JSONObject)itemObject).getString("dim_number"))) continue;
            return item;
        }
        return null;
    }

    private static JSONObject findDimFromOld(JSONArray oldReportDims, String dimNumber, String varNumber) {
        if (oldReportDims == null || oldReportDims.size() == 0 || StringUtils.isEmpty((String)varNumber)) {
            return null;
        }
        for (Object itemObject : oldReportDims) {
            JSONObject item;
            if (!(itemObject instanceof JSONObject) || !dimNumber.equalsIgnoreCase((item = (JSONObject)itemObject).getString("dim_number")) && !varNumber.equalsIgnoreCase(item.getString("number"))) continue;
            return item;
        }
        return null;
    }

    private static DynamicObject createNewModule(Long dmModelId, Long catelogRootId, DynamicObject ebRptSection) {
        Long ebRptSectionId = ebRptSection.getLong("id");
        Long moduleId = GlobalIdUtil.genGlobalLongId();
        String number = ebRptSection.getString("number");
        String name = ebRptSection.getString("name");
        DynamicObject moduleDy = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
        moduleDy.set("id", (Object)moduleId);
        moduleDy.set("model", (Object)dmModelId);
        moduleDy.set("number", (Object)number);
        moduleDy.set("name", (Object)name);
        moduleDy.set("description", (Object)"");
        moduleDy.set("template", (Object)0L);
        moduleDy.set("catalog", (Object)catelogRootId);
        moduleDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        moduleDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        moduleDy.set("scope", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType());
        moduleDy.set("status", (Object)"1");
        moduleDy.set("type", (Object)ModuleEnum.EB_REPORT_SECTION.getType());
        moduleDy.set("applytype", (Object)"1");
        moduleDy.set("copyfrom", (Object)ebRptSectionId);
        moduleDy.set("comefrom", (Object)ComeFromEnum.EB.getType());
        JSONObject moduleProperty = JSONObject.parseObject((String)"{\"number\":\"\",\"dataFormat\":{\"moduleProperty\":{}},\"specialMap\":{\"componentId\":\"\"},\"width\":15,\"name\":\"\",\"id\":\"\",\"alignment\":\"2\",\"type\":\"16\",\"reportSection\":{\"columnType\":\"1\",\"ignoreEmptyRowCol\":true,\"left\":0,\"reportDims\":[],\"reportQuery\":[],\"report\":{\"name\":\"\",\"range\":\"\"},\"styleData\":{\"decimalEnable\":true,\"unit\":\"0\",\"styleSource\":\"1\",\"floatDisplay\":\"3\",\"decimal\":2},\"widthRate\":1,\"cellFontFit\":false,\"cell\":{\"top\":0.2,\"left\":0.2,\"bottom\":0.2,\"right\":0.2}},\"height\":10}");
        moduleProperty.put("id", (Object)moduleId.toString());
        moduleProperty.put("number", (Object)number);
        moduleProperty.put("name", (Object)number);
        JSONObject specialMap = moduleProperty.getJSONObject("specialMap");
        if (specialMap != null) {
            specialMap.put("componentId", (Object)ebRptSectionId.toString());
        }
        moduleDy.set("properties", (Object)moduleProperty.toJSONString());
        return moduleDy;
    }

    public static List<DimensionInfo> getDimList(Long dmModelId, JSONObject moduleProperties) {
        String msg = "";
        ArrayList<DimensionInfo> result = new ArrayList<DimensionInfo>(100);
        if (moduleProperties == null) {
            return result;
        }
        String moduleType = DisclosureJsonHelper.getValue(moduleProperties, "type", "");
        if (!ModuleEnum.EB_REPORT_SECTION.getType().equals(moduleType)) {
            return result;
        }
        String moduleName = moduleProperties.getString("name");
        JSONObject reportSection = moduleProperties.getJSONObject("reportSection");
        if (reportSection == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u62a5\u8868\u5207\u7247\u7684\u5173\u952e\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_2", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        String componentId = DisclosureJsonHelper.getValue(moduleProperties, "specialMap", "componentId", "");
        EBReportsectionReader.getRptsection(LongUtil.toLong((Object)componentId), true);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList();
        for (Object dimObject : reportSection.getJSONArray("reportDims")) {
            JSONObject dim = (JSONObject)dimObject;
            if (dim == null) continue;
            String dim_number = dim.getString("dim_number");
            String member_id = dim.getString("member_id");
            String member_number = dim.getString("member_number");
            String member_name = dim.getString("member_name");
            DimensionInfo find = DimensionUtils.getDimByNumber(allDimensions, dim_number);
            if (find != null && StringUtils.isNotEmpty((String)member_id)) {
                DimMemberInfo memberInfo = new DimMemberInfo();
                memberInfo.setId(LongUtil.toLong((Object)member_id));
                memberInfo.setNumber(member_number);
                memberInfo.setName(member_name);
                find.getMembers().add(memberInfo);
            }
            if (find == null) continue;
            result.add(find);
        }
        return result;
    }

    protected static void writeOpLog(ModelInfo model, OperationName opName, OperationResult result, Object ... params) {
        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.COMPONENT_GALLERY).buildOpName(opName).buildFormNumber("fidm_modulerepository").buildAppId("fidm").buildFormatParams(new Object[]{model.getNumber()}).appendFormatParams(params).buildOpResult(result);
        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
    }

    public static Long getEbTemplateId(JSONObject moduleProperties) {
        String moduleName = moduleProperties.getString("name");
        String componentId = DisclosureJsonHelper.getValue(moduleProperties, "specialMap", "componentId", "");
        EBReportsectionReader.getRptsection(LongUtil.toLong((Object)componentId), true);
        return LongUtil.toLong((Object)componentId);
    }

    public static Map<String, String> createReportDims(JSONObject module, String nodeName) {
        LinkedHashMap<String, String> dimMemberMap = new LinkedHashMap<String, String>(10);
        JSONArray reportDims = DisclosureJsonHelper.getJSONArray(module, "reportSection", nodeName);
        if (reportDims == null || reportDims.size() == 0) {
            return dimMemberMap;
        }
        for (Object itemObject : reportDims) {
            JSONObject item = (JSONObject)itemObject;
            dimMemberMap.put(item.getString("dim_number"), item.getString("member_number"));
        }
        return dimMemberMap;
    }

    public static JSONArray createReportDims(Long dmModelId, Map<String, String> dimMemberMap) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDims = modelStrategyEx.getDim().getDimList();
        String dimEntity = modelStrategyEx.getDim().getDimEntity();
        JSONArray reportDims = new JSONArray();
        for (Map.Entry<String, String> entry : dimMemberMap.entrySet()) {
            DimMemberInfo sourceMember;
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDims, entry.getKey());
            if (dimensionInfo == null) continue;
            JSONObject item = new JSONObject();
            item.put("dim_id", (Object)dimensionInfo.getId().toString());
            item.put("dim_name", (Object)dimensionInfo.getName());
            item.put("dim_number", (Object)dimensionInfo.getNumber());
            item.put("memberentitynumber", (Object)dimensionInfo.getEntityName());
            item.put("dataentitynumber", (Object)dimEntity);
            if (!StringUtils.isEmpty((String)entry.getValue()) && (sourceMember = modelStrategyEx.getDimMember().findMemberByNumber(dimensionInfo.getNumber(), entry.getValue(), false)) != null) {
                item.put("member_id", (Object)sourceMember.getId().toString());
                item.put("member_number", (Object)sourceMember.getNumber());
                item.put("member_name", (Object)sourceMember.getName());
            }
            reportDims.add((Object)item);
        }
        return reportDims;
    }
}

