/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.excel.ExcelConvert;
import kd.epm.far.business.fidm.excel.dto.TableConvertParam;
import kd.epm.far.business.fidm.html.helper.HtmlTableHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class ReportSectionHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportSectionHelper.class);

    public static JSONObject createReportSection(Long dmModelId, JSONObject oldModule) {
        JSONObject reportSection = new JSONObject();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDimsions = modelStrategyEx.getDim().getDimList();
        JSONArray jsonArray = DisclosureJsonHelper.getJSONArray(oldModule, "commonProperty", "reportDims");
        if (jsonArray != null && jsonArray.size() > 0) {
            for (Object reportDimObject : jsonArray) {
                JSONObject reportDim = (JSONObject)reportDimObject;
                if (reportDim == null) continue;
                try {
                    DimMemberInfo sourceMember;
                    DimensionInfo dimDy = DimensionUtils.getDimByNumber(allDimsions, TypeUtils.convertToString(reportDim.get((Object)"dim_number")));
                    if (dimDy == null) continue;
                    reportDim.put("dim_name", (Object)dimDy.getName());
                    if (StringUtils.isEmpty((String)reportDim.getString("member_id")) || (sourceMember = modelStrategyEx.getDimMember().findMemberById(dimDy.getEntityName(), LongUtil.toLong((Object)reportDim.getString("member_id")), false)) == null) continue;
                    reportDim.put("member_name", (Object)sourceMember.getName());
                }
                catch (Exception ex) {
                    logger.error("dm createReportSection  getMemberInfo Error", (Throwable)ex);
                }
            }
        }
        reportSection.put("reportDims", (Object)jsonArray);
        return reportSection;
    }

    public static void repairReportSection(JSONObject moduleProperties) {
        String selectedarea;
        if (moduleProperties == null) {
            return;
        }
        if (moduleProperties.get((Object)"commonProperty") != null || moduleProperties.get((Object)"specialProperty") != null) {
            return;
        }
        String moduleType = moduleProperties.getString("type");
        if (!ModuleEnum.REPORT_SECTION.getType().equals(moduleType)) {
            return;
        }
        JSONObject reportSection = moduleProperties.getJSONObject("reportSection");
        if (reportSection == null) {
            return;
        }
        String componentId = DisclosureJsonHelper.getValue(moduleProperties, "specialMap", "componentId", "");
        DynamicObject component = QueryServiceHelper.queryOne((String)"bcm_component_info", (String)"id,selectedarea,template.id,template.name", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)componentId)).toArray());
        if (component == null) {
            return;
        }
        String templateName = component.getString("template.name");
        if (StringUtils.isEmpty((String)templateName)) {
            templateName = ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u5df2\u5220\u9664\u3002", (String)"DisclosureServiceHelper_10", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (!StringUtils.isEmpty((String)(selectedarea = component.getString("selectedarea")))) {
            selectedarea = selectedarea.replace(":", "-");
        }
        JSONObject report = new JSONObject();
        report.put("name", (Object)templateName);
        report.put("range", (Object)selectedarea);
        reportSection.put("report", (Object)report);
    }

    public static List<DimensionInfo> getDimList(Long dmModelId, JSONObject moduleProperties) {
        String msg = "";
        ArrayList<DimensionInfo> result = new ArrayList<DimensionInfo>(100);
        if (moduleProperties == null) {
            return result;
        }
        String moduleType = DisclosureJsonHelper.getValue(moduleProperties, "type", "");
        if (!ModuleEnum.REPORT_SECTION.getType().equals(moduleType)) {
            return result;
        }
        String moduleName = moduleProperties.getString("name");
        JSONObject reportSection = moduleProperties.getJSONObject("reportSection");
        if (reportSection == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u62a5\u8868\u5207\u7247\u7684\u5173\u952e\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_2", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        String componentId = DisclosureJsonHelper.getValue(moduleProperties, "specialMap", "componentId", "");
        DynamicObject component = QueryServiceHelper.queryOne((String)"bcm_component_info", (String)"id", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)componentId)).toArray());
        if (component == null) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u5173\u8054\u7f16\u5236\u62a5\u8868\u7684\u6570\u636e\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_3", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList();
        for (Object dimObject : reportSection.getJSONArray("reportDims")) {
            JSONObject dim = (JSONObject)dimObject;
            if (dim == null) continue;
            String dim_number = dim.getString("dim_number");
            String member_id = dim.getString("member_id");
            String member_number = dim.getString("member_number");
            String member_name = dim.getString("member_name");
            DimensionInfo find = DimensionUtils.getDimByNumber(allDimensions, dim_number);
            if (find != null && StringUtils.isNotEmpty((String)member_id)) {
                DimMemberInfo memberInfo = new DimMemberInfo();
                memberInfo.setId(LongUtil.toLong((Object)member_id));
                memberInfo.setNumber(member_number);
                memberInfo.setName(member_name);
                find.getMembers().add(memberInfo);
            }
            if (find == null) continue;
            result.add(find);
        }
        return result;
    }

    public static String getDesigStyle(JSONObject moduleProperties) {
        if (moduleProperties == null) {
            return "";
        }
        if (moduleProperties.get((Object)"commonProperty") != null || moduleProperties.get((Object)"specialProperty") != null) {
            return "";
        }
        String moduleType = DisclosureJsonHelper.getValue(moduleProperties, "type", "");
        if (!ModuleEnum.REPORT_SECTION.getType().equals(moduleType)) {
            return "";
        }
        String msg = "";
        String moduleName = moduleProperties.getString("name");
        JSONObject reportSection = moduleProperties.getJSONObject("reportSection");
        if (reportSection == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u62a5\u8868\u5207\u7247\u7684\u5173\u952e\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_2", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        String componentId = DisclosureJsonHelper.getValue(moduleProperties, "specialMap", "componentId", "");
        DynamicObject component = QueryServiceHelper.queryOne((String)"bcm_component_info", (String)"id,template.id,selectedarea", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)componentId)).toArray());
        if (component == null) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u5173\u8054\u7f16\u5236\u62a5\u8868\u7684\u6570\u636e\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_3", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        Long templateId = component.getLong("template.id");
        String selectedarea = component.getString("selectedarea");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(3);
        params.put("templateId", templateId);
        byte[] excelData = BCMMsServiceHelper.getTemplateExcelByReportsection(params);
        if (excelData == null) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u5173\u8054\u7f16\u5236\u62a5\u8868\u7684\u6570\u636e\u83b7\u53d6\u5931\u8d25\u65e0\u6548\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ModuleDataGeneralHelper_17", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        String columnType = "2";
        boolean cellFontFit = false;
        boolean ignoreEmptyRowCol = true;
        TableConvertParam tableConvertParam = new TableConvertParam(columnType, 1.0, selectedarea);
        tableConvertParam.setRemoveEmptyCell(ignoreEmptyRowCol);
        tableConvertParam.setCellFontFit(cellFontFit);
        WordTableNode tableNode = new ExcelConvert(excelData, tableConvertParam).createReportSection();
        if (tableNode == null || tableNode.getChilds().size() == 0) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u62a5\u8868\u5207\u7247\u533a\u57df\u65e0\u6570\u636e\uff0c\u8bf7\u8865\u5145\u540e\u91cd\u8bd5\u3002", (String)"ModuleDataGeneralHelper_18", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        reportSection.put("columnType", (Object)columnType);
        reportSection.put("cellFontFit", (Object)cellFontFit);
        reportSection.put("ignoreEmptyRowCol", (Object)ignoreEmptyRowCol);
        return HtmlTableHelper.toNewTableHtml(tableNode, moduleProperties.getString("id"));
    }

    public static Long getBCMTemplateId(JSONObject moduleProperties) {
        String moduleName = moduleProperties.getString("name");
        String componentId = DisclosureJsonHelper.getValue(moduleProperties, "specialMap", "componentId", "");
        DynamicObject component = QueryServiceHelper.queryOne((String)"bcm_component_info", (String)"id,template.templatetype,template.id,selectedarea", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)componentId)).toArray());
        if (component == null) {
            String msg = String.format(ResManager.loadKDString((String)"%s:\u5173\u8054\u7f16\u5236\u62a5\u8868\u7684\u6570\u636e\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_3", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        return LongUtil.toLong((Object)componentId);
    }

    public static DynamicObject getTemplateId(Long componentId) {
        DynamicObject component = QueryServiceHelper.queryOne((String)"bcm_component_info", (String)"id,name,template.templatetype,template.id,selectedarea", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)componentId)).toArray());
        if (component == null) {
            String msg = String.format(ResManager.loadKDString((String)"%s:\u5173\u8054\u7f16\u5236\u62a5\u8868\u7684\u6570\u636e\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_3", (String)"epm-far-business", (Object[])new Object[0]), ModuleEnum.REPORT_SECTION.getName());
            throw new KDBizException(msg);
        }
        return component;
    }

    public static Map<String, String> createReportDims(JSONObject module) {
        LinkedHashMap<String, String> dimMemberMap = new LinkedHashMap<String, String>(10);
        JSONArray reportDims = DisclosureJsonHelper.getJSONArray(module, "reportSection", "reportDims");
        if (reportDims == null || reportDims.size() == 0) {
            return dimMemberMap;
        }
        for (Object itemObject : reportDims) {
            JSONObject item = (JSONObject)itemObject;
            dimMemberMap.put(item.getString("dim_number"), item.getString("member_number"));
        }
        return dimMemberMap;
    }

    public static JSONArray createReportDims(Long dmModelId, Map<String, String> dimMemberMap) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDims = modelStrategyEx.getDim().getDimList();
        String dimEntity = modelStrategyEx.getDim().getDimEntity();
        JSONArray reportDims = new JSONArray();
        for (Map.Entry<String, String> entry : dimMemberMap.entrySet()) {
            DimMemberInfo sourceMember;
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDims, entry.getKey());
            if (dimensionInfo == null) continue;
            JSONObject item = new JSONObject();
            item.put("dim_id", (Object)dimensionInfo.getId().toString());
            item.put("dim_name", (Object)dimensionInfo.getName());
            item.put("dim_number", (Object)dimensionInfo.getNumber());
            item.put("memberentitynumber", (Object)dimensionInfo.getEntityName());
            item.put("dataentitynumber", (Object)dimEntity);
            if (!StringUtils.isEmpty((String)entry.getValue()) && (sourceMember = modelStrategyEx.getDimMember().findMemberByNumber(dimensionInfo.getNumber(), entry.getValue(), false)) != null) {
                item.put("member_id", (Object)sourceMember.getId().toString());
                item.put("member_number", (Object)sourceMember.getNumber());
                item.put("member_name", (Object)sourceMember.getName());
            }
            reportDims.add((Object)item);
        }
        return reportDims;
    }
}

