/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.fidm.base.DisclosureConstants;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractCalculate {
    protected static final Log log = LogFactory.getLog(AbstractCalculate.class);
    protected Long dmModelId;
    protected JSONObject moduleProperties;
    protected Object sourceData;
    protected List<DatasetFilterItem> filterItems;
    protected String datasetType;
    protected Set<String> moneyKeys;
    protected Long datasetiId;
    protected Long datasetMultiId;
    protected Boolean isWithName;
    protected Map<String, String> multiDataNameMap = new HashMap<String, String>(2);
    protected List<Map<String, Object>> multiSourceData = new ArrayList<Map<String, Object>>(2);
    protected String multiColumnPre = "newCol_";
    protected Map<String, String> multiColumnNameMap = new HashMap<String, String>(2);
    protected Set<String> multiMoneyKeys = new HashSet<String>(2);
    protected List<DatasetFilterItem> multiFilterItems = new ArrayList<DatasetFilterItem>(2);

    public AbstractCalculate(Long dmModelId, Object sourceData, JSONObject moduleProperties, List<DatasetFilterItem> filterItems) {
        this.dmModelId = dmModelId;
        this.sourceData = sourceData;
        this.moduleProperties = moduleProperties;
        this.datasetType = DisclosureJsonHelper.getValue(moduleProperties, "dataset", "type", "");
        this.datasetiId = DisclosureJsonHelper.getValue(moduleProperties, "dataset", "id", 0L);
        this.datasetMultiId = DisclosureJsonHelper.getValue(moduleProperties, "dataset", "formula", "id", 0L);
        if (Objects.equals("2", this.datasetType)) {
            this.moneyKeys = DatasetFilterHelper.getMoneyKeySet(dmModelId, this.datasetiId);
        }
        this.filterItems = filterItems;
        this.isWithName = true;
    }

    public Map<String, Object> calculate() {
        Map<String, Object> returnData = null;
        switch (this.datasetType) {
            case "1": {
                returnData = this.getSingleValue();
                break;
            }
            case "2": {
                if (Objects.isNull(this.sourceData) || this.sourceData instanceof List && CollectionUtils.isEmpty((Collection)((List)this.sourceData))) {
                    String errorMsg = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u96c6\u53d6\u6570\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"FidmCalculate_8", (String)"epm-far-business", (Object[])new Object[0]);
                    log.error(errorMsg + ":" + this.sourceData);
                    returnData = new HashMap<String, Object>();
                    returnData.put("errorMsg", errorMsg);
                    return returnData;
                }
                List list = (List)this.sourceData;
                this.multiColumnNameMap = new HashMap<String, String>(2);
                this.multiSourceData = this.convertToNewMutiList(list, this.multiColumnNameMap);
                this.multiMoneyKeys = this.convertToNewMutiMoney(this.moneyKeys, this.multiColumnNameMap);
                this.multiFilterItems = this.convertToNewMutiFilterItems(this.filterItems, this.multiColumnNameMap);
                if (this.isWithName.booleanValue()) {
                    this.multiDataNameMap = this.getSourceDataName(this.multiSourceData, this.multiMoneyKeys);
                }
                if ((returnData = this.getMultiRow()) != null) {
                    this.sortReturnData(returnData);
                }
                if (returnData == null) break;
                this.afterSortReturnData(returnData);
                break;
            }
            case "3": {
                returnData = this.getMultiValue();
                break;
            }
        }
        return returnData;
    }

    protected Map<String, Object> getSingleValue() {
        return Collections.emptyMap();
    }

    protected Map<String, Object> getMultiRow() {
        return Collections.emptyMap();
    }

    protected Map<String, Object> getMultiValue() {
        return Collections.emptyMap();
    }

    private List<Map<String, Object>> convertToNewMutiList(List<Map<String, Object>> source, Map<String, String> nameMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(2);
        int index = nameMap.size() + 1;
        for (Map<String, Object> item : source) {
            HashMap<String, Object> newItem = new HashMap<String, Object>(2);
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                if (!nameMap.containsKey(entry.getKey())) {
                    nameMap.put(entry.getKey(), this.multiColumnPre + index);
                    ++index;
                }
                newItem.put(nameMap.get(entry.getKey()), entry.getValue());
            }
            result.add(newItem);
        }
        return result;
    }

    private Set<String> convertToNewMutiMoney(Set<String> source, Map<String, String> nameMap) {
        HashSet<String> realMoneyKeys = new HashSet<String>(2);
        if (source != null) {
            int index = nameMap.size() + 1;
            for (String item : source) {
                if (!nameMap.containsKey(item)) {
                    nameMap.put(item, this.multiColumnPre + index);
                    ++index;
                }
                realMoneyKeys.add(nameMap.get(item));
            }
        }
        return realMoneyKeys;
    }

    private List<DatasetFilterItem> convertToNewMutiFilterItems(List<DatasetFilterItem> source, Map<String, String> nameMap) {
        ArrayList<DatasetFilterItem> result = new ArrayList<DatasetFilterItem>(2);
        if (source != null) {
            int index = nameMap.size() + 1;
            for (DatasetFilterItem item : source) {
                if (!nameMap.containsKey(item.getDimensionNumber())) {
                    nameMap.put(item.getDimensionNumber(), this.multiColumnPre + index);
                    ++index;
                }
                item.setDimensionNumber(nameMap.get(item.getDimensionNumber()));
                result.add(item);
            }
        }
        return result;
    }

    protected String getDataSetColumnName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        if (this.multiColumnNameMap.containsKey(name)) {
            return this.multiColumnNameMap.get(name);
        }
        return name;
    }

    private Map<String, String> getSourceDataName(List<Map<String, Object>> newSource, Set<String> newMoneyKeys) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        if (CollectionUtils.isEmpty(newSource)) {
            return result;
        }
        for (Map<String, Object> e : newSource) {
            for (Map.Entry<String, Object> entry : e.entrySet()) {
                String key = entry.getKey();
                Object valueObj = entry.getValue();
                if (Objects.isNull(valueObj)) continue;
                String[] value = valueObj instanceof String ? ((String)valueObj).split(";") : valueObj.toString().split(";");
                String number = "";
                String name = "";
                if (value.length > 0) {
                    number = value[0];
                }
                if (value.length == 1) {
                    name = value[0];
                } else if (value.length > 1) {
                    name = value[1];
                }
                e.put(key, number);
                if (newMoneyKeys.contains(key)) continue;
                result.put(key + "_" + number, name);
            }
        }
        return result;
    }

    protected String getMemberName(Row row, String dimensionNumber) {
        return this.getMemberName(row.getString(dimensionNumber), dimensionNumber);
    }

    protected String getMemberName(String memberNumber, String dimensionNumber) {
        return this.multiDataNameMap.get(dimensionNumber + "_" + memberNumber);
    }

    protected boolean fieldNull(Map<String, Object> returnData, DataSet dataSet, String ... fields) {
        String errorMsg = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u96c6\u5ea6\u91cf\u5217\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"FidmCalculate_7", (String)"epm-far-business", (Object[])new Object[0]);
        if (dataSet.getRowMeta().getFieldCount() == 0) {
            log.error(errorMsg + ": rowmeta_fields[{},{},{}...] is null, oneline=" + this.getOneline(), (Object[])fields);
            returnData.put("errorMsg", errorMsg);
            return true;
        }
        boolean result = false;
        for (String field : fields) {
            if (StringUtils.isEmpty((String)field) || dataSet.getRowMeta().getField(field, false) != null) continue;
            log.error(errorMsg + ": rowmeta_field[{}] is null, rowmeta={}, oneline={}", new Object[]{field, dataSet.getRowMeta().getFields(), this.getOneline()});
            returnData.put("errorMsg", errorMsg);
            result = true;
            break;
        }
        return result;
    }

    private Map<String, Object> getOneline() {
        List list = (List)this.sourceData;
        return CollectionUtils.isNotEmpty((Collection)list) ? (Map)list.get(0) : null;
    }

    protected DataSet getDataSet() {
        for (Map<String, Object> item : this.multiSourceData) {
            for (String valeCol : this.multiMoneyKeys) {
                BigDecimal val = new BigDecimal(0);
                Object d = item.get(valeCol);
                if (Objects.nonNull(d)) {
                    val = TypeUtils.convertValueToDecimal(d.toString());
                }
                item.put(valeCol, val);
            }
        }
        DataSet dataSet = CalculateHelper.createAlgoDataSet(this.multiSourceData, this.multiMoneyKeys);
        dataSet = CalculateHelper.whereByFilter(dataSet, this.multiFilterItems, this.multiMoneyKeys);
        return dataSet;
    }

    protected void sortReturnData(Map data) {
    }

    protected void afterSortReturnData(Map data) {
    }

    protected List<Map<String, Object>> createXY(List<String> xAxisList, DataSet dataSet, String typeName, String xAxisNumber, String yAxisNumber, String legendNumber, int yAxisIndex) {
        ArrayList<Map<String, Object>> seriesList = new ArrayList<Map<String, Object>>(10);
        if (StringUtils.isEmpty((String)yAxisNumber)) {
            return seriesList;
        }
        if (StringUtils.isEmpty((String)legendNumber)) {
            ArrayList data = new ArrayList(2);
            xAxisList.clear();
            dataSet.groupBy(new String[]{xAxisNumber}).sum(yAxisNumber).finish().forEach(e -> {
                xAxisList.add(this.getMemberName((Row)e, xAxisNumber));
                data.add(TypeUtils.convertValueToDecimal(e.getString(yAxisNumber)));
            });
            HashMap<String, Object> series = new HashMap<String, Object>();
            series.put(DisclosureConstants.ECHARTS_NAME_NAME, "");
            series.put(DisclosureConstants.ECHARTS_TYPE_NAME, typeName);
            series.put(DisclosureConstants.ECHARTS_DATA_NAME, data);
            if (yAxisIndex > 0) {
                series.put("yAxisIndex", yAxisIndex);
            }
            seriesList.add(series);
        } else {
            dataSet.groupBy(new String[]{xAxisNumber, legendNumber}).sum(yAxisNumber).finish().forEach(e -> {
                String legendName = this.getMemberName((Row)e, legendNumber);
                String xAxisName = this.getMemberName((Row)e, xAxisNumber);
                Map findSeries = seriesList.stream().filter(x -> Objects.equals(x.get(DisclosureConstants.ECHARTS_NAME_NAME).toString(), legendName)).findAny().orElse(null);
                if (Objects.nonNull(findSeries)) {
                    List valList = (List)findSeries.get(DisclosureConstants.ECHARTS_DATA_NAME);
                    valList.set(xAxisList.indexOf(xAxisName), TypeUtils.convertValueToDecimal(e.getString(yAxisNumber)));
                } else {
                    ArrayList<BigDecimal> valList = new ArrayList<BigDecimal>(xAxisList.size());
                    xAxisList.forEach(v -> valList.add(new BigDecimal(0)));
                    valList.set(xAxisList.indexOf(xAxisName), TypeUtils.convertValueToDecimal(e.getString(yAxisNumber)));
                    HashMap<String, Object> series = new HashMap<String, Object>();
                    series.put(DisclosureConstants.ECHARTS_NAME_NAME, legendName);
                    series.put(DisclosureConstants.ECHARTS_TYPE_NAME, typeName);
                    series.put(DisclosureConstants.ECHARTS_DATA_NAME, valList);
                    if (yAxisIndex > 0) {
                        series.put("yAxisIndex", yAxisIndex);
                    }
                    seriesList.add(series);
                }
            });
        }
        return seriesList;
    }

    protected void throwMustTips(Map<String, Object> returnData) {
        String errorMsg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7ec4\u4ef6\u5c5e\u6027\u7684\u5e03\u5c40\u9762\u677f\u4e2d\u5fc5\u586b\u9879\u3002", (String)"FidmCalculate_10", (String)"epm-far-business", (Object[])new Object[0]);
        returnData.put("errorMsg", errorMsg);
    }

    protected void throwEmptyDataTips(Map<String, Object> returnData) {
        String errorMsg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u4e3a\u7a7a\u3002", (String)"FidmCalculate_11", (String)"epm-far-business", (Object[])new Object[0]);
        returnData.put("errorMsg", errorMsg);
    }
}

