/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.AbstractCalculate;
import kd.epm.far.business.fidm.module.calculate.ColumnarCalculate;
import kd.epm.far.business.fidm.module.calculate.LineColumnarCalculate;
import kd.epm.far.business.fidm.module.calculate.ListCalculate;
import kd.epm.far.business.fidm.module.calculate.PieCalculate;
import kd.epm.far.business.fidm.module.calculate.VarCalculate;
import org.apache.commons.collections4.CollectionUtils;

public class CalculateHelper {
    public static final String DATASETTYPE_SINGLE = "1";
    public static final String DATASETTYPE_MULTIROW = "2";
    public static final String DATASETTYPE_MULTI = "3";
    public static final String ERROR_MSG = "errorMsg";
    public static final String SINGLE_VALUE = "singleValue";
    public static final String SINGLE_VALUE_PREFIX = "singleValue_prefix";
    public static final String SINGLE_VALUE_SUFFIX = "singleValue_suffix";

    public static AbstractCalculate calInstance(Long dmModelId, Object sourceData, JSONObject moduleProperties, List<DatasetFilterItem> filterItems) {
        AbstractCalculate calculateObj = null;
        try {
            String moduleType = moduleProperties.getString("type");
            if (ModuleEnum.VAR.getType().equals(moduleType)) {
                calculateObj = new VarCalculate(dmModelId, sourceData, moduleProperties, filterItems);
            } else if (ModuleEnum.PIE.getType().equals(moduleType) || ModuleEnum.DOUGHNUT.getType().equals(moduleType)) {
                calculateObj = new PieCalculate(dmModelId, sourceData, moduleProperties, filterItems);
            } else if (ModuleEnum.TABLE.getType().equals(moduleType)) {
                calculateObj = new ListCalculate(dmModelId, sourceData, moduleProperties, filterItems);
            } else if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equals(moduleType)) {
                calculateObj = new LineColumnarCalculate(dmModelId, sourceData, moduleProperties, filterItems);
            } else if (ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.STACKED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.LINE.getType().equals(moduleType) || ModuleEnum.AREA.getType().equals(moduleType)) {
                calculateObj = new ColumnarCalculate(dmModelId, sourceData, moduleProperties, filterItems);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u53ef\u89c6\u5316\u5bf9\u8c61\u5b9e\u4f8b\u5931\u8d25\u3002", (String)"CalculateHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return calculateObj;
    }

    public static DataSet createAlgoDataSet(List<Map<String, Object>> data, Set<String> numberKeys) {
        ArrayList<Object> columnList = null;
        columnList = CollectionUtils.isNotEmpty(data) ? new ArrayList<String>(data.get(0).keySet()) : new ArrayList();
        ArrayList<Object> typeList = new ArrayList<Object>(columnList.size());
        for (Object column : columnList) {
            if (Objects.nonNull(numberKeys) && numberKeys.contains(column)) {
                typeList.add(DataType.BigDecimalType);
                continue;
            }
            typeList.add(DataType.StringType);
        }
        ArrayList<Object[]> coll = new ArrayList<Object[]>(data.size());
        for (Map map : data) {
            Object[] tempData = new Object[columnList.size()];
            for (int i = 0; i < columnList.size(); ++i) {
                tempData[i] = map.get(columnList.get(i));
            }
            coll.add(tempData);
        }
        String[] columns = columnList.toArray(new String[columnList.size()]);
        DataType[] dataTypeArray = typeList.toArray(new DataType[typeList.size()]);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])columns, (DataType[])dataTypeArray);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)CalculateHelper.class.getName()).createDataSet(new Input[]{inputs});
    }

    @Deprecated
    public static DataSet whereByFilter(DataSet dataSet, DynamicObjectCollection datasetfilter, Set<String> numberKeys) {
        if (CollectionUtils.isEmpty((Collection)datasetfilter)) {
            return dataSet;
        }
        for (DynamicObject filter : datasetfilter) {
            String filterName = filter.getString("dimensionnumber");
            String filterValue = filter.getString("membernumber");
            String condition = filter.getString("condition");
            String value = filter.getString("value");
            String realValue = null;
            realValue = Objects.nonNull(numberKeys) && numberKeys.contains(filterName) ? value : "'" + filterValue + "'";
            if (Objects.equals("is null", condition) || Objects.equals("is not null", condition)) {
                condition = " " + condition;
                realValue = "";
            }
            dataSet = dataSet.where(filterName + condition + realValue);
        }
        return dataSet;
    }

    public static DataSet whereByFilter(DataSet dataSet, List<DatasetFilterItem> datasetfilter, Set<String> numberKeys) {
        if (CollectionUtils.isEmpty(datasetfilter)) {
            return dataSet;
        }
        for (DatasetFilterItem filter : datasetfilter) {
            String filterName = filter.getDimensionNumber();
            String filterValue = filter.getMemberNumber();
            String condition = filter.getCondition();
            String value = filter.getValue();
            String realValue = null;
            realValue = Objects.nonNull(numberKeys) && numberKeys.contains(filterName) ? value : "'" + filterValue + "'";
            if (Objects.equals("is null", condition) || Objects.equals("is not null", condition)) {
                condition = " " + condition;
                realValue = "";
            }
            dataSet = dataSet.where(filterName + condition + realValue);
        }
        return dataSet;
    }

    public static BigDecimal yuanToOther(BigDecimal amount, int ratio, int scale) {
        if (amount == null) {
            return BigDecimal.ZERO.setScale(scale);
        }
        BigDecimal result = amount.divide(new BigDecimal(ratio));
        result = result.setScale(scale, 4);
        return result;
    }

    private static BigDecimal yuanToOther(String amount, int ratio, int scale) {
        if (StringUtils.isEmpty((String)amount)) {
            return BigDecimal.ZERO.setScale(scale);
        }
        return CalculateHelper.yuanToOther(new BigDecimal(amount), ratio, scale);
    }

    public static BigDecimal convertValueToDecimal(String value, JSONObject dataPattern) {
        String numbertype;
        if (Objects.isNull(dataPattern) || dataPattern.isEmpty()) {
            return new BigDecimal(value);
        }
        String unit = dataPattern.getString("unit");
        DataPatternEnum pattern = StringUtils.isEmpty((String)unit) ? DataPatternEnum.YUAN : DataPatternEnum.getDataPatternByType(unit);
        String decimal = dataPattern.getString("decimal");
        if (StringUtils.isEmpty((String)decimal)) {
            decimal = DATASETTYPE_MULTIROW;
        }
        if (Objects.equals(DATASETTYPE_MULTI, numbertype = dataPattern.getString("numbertype"))) {
            decimal = Integer.toString(Integer.parseInt(decimal) + 2);
            pattern = DataPatternEnum.YUAN;
        }
        return CalculateHelper.yuanToOther(value, pattern.getRatio(), Integer.parseInt(decimal));
    }

    public static String getNumberFormatCode(JSONObject dataPattern) {
        int decimal = StringUtils.isNotEmpty((String)dataPattern.getString("decimal")) ? dataPattern.getInteger("decimal") : 2;
        boolean thousandth = dataPattern.getBoolean("thousandth");
        String currencysign = StringUtils.isNotEmpty((String)dataPattern.getString("currencysign")) ? dataPattern.getString("currencysign") : "";
        String numbertype = StringUtils.isNotEmpty((String)dataPattern.getString("numbertype")) ? dataPattern.getString("numbertype") : DATASETTYPE_SINGLE;
        String formatCode = "0";
        if (decimal > 0) {
            StringBuilder s = new StringBuilder(".");
            for (int i = 0; i < decimal; ++i) {
                s.append("0");
            }
            formatCode = formatCode + s;
        }
        if ((Objects.equals(DATASETTYPE_SINGLE, numbertype) || Objects.equals(DATASETTYPE_MULTIROW, numbertype)) && thousandth) {
            formatCode = "#,##" + formatCode;
        }
        if (Objects.equals(DATASETTYPE_MULTIROW, numbertype) && StringUtils.isNotEmpty((String)currencysign)) {
            formatCode = currencysign + formatCode;
        }
        if (Objects.equals(DATASETTYPE_MULTI, numbertype)) {
            formatCode = formatCode + "%";
        }
        return formatCode;
    }

    public static JSONObject getDataFormart(JSONObject properties, String firstNodeName, String secondNodeName) {
        JSONObject defaultVal = new JSONObject();
        defaultVal.put("unit", (Object)DATASETTYPE_SINGLE);
        defaultVal.put("thousandth", (Object)false);
        defaultVal.put("currencysign", (Object)"");
        defaultVal.put("decimal", (Object)DATASETTYPE_MULTIROW);
        defaultVal.put("numbertype", (Object)DATASETTYPE_SINGLE);
        return DisclosureJsonHelper.getJsonObject(properties, firstNodeName, secondNodeName, defaultVal);
    }

    public static JSONObject dataResultSuccess(Object data) {
        JSONObject dataResult = new JSONObject();
        dataResult.put("code", (Object)"0000");
        dataResult.put("data", data);
        dataResult.put("message", (Object)"success");
        return dataResult;
    }

    public static JSONObject dataResultFail(String msg) {
        JSONObject dataResult = new JSONObject();
        dataResult.put("code", (Object)"0001");
        dataResult.put("data", null);
        dataResult.put("message", (Object)msg);
        return dataResult;
    }

    public static String getDataError(String moduleName, Map<String, Object> dataMap) {
        if (dataMap.containsKey(ERROR_MSG)) {
            return moduleName + ":" + dataMap.get(ERROR_MSG);
        }
        return null;
    }
}

