/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.calculate.dto.FormularLogInfo;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.eb.EBReportsectionReader;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbMemberView;
import kd.epm.far.business.eb.dto.EbRptSectionExecMsResult;
import kd.epm.far.business.eb.dto.EbRptSectionExecParam;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.excel.ExcelConvert;
import kd.epm.far.business.fidm.excel.dto.TableConvertParam;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.dto.WordTableCellMargin;
import kd.epm.far.business.fidm.word.dto.WordTableCellMargins;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class EBReportSectionCalculate {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(EBReportSectionCalculate.class);

    public JSONObject createReportSection(Long dmModelId, List<DimensionInfo> dimDefaultMemberMap, JSONObject moduleProperties) {
        String msg = "";
        String moduleName = moduleProperties.getString("name");
        JSONObject reportSection = moduleProperties.getJSONObject("reportSection");
        if (reportSection == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u62a5\u8868\u5207\u7247\u7684\u5173\u952e\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_2", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            return CalculateHelper.dataResultFail(msg);
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        String componentId = DisclosureJsonHelper.getValue(moduleProperties, "specialMap", "componentId", "");
        EBReportsectionReader.getRptsection(LongUtil.toLong((Object)componentId), true);
        String selectedarea = "ALL";
        ArrayList<DimensionInfo> dimLogList = new ArrayList<DimensionInfo>(20);
        Map<String, EbMemberView> dimParamsVal = this.getDimMemberMap(dmModelId, dimDefaultMemberMap, reportSection, dimLogList);
        Map<String, Map<String, EbMemberView>> dimVarsVal = this.getVarMap(dmModelId, dimDefaultMemberMap, reportSection);
        EbRptSectionExecParam execParam = new EbRptSectionExecParam();
        execParam.setRptSectionId(LongUtil.toLong((Object)componentId));
        execParam.setDimParamsVal(dimParamsVal);
        execParam.setModelId(modelStrategyEx.getModel().getModelInfo().getModelId());
        execParam.setDimVarsVal(dimVarsVal);
        EbRptSectionExecMsResult reportSectionResult = EbServiceHelper.execRptSection(execParam);
        if (reportSectionResult == null) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u5173\u8054\u7f16\u5236\u62a5\u8868\u7684\u6570\u636e\u83b7\u53d6\u5931\u8d25\u65e0\u6548\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ModuleDataGeneralHelper_17", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            return CalculateHelper.dataResultFail(msg);
        }
        if (StringUtils.isNotEmpty((String)reportSectionResult.getGlobalError())) {
            return CalculateHelper.dataResultFail(reportSectionResult.getGlobalError());
        }
        if (reportSectionResult.getErrorSectionInfo().size() > 0) {
            return CalculateHelper.dataResultFail(reportSectionResult.getErrorSectionInfo().values().stream().findFirst().get());
        }
        if (StringUtils.isEmpty((String)reportSectionResult.getTablesUrl())) {
            msg = ResManager.loadKDString((String)"\u9884\u7b97\u5207\u7247\u8ba1\u7b97\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"ModuleDataGeneralHelper_26", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        byte[] excelData = DisclosureFileHelper.getFileBytes(reportSectionResult.getTablesUrl(), true);
        if (excelData == null) {
            msg = ResManager.loadKDString((String)"\u9884\u7b97\u5207\u7247\u8ba1\u7b97\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"ModuleDataGeneralHelper_26", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        String columnType = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "columnType", "1");
        double widthRate = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "widthRate", 1.0);
        boolean ignoreEmptyRowCol = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "ignoreEmptyRowCol", true);
        boolean cellFontFit = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cellFontFit", false);
        TableConvertParam tableConvertParam = new TableConvertParam(columnType, widthRate, selectedarea);
        tableConvertParam.setRemoveEmptyCell(ignoreEmptyRowCol);
        tableConvertParam.setCellFontFit(cellFontFit);
        WordTableNode tableNode = new ExcelConvert(excelData, tableConvertParam).createReportSection();
        this.resetTableNoode(tableNode, moduleProperties);
        this.resetTableCellMargin(tableNode, moduleProperties);
        if (tableNode == null || tableNode.getChilds().size() == 0) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u62a5\u8868\u5207\u7247\u533a\u57df\u65e0\u6570\u636e\uff0c\u8bf7\u8865\u5145\u540e\u91cd\u8bd5\u3002", (String)"ModuleDataGeneralHelper_18", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            return CalculateHelper.dataResultFail(msg);
        }
        JSONObject result = new JSONObject();
        result.put("list", new ArrayList(2));
        result.put("tableNode", (Object)JSON.toJSONString((Object)tableNode));
        result.put("formular", (Object)this.createFormularLogInfo(dimLogList));
        return CalculateHelper.dataResultSuccess(result);
    }

    private FormularLogInfo createFormularLogInfo(List<DimensionInfo> dimLogList) {
        FormularLogInfo logInfo = new FormularLogInfo();
        logInfo.setText("");
        logInfo.setDimList(dimLogList);
        return logInfo;
    }

    private void resetTableNoode(WordTableNode tableNode, JSONObject moduleProperties) {
        String bookKey = DisclosureJsonHelper.getValue(moduleProperties, "bookmark", "key", "");
        tableNode.setId(bookKey);
        String alignment = DisclosureJsonHelper.getValue(moduleProperties, "alignment", "2");
        tableNode.setAlignment(TypeUtils.convertValueToInt(alignment, 2));
        double leftInd = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "left", 0.0);
        tableNode.setLeftInd(leftInd * 567.0);
    }

    private void resetTableCellMargin(WordTableNode tableNode, JSONObject moduleProperties) {
        WordTableCellMargins wordTableCellMargins = new WordTableCellMargins();
        double left = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cell", "left", 0.2);
        WordTableCellMargin leftMargin = new WordTableCellMargin();
        leftMargin.setWidth(567.0 * left);
        wordTableCellMargins.setLeft(leftMargin);
        double right = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cell", "right", 0.2);
        WordTableCellMargin rightMargin = new WordTableCellMargin();
        rightMargin.setWidth(567.0 * right);
        wordTableCellMargins.setRight(rightMargin);
        double top = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cell", "top", 0.2);
        WordTableCellMargin topMargin = new WordTableCellMargin();
        topMargin.setWidth(567.0 * top);
        wordTableCellMargins.setTop(topMargin);
        double bottom = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cell", "bottom", 0.2);
        WordTableCellMargin bottomMargin = new WordTableCellMargin();
        bottomMargin.setWidth(567.0 * bottom);
        wordTableCellMargins.setBottom(bottomMargin);
        tableNode.setMargins(wordTableCellMargins);
    }

    private Map<String, EbMemberView> getDimMemberMap(Long dmModelId, List<DimensionInfo> dimDefaultMemberMap, JSONObject reportSection, List<DimensionInfo> dimLogList) {
        HashMap<String, String> dimMemberMap = new HashMap<String, String>(20);
        HashMap<String, DimensionInfo> dimLogMap = new HashMap<String, DimensionInfo>(20);
        String defaultDataSet = reportSection.getString("defaultDataSet");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDimList = modelStrategyEx.getDimMember().getDefaultMembers(defaultDataSet);
        for (DimensionInfo dimensionInfo : allDimList) {
            if (dimensionInfo.getMembers() == null || dimensionInfo.getMembers().size() == 0) continue;
            dimMemberMap.put(dimensionInfo.getNumber(), dimensionInfo.getMembers().get(0).getNumber());
            dimensionInfo.setMembers(Collections.singletonList(dimensionInfo.getMembers().get(0)));
            dimLogMap.put(dimensionInfo.getNumber(), dimensionInfo);
        }
        for (DimensionInfo dimensionInfo : dimDefaultMemberMap) {
            if (dimensionInfo.getMembers() == null || dimensionInfo.getMembers().size() == 0) continue;
            dimMemberMap.put(dimensionInfo.getNumber(), dimensionInfo.getMembers().get(0).getNumber());
            dimensionInfo.setMembers(Collections.singletonList(dimensionInfo.getMembers().get(0)));
            dimLogMap.put(dimensionInfo.getNumber(), dimensionInfo);
        }
        HashMap<String, String> dimMemberResult = new HashMap<String, String>(20);
        for (Object dimObject : reportSection.getJSONArray("reportDims")) {
            DimensionInfo dimensionInfo;
            String dimNumber;
            JSONObject dim = (JSONObject)dimObject;
            if (dim == null || StringUtils.isEmpty((String)(dimNumber = dim.getString("dim_number"))) || (dimensionInfo = DimensionUtils.getDimByNumber(allDimList, dimNumber)) == null) continue;
            if (StringUtils.isNotEmpty((String)dim.getString("member_id"))) {
                dimMemberResult.put(dimNumber, dim.getString("member_number"));
                if (!LongUtil.isvalidLong((Object)dim.getLong("member_id"))) continue;
                DimMemberInfo memberInfo = new DimMemberInfo();
                memberInfo.setId(dim.getLong("member_id"));
                memberInfo.setName(dim.getString("member_name"));
                memberInfo.setNumber(dim.getString("member_number"));
                dimensionInfo.setMembers(Collections.singletonList(memberInfo));
                dimLogList.add(dimensionInfo);
                continue;
            }
            if (dimMemberMap.get(dimNumber) == null) {
                String msg = String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u6210\u5458\u6570\u636e\u3002", (String)"ModuleDataGeneralHelper_25", (String)"epm-far-business", (Object[])new Object[0]), dimensionInfo.getName());
                throw new KDBizException(msg);
            }
            dimMemberResult.put(dimNumber, (String)dimMemberMap.get(dimNumber));
            if (dimLogMap.get(dimNumber) == null) continue;
            dimLogList.add((DimensionInfo)dimLogMap.get(dimNumber));
        }
        LinkedHashMap<String, EbMemberView> linkedHashMap = new LinkedHashMap<String, EbMemberView>(dimMemberResult.size());
        for (Map.Entry item : dimMemberResult.entrySet()) {
            EbMemberView memberView = new EbMemberView();
            memberView.setMemberNumber((String)item.getValue());
            DynamicObjectCollection views = EBReportsectionReader.getDefaultViewByDim(dmModelId, (String)item.getKey());
            if (views.size() > 0) {
                memberView.setViewId(((DynamicObject)views.get(0)).getLong("id"));
            }
            linkedHashMap.put((String)item.getKey(), memberView);
        }
        return linkedHashMap;
    }

    private Map<String, Map<String, EbMemberView>> getVarMap(Long dmModelId, List<DimensionInfo> dimDefaultMemberMap, JSONObject reportSection) {
        LinkedHashMap dimVarsVal = new LinkedHashMap(2);
        HashMap<String, String> dimMemberMap = new HashMap<String, String>(20);
        String defaultDataSet = reportSection.getString("defaultDataSet");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDimList = modelStrategyEx.getDimMember().getDefaultMembers(defaultDataSet);
        for (DimensionInfo item : allDimList) {
            if (item.getMembers() == null || item.getMembers().size() == 0) continue;
            dimMemberMap.put(item.getNumber(), item.getMembers().get(0).getNumber());
        }
        for (DimensionInfo item : dimDefaultMemberMap) {
            if (item.getMembers() == null || item.getMembers().size() == 0) continue;
            dimMemberMap.put(item.getNumber(), item.getMembers().get(0).getNumber());
        }
        HashMap<String, String> vars = new HashMap<String, String>(20);
        JSONArray reportVars = reportSection.getJSONArray("reportVars");
        if (reportVars != null) {
            for (Object dimObject : reportVars) {
                JSONObject dim = (JSONObject)dimObject;
                if (dim == null) continue;
                String number = dim.getString("number");
                String dimNumber = dim.getString("dim_number");
                if (StringUtils.isEmpty((String)dimNumber) || StringUtils.isEmpty((String)number)) continue;
                vars.put(number, "");
                DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDimList, dimNumber);
                if (dimensionInfo != null) {
                    if (dimMemberMap.get(dimNumber) != null) {
                        vars.put(number, (String)dimMemberMap.get(dimNumber));
                    }
                    if (StringUtils.isNotEmpty((String)dim.getString("member_number"))) {
                        vars.put(number, dim.getString("member_number"));
                    }
                }
                if (dimVarsVal.get(dimNumber) == null) {
                    dimVarsVal.put(dimNumber, vars);
                    continue;
                }
                Map curVars = (Map)dimVarsVal.get(dimNumber);
                for (Map.Entry item : vars.entrySet()) {
                    if (StringUtils.isEmpty((String)((String)item.getValue()))) continue;
                    curVars.put(item.getKey(), item.getValue());
                }
            }
        }
        LinkedHashMap<String, Map<String, EbMemberView>> dimMemberViewResult = new LinkedHashMap<String, Map<String, EbMemberView>>(dimVarsVal.size());
        for (Map.Entry entry : dimVarsVal.entrySet()) {
            if (entry.getValue() == null) continue;
            LinkedHashMap dimMemberDetailResult = new LinkedHashMap(((Map)entry.getValue()).size());
            for (Map.Entry item : ((Map)entry.getValue()).entrySet()) {
                EbMemberView memberView = new EbMemberView();
                memberView.setMemberNumber((String)item.getValue());
                DynamicObjectCollection views = EBReportsectionReader.getDefaultViewByDim(dmModelId, (String)item.getKey());
                if (views.size() > 0) {
                    memberView.setViewId(((DynamicObject)views.get(0)).getLong("id"));
                }
                dimMemberDetailResult.put(item.getKey(), memberView);
            }
            dimMemberViewResult.put((String)entry.getKey(), dimMemberDetailResult);
        }
        return dimMemberViewResult;
    }
}

