/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.fidm.base.DisclosureConstants;
import kd.epm.far.business.fidm.module.calculate.AbstractCalculate;
import kd.epm.far.business.fidm.module.calculate.SortHelper;
import org.apache.commons.collections.CollectionUtils;

public class LineColumnarCalculate
extends AbstractCalculate {
    public LineColumnarCalculate(Long dmModelId, Object sourceData, JSONObject moduleProperties, List<DatasetFilterItem> filterItems) {
        super(dmModelId, sourceData, moduleProperties, filterItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMultiRow() {
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        JSONObject specialMap = this.moduleProperties.getJSONObject("specialMap");
        String xAxisNumber = this.getDataSetColumnName(specialMap.getString("x"));
        String yAxisNumber = this.getDataSetColumnName(specialMap.getString("y"));
        String yAxisLineNumber = this.getDataSetColumnName(specialMap.getString("y1"));
        String legendNumber = this.getDataSetColumnName(specialMap.getString("columnarlegend"));
        String lineLegendNumber = this.getDataSetColumnName(specialMap.getString("linelegend"));
        String typeName = "bar";
        String lineTypeName = "line";
        if (StringUtils.isEmpty((String)xAxisNumber) || StringUtils.isEmpty((String)yAxisNumber) && StringUtils.isEmpty((String)yAxisLineNumber)) {
            this.throwMustTips(returnData);
            return returnData;
        }
        ArrayList<String> xAxisList = new ArrayList<String>();
        List<Object> seriesList = new ArrayList(10);
        try (DataSet dataSet = this.getDataSet();){
            if (dataSet.getRowMeta().getFieldCount() > 0) {
                DataSet copyDataSet = dataSet.copy();
                DataSet copyDataSet2 = dataSet.copy();
                dataSet.select(new String[]{xAxisNumber}).distinct().forEach(e -> xAxisList.add(this.getMemberName((Row)e, xAxisNumber)));
                if (xAxisList.size() > 0) {
                    List<Map<String, Object>> seriesList2;
                    seriesList = this.createXY(xAxisList, copyDataSet, typeName, xAxisNumber, yAxisNumber, legendNumber, 0);
                    if (!StringUtils.isEmpty((String)yAxisLineNumber) && (seriesList2 = this.createXY(xAxisList, copyDataSet2, lineTypeName, xAxisNumber, yAxisLineNumber, lineLegendNumber, 1)).size() > 0) {
                        seriesList.addAll(seriesList2);
                    }
                }
            }
            HashMap r = new HashMap();
            r.put(DisclosureConstants.ECHARTS_XAXIS_NAME, xAxisList);
            r.put(DisclosureConstants.ECHARTS_SERIES_NAME, seriesList);
            returnData.put(DisclosureConstants.ECHARTS_DATA_NAME, JSONObject.toJSON(r));
        }
        if (CollectionUtils.isEmpty(xAxisList)) {
            this.throwEmptyDataTips(returnData);
        }
        return returnData;
    }

    @Override
    protected void sortReturnData(Map returnData) {
        String linelegend;
        String columnarlegend;
        Map data = (Map)returnData.get(DisclosureConstants.ECHARTS_DATA_NAME);
        if (data == null) {
            return;
        }
        JSONObject specialMap = this.moduleProperties.getJSONObject("specialMap");
        String xAxisNumber = specialMap.getString("x");
        if (StringUtils.isNotEmpty((String)xAxisNumber)) {
            SortHelper.sortByKey(data, (Map<String, Object>)specialMap.getJSONObject("xSort"));
        }
        if (StringUtils.isNotEmpty((String)(columnarlegend = specialMap.getString("columnarlegend")))) {
            SortHelper.sortByValue(data, "bar", (Map<String, Object>)specialMap.getJSONObject("columnarlegendSort"));
        }
        if (StringUtils.isNotEmpty((String)(linelegend = specialMap.getString("linelegend")))) {
            SortHelper.sortByValue(data, "line", (Map<String, Object>)specialMap.getJSONObject("linelegendSort"));
        }
    }
}

