/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.enums.DisclosureSortEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.AbstractCalculate;
import kd.epm.far.business.fidm.util.TypeUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ListCalculate
extends AbstractCalculate {
    protected String keyAndString = "_";

    public ListCalculate(Long dmModelId, Object sourceData, JSONObject moduleProperties, List<DatasetFilterItem> filterItems) {
        super(dmModelId, sourceData, moduleProperties, filterItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMultiRow() {
        JSONObject specialMap = this.moduleProperties.getJSONObject("specialMap");
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        ArrayList list = new ArrayList(2);
        returnData.put("list", list);
        HashMap<String, String> columnConvertMap = new HashMap<String, String>(2);
        ArrayList<String> sourceSumColumns = new ArrayList<String>(2);
        ArrayList<String> newSumColumns = new ArrayList<String>(2);
        if (specialMap.get((Object)"y") != null) {
            String[] soucreSums;
            for (String oldSum : soucreSums = (String[])specialMap.get((Object)"y")) {
                String newSum = this.getDataSetColumnName(oldSum);
                if (StringUtils.isEmpty((String)newSum) || sourceSumColumns.contains(oldSum)) continue;
                sourceSumColumns.add(oldSum);
                newSumColumns.add(newSum);
                columnConvertMap.put(newSum, oldSum);
            }
        }
        String[] souceFields = (String[])specialMap.get((Object)"fields");
        ArrayList<String> newfields = new ArrayList<String>(2);
        for (String oldfield : souceFields) {
            String newfield = this.getDataSetColumnName(oldfield);
            if (StringUtils.isEmpty((String)newfield) || sourceSumColumns.contains(oldfield)) continue;
            newfields.add(newfield);
            columnConvertMap.put(newfield, oldfield);
        }
        boolean isAggregation = DisclosureJsonHelper.getValue(this.moduleProperties, "table", "isAggregation", true);
        if (isAggregation) {
            try (DataSet dataSet = this.getDataSet();){
                if (this.fieldNull(returnData, dataSet, newSumColumns.toArray(new String[0])) || this.fieldNull(returnData, dataSet, newfields.toArray(new String[0]))) {
                    HashMap<String, Object> oldSum = returnData;
                    return oldSum;
                }
                HashMap checkRow = new HashMap(2);
                for (String newSum : newSumColumns) {
                    dataSet.copy().groupBy(newfields.toArray(new String[0])).sum(newSum).finish().forEach(e -> {
                        Map<BigDecimal, String> row = new HashMap(newfields.size() + newSumColumns.size());
                        StringBuilder keyBuilder = new StringBuilder();
                        for (String newfield : newfields) {
                            String memberVal = this.getMemberName(e.getString(newfield), newfield);
                            keyBuilder.append(memberVal);
                            keyBuilder.append(this.keyAndString);
                            row.put((BigDecimal)columnConvertMap.get(newfield), memberVal);
                        }
                        if (checkRow.containsKey(keyBuilder.toString())) {
                            row = (Map)checkRow.get(keyBuilder.toString());
                            row.put((BigDecimal)columnConvertMap.get(newSum), (String)((Object)TypeUtils.convertValueToDecimal(e.getString(newSum))));
                        } else {
                            for (String sum : newSumColumns) {
                                row.put((BigDecimal)columnConvertMap.get(sum), (String)((Object)new BigDecimal(0)));
                            }
                            row.put((BigDecimal)columnConvertMap.get(newSum), (String)((Object)TypeUtils.convertValueToDecimal(e.getString(newSum))));
                            checkRow.put(keyBuilder.toString(), row);
                            list.add(row);
                        }
                    });
                }
            }
        }
        try (DataSet dataSet = this.getDataSet();){
            if (this.fieldNull(returnData, dataSet, newSumColumns.toArray(new String[0])) || this.fieldNull(returnData, dataSet, newfields.toArray(new String[0]))) {
                HashMap<String, Object> checkRow = returnData;
                return checkRow;
            }
            while (dataSet.hasNext()) {
                Row e2 = dataSet.next();
                HashMap row = new HashMap(newfields.size() + newSumColumns.size());
                for (String newfield : newfields) {
                    String memberVal = this.getMemberName(e2.getString(newfield), newfield);
                    row.put(columnConvertMap.get(newfield), memberVal);
                }
                for (String newSum : newSumColumns) {
                    row.put(columnConvertMap.get(newSum), TypeUtils.convertValueToDecimal(e2.getString(newSum)));
                }
                list.add(row);
            }
        }
        if (CollectionUtils.isEmpty(list)) {
            this.throwEmptyDataTips(returnData);
        }
        return returnData;
    }

    @Override
    protected void sortReturnData(Map returnData) {
        List data = (List)returnData.get("list");
        if (data == null || data.size() == 0) {
            return;
        }
        JSONArray tableProperty = DisclosureJsonHelper.getJSONArray(this.moduleProperties, "table", "property");
        if (tableProperty == null || tableProperty.size() == 0) {
            return;
        }
        List<Map> realTableProperty = this.getRealTableProperty(tableProperty);
        if (realTableProperty == null || realTableProperty.size() == 0) {
            return;
        }
        Map<String, List<Object>> sortData = this.getSortDataGroupByColumn(data);
        boolean is_sort = DisclosureJsonHelper.getValue(this.moduleProperties, "table", "columnVisible", "sort", true);
        Comparator<Map<String, Object>> comparators = null;
        for (Map columnMap : realTableProperty) {
            String sortType;
            DisclosureSortEnum sortEnum;
            Map sortSetting;
            String number = TypeUtils.getMapValueString(columnMap, "column");
            if (StringUtils.isEmpty((String)number) || !is_sort || (sortSetting = (Map)columnMap.get("sort")) == null || (sortEnum = DisclosureSortEnum.getEnumByName(sortType = sortSetting.get("type") == null ? "" : sortSetting.get("type").toString())) == null) continue;
            boolean isMoney = "2".equals(TypeUtils.getMapValueString(columnMap, "col_type"));
            boolean isAsc = sortEnum.toString().contains("_ASC");
            switch (sortEnum) {
                case NAME_ASC: 
                case NAME_DESC: 
                case MONEY_ASC: 
                case MONEY_DESC: {
                    if (comparators == null) {
                        comparators = this.buildComparator(number, isAsc, isMoney);
                        break;
                    }
                    comparators = comparators.thenComparing(this.buildComparator(number, isAsc, isMoney));
                    break;
                }
                case CUSTOM: {
                    String[] customValues;
                    String custom;
                    String string = custom = sortSetting.get("customValue") == null ? "" : sortSetting.get("customValue").toString().trim();
                    if (StringUtils.isEmpty((String)custom) || (customValues = custom.split(";")).length == 0) break;
                    HashMap sortMap = Maps.newHashMapWithExpectedSize((int)customValues.length);
                    for (int j = 0; j < customValues.length; ++j) {
                        if (isMoney) {
                            BigDecimal cV = new BigDecimal(customValues[j]);
                            if (!sortData.get(number).contains(cV)) continue;
                            sortMap.put(cV, j);
                            continue;
                        }
                        if (!sortData.get(number).contains(customValues[j])) continue;
                        sortMap.put(customValues[j], j);
                    }
                    List<Object> objects = sortData.get(number);
                    int finalLen = objects.size();
                    for (Object o : objects) {
                        sortMap.putIfAbsent(o, finalLen++);
                    }
                    comparators = comparators == null ? this.buildComparator(number, sortMap) : comparators.thenComparing(this.buildComparator(number, sortMap));
                }
            }
        }
        if (comparators != null) {
            data.sort(comparators);
        }
    }

    @Override
    protected void afterSortReturnData(Map returnData) {
        List data = (List)returnData.get("list");
        if (data == null || data.size() == 0) {
            return;
        }
        boolean is_top = DisclosureJsonHelper.getValue(this.moduleProperties, "table", "columnVisible", "top", false);
        if (!is_top) {
            return;
        }
        int top = DisclosureJsonHelper.getValue(this.moduleProperties, "table", "top", 0);
        if (top <= 0) {
            return;
        }
        if (data.size() <= top) {
            return;
        }
        ArrayList newData = new ArrayList(data.size());
        for (int i = 0; i < top; ++i) {
            newData.add(data.get(i));
        }
        returnData.put("list", newData);
    }

    private List<Map> getRealTableProperty(JSONArray tableProperty) {
        boolean is_priority = DisclosureJsonHelper.getValue(this.moduleProperties, "table", "columnVisible", "priority", true);
        int index = 10000;
        ArrayList<Map> realTableProperty = new ArrayList<Map>(tableProperty.size());
        for (Object columnObject : tableProperty) {
            Map column = (Map)columnObject;
            Map sort = (Map)column.get("sort");
            if (sort == null || !is_priority) continue;
            if (sort.get("priority") == null || StringUtils.isEmpty((String)sort.get("priority").toString())) {
                sort.put("priority", index++);
            }
            realTableProperty.add(column);
        }
        realTableProperty.sort(new Comparator<Map>(){

            @Override
            public int compare(Map o1, Map o2) {
                Integer priority1 = TypeUtils.convertValueToInt(((Map)o1.get("sort")).get("priority"));
                Integer priority2 = TypeUtils.convertValueToInt(((Map)o2.get("sort")).get("priority"));
                return priority1.compareTo(priority2);
            }
        });
        return realTableProperty;
    }

    private Map<String, List<Object>> getSortDataGroupByColumn(List<Map<String, Object>> data) {
        HashMap<String, List<Object>> sortData = new HashMap<String, List<Object>>(2);
        for (Map<String, Object> item : data) {
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                List<Object> itemVals;
                if (sortData.containsKey(entry.getKey())) {
                    itemVals = (List)sortData.get(entry.getKey());
                    itemVals.add(entry.getValue());
                    continue;
                }
                itemVals = new ArrayList(10);
                itemVals.add(entry.getValue());
                sortData.put(entry.getKey(), itemVals);
            }
        }
        return sortData;
    }

    private Comparator<Map<String, Object>> buildComparator(String number, boolean isAsc, boolean isMoney) {
        if (isAsc) {
            if (isMoney) {
                return Comparator.comparing(a -> TypeUtils.convertValueToDecimal(a.get(number).toString()));
            }
            return Comparator.comparing(a -> TypeUtils.toPinYinString(a.get(number).toString()));
        }
        if (isMoney) {
            return Comparator.comparing(a -> TypeUtils.convertValueToDecimal(String.valueOf(a.get(number))), Comparator.reverseOrder());
        }
        return Comparator.comparing(a -> TypeUtils.toPinYinString(a.get(number).toString()), Comparator.reverseOrder());
    }

    private Comparator<Map<String, Object>> buildComparator(String number, Map<Object, Integer> sortMap) {
        return Comparator.comparingInt(map -> (Integer)sortMap.get(map.get(number)));
    }
}

