/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.dataset.FidmDataSet;
import kd.epm.far.business.common.dataset.calculate.cal.CalculateCacheHelper;
import kd.epm.far.business.common.dataset.calculate.dto.FormularLogInfo;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.AbstractCalculate;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.module.calculate.EBReportSectionCalculate;
import kd.epm.far.business.fidm.module.calculate.ReportInfoCalculate;
import kd.epm.far.business.fidm.module.calculate.ReportSectionCalculate;
import kd.epm.far.business.fidm.module.calculate.TableCalculate;
import kd.epm.far.business.fidm.module.calculate.TocCalculate;
import kd.epm.far.common.common.json.JacksonUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class ModuleDataGeneralHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ModuleDataGeneralHelper.class);

    public static JSONObject getData(Long dmModelId, Long chapterId, List<DimensionInfo> dimDefaultMemberMapSource, String modifyname, JSONObject moduleProperties) {
        JSONObject dataResult = null;
        String msg = "";
        String moduleName = moduleProperties.getString("name");
        String moduleType = moduleProperties.getString("type");
        try {
            Map<String, Object> dataMap;
            String errorInfo;
            if (!ModuleEnum.containsType(moduleType).booleanValue()) {
                msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u7ec4\u4ef6\u7c7b\u578b\u5c1a\u672a\u652f\u6301\u3002", (String)"ModuleDataGeneralHelper_1", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
                moduleProperties.put("dataResult", (Object)ModuleDataGeneralHelper.dataResultFail(msg));
                return moduleProperties;
            }
            List<DimensionInfo> dimDefaultMemberMap = DisclosureJsonHelper.copyList(dimDefaultMemberMapSource, DimensionInfo.class);
            dataResult = ModuleEnum.TOC.getType().equals(moduleType) ? TocCalculate.createTOC() : (ModuleEnum.REPORT_SECTION.getType().equals(moduleType) ? new ReportSectionCalculate().createReportSection(dmModelId, dimDefaultMemberMap, moduleProperties) : (ModuleEnum.REPORT_INFO.getType().equals(moduleType) ? ReportInfoCalculate.createReportInfo(dmModelId, modifyname, dimDefaultMemberMap, moduleProperties) : (ModuleEnum.TABLE.getType().equals(moduleType) ? TableCalculate.createTable(dmModelId, chapterId, dimDefaultMemberMap, moduleProperties) : (ModuleEnum.EB_REPORT_SECTION.getType().equals(moduleType) ? new EBReportSectionCalculate().createReportSection(dmModelId, dimDefaultMemberMap, moduleProperties) : (!StringUtils.isEmpty((CharSequence)(errorInfo = CalculateHelper.getDataError(moduleName, dataMap = ModuleDataGeneralHelper.getDataSetInfo(dmModelId, chapterId, moduleProperties, dimDefaultMemberMap)))) ? ModuleDataGeneralHelper.dataResultFail(errorInfo) : ModuleDataGeneralHelper.dataResultSuccess(dataMap))))));
            moduleProperties.put("dataResult", (Object)dataResult);
            return moduleProperties;
        }
        catch (KDBizException kdBizException) {
            moduleProperties.put("dataResult", (Object)ModuleDataGeneralHelper.dataResultFail(moduleName + ":" + kdBizException.getMessage()));
            return moduleProperties;
        }
        catch (Exception ex) {
            msg = String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u8ba1\u7b97\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ModuleDataGeneralHelper_11", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            logger.error(msg, (Throwable)ex);
            moduleProperties.put("dataResult", (Object)ModuleDataGeneralHelper.dataResultFail(msg));
            return moduleProperties;
        }
    }

    public static Map<String, Object> getDataSetInfo(Long dmModelId, Long chapterId, JSONObject moduleProperties, List<DimensionInfo> dimDefaultMembers) {
        Object sourceData;
        Map<String, Object> returnData = new HashMap<String, Object>(100);
        JSONObject datasetObject = moduleProperties.getJSONObject("dataset");
        if (Objects.isNull(datasetObject.get((Object)"id")) || StringUtils.isEmpty((CharSequence)datasetObject.getString("id"))) {
            String title = ResManager.loadKDString((String)"\u6570\u636e\u96c6\u672a\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ModuleDataGeneralHelper_27", (String)"epm-far-business", (Object[])new Object[0]);
            returnData.put("errorMsg", title);
            return returnData;
        }
        Long datasetId = LongUtil.toLong((Object)datasetObject.get((Object)"id"));
        if (!LongUtil.isvalidLong((Object)datasetId)) {
            String title = ResManager.loadKDString((String)"\u6570\u636e\u96c6\u672a\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ModuleDataGeneralHelper_27", (String)"epm-far-business", (Object[])new Object[0]);
            returnData.put("errorMsg", title);
            return returnData;
        }
        List<DatasetFilterItem> datesetFilterItems = ModuleDataGeneralHelper.getDatasetFilterItems(datasetObject.getJSONArray("datesetFilterItems"));
        DynamicObject dataset = DatasetDataReader.getDataSet(datasetId);
        String datasetName = dataset.getString("name");
        List<DimensionInfo> dimDatasets = ModuleDataGeneralHelper.getDimVarFromItem(dmModelId, datasetObject);
        for (DimensionInfo d : dimDatasets) {
            DimensionInfo find = dimDefaultMembers.stream().filter(m -> m.getNumber().equalsIgnoreCase(d.getNumber())).findFirst().orElse(null);
            if (find == null) {
                dimDefaultMembers.add(d);
                continue;
            }
            if (d.getMembers().size() <= 0) continue;
            find.setMembers(d.getMembers());
        }
        Map<String, Object> varParams = ModuleDataGeneralHelper.getVarParams(datasetObject);
        FidmDataSet fidmDataSet = null;
        try {
            fidmDataSet = new FidmDataSet(chapterId, datasetId, dimDefaultMembers, varParams, false);
            sourceData = fidmDataSet.getResult();
            if (sourceData instanceof RuntimeException) {
                ModuleDataGeneralHelper.returnDataError(returnData, (RuntimeException)sourceData);
                return returnData;
            }
        }
        catch (KDBizException kdBizException) {
            String msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6[%1$s]\u8ba1\u7b97\u5931\u8d25\uff0c%2$s", (String)"DataSetService_2", (String)"epm-far-business", (Object[])new Object[0]), datasetName, kdBizException.getMessage());
            ModuleDataGeneralHelper.returnDataError(returnData, (Exception)((Object)new KDBizException(msg)));
            return returnData;
        }
        catch (Exception ex) {
            String tips = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6[%1$s]\u8ba1\u7b97\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"DataSetService_3", (String)"epm-far-business", (Object[])new Object[0]), datasetName);
            logger.error(tips, (Throwable)ex);
            ModuleDataGeneralHelper.returnDataError(returnData, (Exception)((Object)new KDBizException(tips)));
            return returnData;
        }
        try {
            FormularLogInfo formularLogInfo;
            AbstractCalculate calculateService = CalculateHelper.calInstance(dmModelId, sourceData, moduleProperties, datesetFilterItems);
            if (calculateService == null) {
                String errorMsg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u8ba1\u7b97\u7f3a\u5931\uff0c\u65e0\u4efb\u4f55\u8ba1\u7b97\u7c7b\u3002", (String)"ModuleDataGeneralHelper_9", (String)"epm-far-business", (Object[])new Object[0]);
                returnData.put("errorMsg", errorMsg);
            } else {
                returnData = calculateService.calculate();
            }
            if (fidmDataSet != null && (formularLogInfo = CalculateCacheHelper.getAndRemoveFormularLogInfo(fidmDataSet.getCalcId())) != null) {
                returnData.put("formular", formularLogInfo);
            }
        }
        catch (KDBizException kdBizException) {
            String title = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7ec4\u4ef6\u8bbe\u7f6e\u4fe1\u606f\u6216\u5f02\u5e38\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"ModuleDataGeneralHelper_23", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(title, (Throwable)kdBizException);
            returnData.put("errorMsg", kdBizException.getMessage());
        }
        catch (Exception e) {
            String title = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7ec4\u4ef6\u8bbe\u7f6e\u4fe1\u606f\u6216\u5f02\u5e38\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"ModuleDataGeneralHelper_23", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(title, (Throwable)e);
            returnData.put("errorMsg", title);
        }
        return returnData;
    }

    private static List<DimensionInfo> getDimVarFromItem(Long dmModelId, JSONObject datasetObject) {
        List<DimensionInfo> dimensionInfos = new ArrayList<DimensionInfo>(20);
        if (datasetObject == null) {
            return dimensionInfos;
        }
        JSONArray array = datasetObject.getJSONArray("dimParams");
        if (array == null || array.size() == 0) {
            return dimensionInfos;
        }
        List<DimensionInfo> allDimensions = new ModelStrategyEx(dmModelId).getDim().getDimList();
        LinkedHashMap<String, DimensionInfo> dimensionInfoMap = new LinkedHashMap<String, DimensionInfo>(allDimensions.size());
        for (Object item : array) {
            DimMemberInfo memberInfo;
            DimensionInfo findDim;
            JSONObject dimItem = (JSONObject)item;
            if (dimItem == null || (findDim = DimensionUtils.getDimByNumber(allDimensions, dimItem.getString("number"))) == null) continue;
            String isDim = dimItem.getString("isDim");
            if ("2".equalsIgnoreCase(isDim)) {
                JSONArray members = dimItem.getJSONArray("members");
                if (members == null || members.size() <= 0) continue;
                for (Object memberObject : members) {
                    DimMemberInfo memberInfo2 = DimensionUtils.convertToMemberInfo((Map)((JSONObject)memberObject));
                    findDim.getMembers().add(memberInfo2);
                }
                dimensionInfoMap.put(findDim.getNumber(), findDim);
                continue;
            }
            JSONObject member = dimItem.getJSONObject("member");
            if (member == null || !StringUtils.isNotEmpty((CharSequence)member.getString("number")) || (memberInfo = DimensionUtils.convertToMemberInfo((Map)member)) == null) continue;
            findDim.getMembers().add(memberInfo);
            dimensionInfoMap.put(findDim.getNumber(), findDim);
        }
        dimensionInfos = dimensionInfoMap.values().stream().collect(Collectors.toList());
        return dimensionInfos;
    }

    private static Map<String, Object> getVarParams(JSONObject datasetObject) {
        HashMap<String, Object> varParams = new HashMap<String, Object>(2);
        if (datasetObject == null) {
            return varParams;
        }
        JSONArray varParamsObject = datasetObject.getJSONArray("varParams");
        if (varParamsObject == null || varParamsObject.size() == 0) {
            return varParams;
        }
        for (Object varObject : varParamsObject) {
            JSONObject varJsonObject = (JSONObject)varObject;
            String number = varJsonObject.getString("number");
            Object modifyvalue = varJsonObject.get((Object)"modifyvalue");
            if (modifyvalue == null) continue;
            varParams.put(number, modifyvalue);
        }
        return varParams;
    }

    private static void returnDataError(Map<String, Object> returnData, Exception e) {
        String excepMsg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u96c6\u53d6\u6570\u5f02\u5e38", (String)"ModuleDataGeneralHelper_8", (String)"epm-far-business", (Object[])new Object[0]);
        logger.error(excepMsg, (Throwable)e);
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(excepMsg).append(":").append(e.getMessage());
        returnData.put("errorMsg", errorMsg.toString());
    }

    private static List<DatasetFilterItem> getDatasetFilterItems(JSONArray filterItemsObject) {
        List<DatasetFilterItem> datesetFilterItems = new ArrayList<DatasetFilterItem>();
        if (Objects.nonNull(filterItemsObject)) {
            datesetFilterItems = (List)JacksonUtils.fromJson((String)filterItemsObject.toJSONString(), (TypeReference)new TypeReference<List<DatasetFilterItem>>(){});
        }
        return datesetFilterItems;
    }

    public static JSONObject dataResultSuccess(Object data) {
        return CalculateHelper.dataResultSuccess(data);
    }

    public static JSONObject dataResultFail(String msg) {
        return CalculateHelper.dataResultFail(msg);
    }

    public static List<JSONObject> filerErrorModules(List<JSONObject> allModules) {
        ArrayList<JSONObject> modules = new ArrayList<JSONObject>(allModules.size());
        for (JSONObject moduleProperties : allModules) {
            if (moduleProperties == null) continue;
            JSONObject dataResult = ModuleDataGeneralHelper.getDataResultObject(moduleProperties);
            if (dataResult == null) {
                modules.add(moduleProperties);
                continue;
            }
            if (!"0001".equalsIgnoreCase(dataResult.getString("code"))) continue;
            modules.add(moduleProperties);
        }
        return modules;
    }

    public static JSONObject getDataResultObject(JSONObject moduleProperties) {
        Object moduleObject = moduleProperties.get((Object)"dataResult");
        if (moduleObject == null) {
            return null;
        }
        JSONObject dataResult = (JSONObject)moduleObject;
        if (dataResult == null) {
            return null;
        }
        return dataResult;
    }
}

