/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.enums.DisclosureSortEnum;
import kd.epm.far.business.fidm.base.DisclosureConstants;
import kd.epm.far.business.fidm.module.calculate.AbstractCalculate;
import kd.epm.far.business.fidm.util.TypeUtils;
import org.apache.commons.collections.CollectionUtils;

public class PieCalculate
extends AbstractCalculate {
    public PieCalculate(Long dmModelId, Object sourceData, JSONObject moduleProperties, List<DatasetFilterItem> filterItems) {
        super(dmModelId, sourceData, moduleProperties, filterItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMultiRow() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        JSONObject specialMap = this.moduleProperties.getJSONObject("specialMap");
        String legendNumber = this.getDataSetColumnName(specialMap.getString("legend"));
        String displayValueNumber = this.getDataSetColumnName(specialMap.getString("detail"));
        ArrayList list = new ArrayList(10);
        returnData.put(DisclosureConstants.RETURN_DATA_NAME, JSONObject.toJSON(list));
        if (StringUtils.isEmpty((String)legendNumber) || StringUtils.isEmpty((String)displayValueNumber)) {
            return returnData;
        }
        try (DataSet dataSet = this.getDataSet();){
            if (dataSet.getRowMeta().getFieldCount() > 0) {
                for (Row e : dataSet.groupBy(new String[]{legendNumber}).sum(displayValueNumber).finish()) {
                    HashMap<String, Object> r = new HashMap<String, Object>();
                    r.put("name", this.getMemberName(e, legendNumber));
                    r.put("value", TypeUtils.convertValueToDecimal(e.getString(displayValueNumber)));
                    list.add(r);
                }
            }
        }
        if (CollectionUtils.isEmpty(list)) {
            this.throwEmptyDataTips(returnData);
        }
        returnData.put(DisclosureConstants.RETURN_DATA_NAME, JSONObject.toJSON(list));
        return returnData;
    }

    @Override
    protected void sortReturnData(Map returnData) {
        List list = (List)returnData.get(DisclosureConstants.ECHARTS_DATA_NAME);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        JSONObject specialMap = this.moduleProperties.getJSONObject("specialMap");
        String legendNumber = specialMap.getString("legend");
        if (StringUtils.isNotEmpty((String)legendNumber)) {
            this.sort(list, (Map<String, Object>)specialMap.getJSONObject("legendSort"));
        }
    }

    private void sort(List<Map<String, Object>> list, Map<String, Object> sortSetting) {
        if (sortSetting == null) {
            return;
        }
        String sortType = sortSetting.get("type") == null ? "" : sortSetting.get("type").toString();
        final DisclosureSortEnum sortEnum = DisclosureSortEnum.getEnumByName(sortType);
        if (sortEnum == null) {
            return;
        }
        String sortKey = "name";
        final Map<String, List<Map>> sortMap = list.stream().collect(Collectors.groupingBy(t -> (String)t.get(sortKey)));
        ArrayList newList = Lists.newArrayListWithCapacity((int)list.size());
        switch (sortEnum) {
            case NAME_ASC: 
            case NAME_DESC: {
                Stream<String> sortedX = sortMap.keySet().stream().sorted(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return TypeUtils.toPinYinString(o1).compareTo(TypeUtils.toPinYinString(o2)) * sortEnum.getOrderBy();
                    }
                });
                sortedX.forEach(t -> newList.addAll((Collection)sortMap.get(t)));
                list.clear();
                list.addAll(newList);
                break;
            }
            case MONEY_ASC: 
            case MONEY_DESC: {
                Stream<String> sortedX = sortMap.keySet().stream().sorted(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        List map1 = (List)sortMap.get(o1);
                        List map2 = (List)sortMap.get(o2);
                        BigDecimal totalMoney1 = BigDecimal.ZERO;
                        BigDecimal totalMoney2 = BigDecimal.ZERO;
                        for (Map map : map1) {
                            totalMoney1 = totalMoney1.add(new BigDecimal(map.get("value").toString()));
                        }
                        for (Map map : map2) {
                            totalMoney2 = totalMoney2.add(new BigDecimal(map.get("value").toString()));
                        }
                        return totalMoney1.compareTo(totalMoney2) * sortEnum.getOrderBy();
                    }
                });
                sortedX.forEach(t -> newList.addAll((Collection)sortMap.get(t)));
                list.clear();
                list.addAll(newList);
                break;
            }
            case CUSTOM: {
                String custom;
                String string = custom = sortSetting.get("customValue") == null ? "" : sortSetting.get("customValue").toString().trim();
                if (StringUtils.isEmpty((String)custom) || StringUtils.isEmpty((String)custom)) break;
                List<String> customList = Arrays.stream(custom.split(";")).distinct().collect(Collectors.toList());
                customList.retainAll(sortMap.keySet());
                if (CollectionUtils.isEmpty(customList)) break;
                customList.forEach(t -> newList.addAll((Collection)sortMap.get(t)));
                for (Map.Entry<String, List<Map>> entry : sortMap.entrySet()) {
                    if (customList.contains(entry.getKey())) continue;
                    newList.addAll((Collection)entry.getValue());
                }
                list.clear();
                list.addAll(newList);
                break;
            }
        }
    }
}

