/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONObject;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.common.common.enums.dimension.SysDimensionEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class ReportInfoCalculate {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportInfoCalculate.class);

    public static JSONObject createReportInfo(Long dmModelId, String modifyname, List<DimensionInfo> dimDefaultMembers, JSONObject moduleProperties) {
        String rptInfoNumber;
        String msg = "";
        String moduleName = moduleProperties.getString("name");
        JSONObject specialMap = moduleProperties.getJSONObject("specialMap");
        if (specialMap == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u7f16\u62a5\u4fe1\u606f\u7684\u5173\u952e\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_6", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            return CalculateHelper.dataResultFail(msg);
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
        StringBuilder strText = new StringBuilder();
        String rptPrefix = specialMap.getString("rptPrefix");
        if (!StringUtils.isEmpty((CharSequence)rptPrefix)) {
            strText.append(rptPrefix);
        }
        if (!StringUtils.isEmpty((CharSequence)(rptInfoNumber = specialMap.getString("rptInfoNumber")))) {
            if (rptInfoNumber.equals("modifytime")) {
                String rptDateFormatNumber;
                String string = rptDateFormatNumber = specialMap.get((Object)"rptDateFormatNumber") == null ? "" : specialMap.get((Object)"rptDateFormatNumber").toString();
                if (StringUtils.isEmpty((CharSequence)rptDateFormatNumber)) {
                    rptDateFormatNumber = "YYYYMMDD";
                }
                String format = "";
                try {
                    if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(modelType)) {
                        DimensionInfo year = ReportInfoCalculate.getDim(dimDefaultMembers, "BudgetPeriod");
                        format = ReportInfoCalculate.getEBDateStr(dmModelId, moduleName, rptDateFormatNumber, year);
                    } else {
                        String yearNumber = ReportInfoCalculate.getDimStr(dimDefaultMembers, SysDimensionEnum.Year.getNumber(), true);
                        String periodNumber = ReportInfoCalculate.getDimStr(dimDefaultMembers, SysDimensionEnum.Period.getNumber(), true);
                        format = ReportInfoCalculate.getDateStr(dmModelId, moduleName, rptDateFormatNumber, yearNumber, periodNumber);
                    }
                }
                catch (KDBizException kEx) {
                    return CalculateHelper.dataResultFail(kEx.getMessage());
                }
                if (!StringUtils.isEmpty((CharSequence)format)) {
                    strText.append(format);
                }
            } else if (rptInfoNumber.equals("entity.name")) {
                String entityName = ReportInfoCalculate.getDimStr(dimDefaultMembers, SysDimensionEnum.Entity.getNumber(), false);
                if (!StringUtils.isEmpty((CharSequence)entityName)) {
                    strText.append(entityName);
                }
            } else if (rptInfoNumber.equals("entity.number")) {
                String entityNumber = ReportInfoCalculate.getDimStr(dimDefaultMembers, SysDimensionEnum.Entity.getNumber(), true);
                if (!StringUtils.isEmpty((CharSequence)entityNumber)) {
                    strText.append(entityNumber);
                }
            } else if (rptInfoNumber.equals("modifyname") && StringUtils.isNotEmpty((CharSequence)modifyname)) {
                strText.append(modifyname);
            }
        }
        JSONObject result = new JSONObject();
        result.put("text", (Object)strText.toString());
        return CalculateHelper.dataResultSuccess(result);
    }

    private static String getDimStr(List<DimensionInfo> dimDefaultMembers, String dimNumber, boolean isNumber) {
        String number = "";
        DimensionInfo year = DimensionUtils.getDimByNumber(dimDefaultMembers, dimNumber);
        if (year != null && year.getMembers().size() > 0) {
            number = isNumber ? year.getMembers().get(0).getNumber() : year.getMembers().get(0).getName();
        }
        return number;
    }

    private static DimensionInfo getDim(List<DimensionInfo> dimDefaultMembers, String dimNumber) {
        DimensionInfo year = DimensionUtils.getDimByNumber(dimDefaultMembers, dimNumber);
        return year;
    }

    private static String getDateStr(Long modelId, String moduleName, String dateFormat, String yearNumber, String periodNumber) {
        String msg = "";
        if (kd.bos.util.StringUtils.isEmpty((String)yearNumber)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u8d22\u5e74\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"ModuleDataGeneralHelper_14", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)periodNumber)) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u671f\u95f4\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"ModuleDataGeneralHelper_13", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        QFilter modelFilter = new QFilter("model.id", "=", (Object)modelId);
        QFilter numberFilter = new QFilter("number", "=", (Object)periodNumber);
        DynamicObject periodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"id, expday, expmonth", (QFilter[])new QFilter[]{numberFilter, modelFilter});
        if (periodDy == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u671f\u95f4\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"ModuleDataGeneralHelper_13", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        Integer expmonth = periodDy.getInt("expmonth");
        Integer expday = periodDy.getInt("expday");
        return ReportInfoCalculate.getDateStr(moduleName, dateFormat, yearNumber, periodNumber, expmonth, expday);
    }

    private static String getEBDateStr(Long dmModelId, String moduleName, String dateFormat, DimensionInfo periodDim) {
        String msg = "";
        String result = "";
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        if (periodDim == null || periodDim.getMembers().size() == 0) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u671f\u95f4\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"ModuleDataGeneralHelper_13", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        DimMemberInfo memberInfo = periodDim.getMembers().get(0);
        QFilter modelFilter = new QFilter("model.id", "=", (Object)modelStrategyEx.getModel().getModelInfo().getModelId());
        QFilter numberFilter = new QFilter("id", "=", (Object)memberInfo.getId());
        DynamicObject periodDy = BusinessDataServiceHelper.loadSingleFromCache((String)periodDim.getEntityName(), (String)"id, expday, expmonth", (QFilter[])new QFilter[]{numberFilter, modelFilter});
        if (periodDy == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u671f\u95f4\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"ModuleDataGeneralHelper_13", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        int splitIndex = memberInfo.getNumber().lastIndexOf(".");
        String yearNumber = memberInfo.getNumber().substring(0, splitIndex);
        String periodNumber = memberInfo.getNumber().substring(splitIndex + 1, memberInfo.getNumber().length());
        Integer expmonth = periodDy.getInt("expmonth");
        Integer expday = periodDy.getInt("expday");
        return ReportInfoCalculate.getDateStr(moduleName, dateFormat, yearNumber, periodNumber, expmonth, expday);
    }

    private static String getDateStr(String moduleName, String dateFormat, String yearNumber, String periodNumber, Integer expmonth, Integer expday) {
        boolean containChiness = ReportInfoCalculate.containsChinese(dateFormat);
        if ("MM".equalsIgnoreCase(dateFormat)) {
            containChiness = true;
        }
        int lastDay = ReportInfoCalculate.getLastday(yearNumber, expmonth, expday);
        expday = expday < lastDay ? expday : lastDay;
        if (expmonth == 0 && expday == 0) {
            String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u671f\u95f4\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"ModuleDataGeneralHelper_13", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        String result = dateFormat;
        if (dateFormat.contains("YYYY")) {
            result = dateFormat.replace("YYYY", yearNumber.replace("FY", ""));
        } else if (dateFormat.contains("yyyy")) {
            result = dateFormat.replace("yyyy", yearNumber.replace("FY", ""));
        }
        if (dateFormat.contains("MM")) {
            result = containChiness ? result.replace("MM", Integer.toString(expmonth)) : result.replace("MM", expmonth < 10 ? "0" + expmonth : Integer.toString(expmonth));
        }
        if (dateFormat.contains("Q") && expmonth != 0) {
            int periodNum = 0;
            int n = periodNum = expmonth > 12 ? 4 : (int)Math.ceil((double)expmonth.intValue() / 3.0);
            if (periodNumber.contains("Q_Q")) {
                periodNum = Integer.parseInt(periodNumber.replace("Q_Q", "").trim());
            }
            result = containChiness ? result.replace("Q", Integer.toString(periodNum)) : result.replace("Q", periodNum < 10 ? "0" + periodNum : Integer.toString(periodNum));
        }
        if (dateFormat.contains("DD")) {
            result = containChiness ? result.replace("DD", Integer.toString(expday)) : result.replace("DD", expday < 10 ? "0" + expday : Integer.toString(expday));
        }
        return result;
    }

    private static boolean containsChinese(String str) {
        Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private static Integer getLastday(String yearNumber, int expmonth, int expday) {
        try {
            return ReportInfoCalculate.getLastDay(Integer.parseInt(yearNumber.replace("FY", "")), expmonth - 1, expday);
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u8d22\u5e74\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ModuleDataGeneralHelper_24", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private static int getLastDay(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, year);
        c.set(2, month);
        int maxDay = c.getActualMaximum(5);
        c.set(5, maxDay);
        return c.get(5);
    }
}

