/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dto.ReportSectionAreaInfo;
import kd.epm.far.common.common.util.RangeModel;

public class ReportSectionAreaHelper {
    public static String getFloatArea(String selectedarea, List<ReportSectionAreaInfo> areaInfos) {
        String area = "";
        if (StringUtils.isEmpty((String)selectedarea) || "ALL".equalsIgnoreCase(selectedarea)) {
            return area;
        }
        area = selectedarea;
        if (areaInfos == null || areaInfos.size() == 0) {
            return area;
        }
        RangeModel cutArea = new RangeModel(selectedarea);
        List<ReportSectionAreaInfo> joinList = ReportSectionAreaHelper.getJoinAreas(cutArea, areaInfos);
        if (joinList.size() == 0) {
            return area;
        }
        int xStart = cutArea.getX_start();
        int yStart = cutArea.getY_start();
        int xEnd = cutArea.getX_end();
        int yEnd = cutArea.getY_end();
        for (ReportSectionAreaInfo areaInfo : joinList) {
            RangeModel real = ReportSectionAreaHelper.getRealArea(cutArea, areaInfo);
            if (xStart > real.getX_start()) {
                xStart = real.getX_start();
            }
            if (yStart > real.getY_start()) {
                yStart = real.getY_start();
            }
            if (xEnd < real.getX_end()) {
                xEnd = real.getX_end();
            }
            if (yEnd >= real.getY_end()) continue;
            yEnd = real.getY_end();
        }
        RangeModel realArea = new RangeModel(selectedarea);
        realArea.setX_start(xStart);
        realArea.setY_start(yStart);
        realArea.setX_end(xEnd);
        realArea.setY_end(yEnd);
        area = realArea.getAreaRangeStr();
        return area;
    }

    private static List<ReportSectionAreaInfo> getJoinAreas(RangeModel cutArea, List<ReportSectionAreaInfo> areaInfos) {
        ArrayList<ReportSectionAreaInfo> list = new ArrayList<ReportSectionAreaInfo>(areaInfos.size());
        if (areaInfos == null || areaInfos.size() == 0) {
            return list;
        }
        for (ReportSectionAreaInfo areaInfo : areaInfos) {
            if (StringUtils.isEmpty((String)areaInfo.getOriginalArea()) || areaInfo.getFloatAreas() == null || areaInfo.getFloatAreas().size() == 0) continue;
            RangeModel origin = new RangeModel(areaInfo.getOriginalArea());
            if (cutArea.getX_end() < origin.getX_start() || cutArea.getX_start() > origin.getX_end() || cutArea.getY_end() < origin.getY_start() || cutArea.getY_start() > origin.getY_end()) continue;
            list.add(areaInfo);
        }
        return list;
    }

    private static RangeModel getRealArea(RangeModel cutArea, ReportSectionAreaInfo areaInfo) {
        RangeModel real = new RangeModel(areaInfo.getArea());
        RangeModel origin = new RangeModel(areaInfo.getOriginalArea());
        int xStartOffset = origin.getX_start() - cutArea.getX_start();
        int yStartOffset = origin.getY_start() - cutArea.getY_start();
        int xEndOffset = cutArea.getX_end() - origin.getX_end();
        int yEndOffset = cutArea.getY_end() - origin.getY_end();
        if (xStartOffset < 0) {
            xStartOffset = 0;
        }
        if (yStartOffset < 0) {
            yStartOffset = 0;
        }
        if (xEndOffset < 0) {
            xEndOffset = 0;
        }
        if (yEndOffset < 0) {
            yEndOffset = 0;
        }
        real.setX_start(real.getX_start() - xStartOffset);
        real.setY_start(real.getY_start() - yStartOffset);
        real.setX_end(real.getX_end() + xEndOffset);
        real.setY_end(real.getY_end() + yEndOffset);
        return real;
    }
}

