/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.ReportSectionResult;
import kd.epm.far.business.common.dataset.calculate.dto.FormularLogInfo;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.business.far.model.DimDefaultValueVo;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.excel.ExcelConvert;
import kd.epm.far.business.fidm.excel.dto.TableConvertParam;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.module.calculate.ReportSectionAreaHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.dto.WordTableCellMargin;
import kd.epm.far.business.fidm.word.dto.WordTableCellMargins;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class ReportSectionCalculate {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportSectionCalculate.class);

    public JSONObject createReportSection(Long dmModelId, List<DimensionInfo> dimDefaultMemberMap, JSONObject moduleProperties) {
        String msg = "";
        String moduleName = moduleProperties.getString("name");
        JSONObject reportSection = moduleProperties.getJSONObject("reportSection");
        if (reportSection == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u62a5\u8868\u5207\u7247\u7684\u5173\u952e\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_2", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            return CalculateHelper.dataResultFail(msg);
        }
        String componentId = DisclosureJsonHelper.getValue(moduleProperties, "specialMap", "componentId", "");
        DynamicObject component = QueryServiceHelper.queryOne((String)"bcm_component_info", (String)"id,template.templatetype,template.id,template.status,selectedarea", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)componentId)).toArray());
        if (component == null) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u5173\u8054\u7f16\u5236\u62a5\u8868\u7684\u6570\u636e\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u62a5\u8868\u5207\u7247\u4fdd\u5b58\u3002", (String)"ModuleDataGeneralHelper_3", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            return CalculateHelper.dataResultFail(msg);
        }
        if ("0".equalsIgnoreCase(component.getString("template.status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u5207\u7247\u5f15\u7528\u6a21\u677f\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DisclosureServiceHelper_28", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ArrayList<DimensionInfo> dimLogList = new ArrayList<DimensionInfo>(20);
        Map<String, String> dimMemberMap = this.getDimMemberMap(dmModelId, dimDefaultMemberMap, reportSection, dimLogList);
        String selectedarea = component.getString("selectedarea");
        Long templateId = component.getLong("template.id");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(3);
        params.put("modelId", dmModelId);
        params.put("templateId", templateId);
        params.put("dimMemberMap", dimMemberMap);
        params.put("viewDataUnit", this.convertToViewDataunit(moduleProperties));
        params.put("scale", this.convertToScale(moduleProperties));
        params.put("sourceStyle", DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "styleData", "styleSource", "1"));
        params.put("floatDispay", DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "styleData", "floatDisplay", "3"));
        ReportSectionResult reportSectionResult = BCMMsServiceHelper.getExcelDataByReportsection(params);
        if (reportSectionResult == null) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u5173\u8054\u7f16\u5236\u62a5\u8868\u7684\u6570\u636e\u83b7\u53d6\u5931\u8d25\u65e0\u6548\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ModuleDataGeneralHelper_17", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            return CalculateHelper.dataResultFail(msg);
        }
        selectedarea = ReportSectionAreaHelper.getFloatArea(selectedarea, reportSectionResult.getAreaData());
        String columnType = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "columnType", "1");
        double widthRate = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "widthRate", 1.0);
        boolean ignoreEmptyRowCol = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "ignoreEmptyRowCol", true);
        boolean cellFontFit = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cellFontFit", false);
        TableConvertParam tableConvertParam = new TableConvertParam(columnType, widthRate, selectedarea);
        tableConvertParam.setRemoveEmptyCell(ignoreEmptyRowCol);
        tableConvertParam.setCellFontFit(cellFontFit);
        WordTableNode tableNode = new ExcelConvert(reportSectionResult.getExcelData(), tableConvertParam).createReportSection();
        this.resetTableNoode(tableNode, moduleProperties);
        this.resetTableCellMargin(tableNode, moduleProperties);
        if (tableNode == null || tableNode.getChilds().size() == 0) {
            msg = String.format(ResManager.loadKDString((String)"%s:\u62a5\u8868\u5207\u7247\u533a\u57df\u65e0\u6570\u636e\uff0c\u8bf7\u8865\u5145\u540e\u91cd\u8bd5\u3002", (String)"ModuleDataGeneralHelper_18", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            return CalculateHelper.dataResultFail(msg);
        }
        JSONObject result = new JSONObject();
        result.put("list", new ArrayList(2));
        result.put("tableNode", (Object)JSON.toJSONString((Object)tableNode));
        result.put("formular", (Object)this.createFormularLogInfo(dimLogList));
        return CalculateHelper.dataResultSuccess(result);
    }

    private FormularLogInfo createFormularLogInfo(List<DimensionInfo> dimLogList) {
        FormularLogInfo logInfo = new FormularLogInfo();
        logInfo.setText("");
        logInfo.setDimList(dimLogList);
        return logInfo;
    }

    private void resetTableNoode(WordTableNode tableNode, JSONObject moduleProperties) {
        String bookKey = DisclosureJsonHelper.getValue(moduleProperties, "bookmark", "key", "");
        tableNode.setId(bookKey);
        String alignment = DisclosureJsonHelper.getValue(moduleProperties, "alignment", "2");
        tableNode.setAlignment(TypeUtils.convertValueToInt(alignment, 2));
        double leftInd = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "left", 0.0);
        tableNode.setLeftInd(leftInd * 567.0);
    }

    private void resetTableCellMargin(WordTableNode tableNode, JSONObject moduleProperties) {
        WordTableCellMargins wordTableCellMargins = new WordTableCellMargins();
        double left = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cell", "left", 0.2);
        WordTableCellMargin leftMargin = new WordTableCellMargin();
        leftMargin.setWidth(567.0 * left);
        wordTableCellMargins.setLeft(leftMargin);
        double right = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cell", "right", 0.2);
        WordTableCellMargin rightMargin = new WordTableCellMargin();
        rightMargin.setWidth(567.0 * right);
        wordTableCellMargins.setRight(rightMargin);
        double top = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cell", "top", 0.2);
        WordTableCellMargin topMargin = new WordTableCellMargin();
        topMargin.setWidth(567.0 * top);
        wordTableCellMargins.setTop(topMargin);
        double bottom = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "cell", "bottom", 0.2);
        WordTableCellMargin bottomMargin = new WordTableCellMargin();
        bottomMargin.setWidth(567.0 * bottom);
        wordTableCellMargins.setBottom(bottomMargin);
        tableNode.setMargins(wordTableCellMargins);
    }

    private Map<String, String> getDimMemberMap(Long dmModelId, List<DimensionInfo> dimDefaultMemberMap, JSONObject reportSection, List<DimensionInfo> dimLogList) {
        HashMap<String, String> dimMemberMap = new HashMap<String, String>(20);
        HashMap<String, DimensionInfo> dimLogMap = new HashMap<String, DimensionInfo>(20);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDimList = modelStrategyEx.getDim().getDimList();
        ModelInfo model = modelStrategyEx.getModel().getModelInfo();
        String modeltype = model.getModelType();
        DisModelTypeEnum enumByType = DisModelTypeEnum.getEnumByType(modeltype);
        for (DimensionInfo dimensionInfo : allDimList) {
            DimMemberInfo bcmMember;
            DimDefaultValueVo defaultValueVo = DimDefaultValueHelper.getDefaultValue(dimensionInfo.getShortNumber(), dmModelId, enumByType);
            if (defaultValueVo == null || !StringUtils.isNotEmpty((String)defaultValueVo.getDefaultValue()) || (bcmMember = modelStrategyEx.getDimMember().findMemberByNumber(dimensionInfo.getNumber(), defaultValueVo.getDefaultValue(), false)) == null) continue;
            dimMemberMap.put(dimensionInfo.getNumber() + "Id", LongUtil.isvalidLong((Object)defaultValueVo.getMemberId()) ? defaultValueVo.getMemberId().toString() : "0");
            dimMemberMap.put(dimensionInfo.getNumber() + "Number", defaultValueVo.getDefaultValue());
            dimensionInfo.setMembers(Collections.singletonList(bcmMember));
            dimLogMap.put(dimensionInfo.getNumber(), dimensionInfo);
        }
        for (DimensionInfo dimensionInfo : dimDefaultMemberMap) {
            if (dimensionInfo.getMembers() == null || dimensionInfo.getMembers().size() == 0) continue;
            dimMemberMap.put(dimensionInfo.getNumber() + "Id", dimensionInfo.getMembers().get(0).getId().toString());
            dimMemberMap.put(dimensionInfo.getNumber() + "Number", dimensionInfo.getMembers().get(0).getNumber());
            dimensionInfo.setMembers(Collections.singletonList(dimensionInfo.getMembers().get(0)));
            dimLogMap.put(dimensionInfo.getNumber(), dimensionInfo);
        }
        for (Object e : reportSection.getJSONArray("reportDims")) {
            String dimNumber;
            JSONObject dim = (JSONObject)e;
            if (dim == null || !StringUtils.isNotEmpty((String)(dimNumber = dim.getString("dim_number"))) || !StringUtils.isNotEmpty((String)dim.getString("member_id"))) continue;
            dimMemberMap.put(dimNumber + "Id", dim.getString("member_id"));
            dimMemberMap.put(dimNumber + "Number", dim.getString("member_number"));
            DimensionInfo item = DimensionUtils.getDimByNumber(allDimList, dimNumber);
            if (item == null || !LongUtil.isvalidLong((Object)dim.getLong("member_id"))) continue;
            DimMemberInfo memberInfo = new DimMemberInfo();
            memberInfo.setId(dim.getLong("member_id"));
            memberInfo.setName(dim.getString("member_name"));
            memberInfo.setNumber(dim.getString("member_number"));
            item.setMembers(Collections.singletonList(memberInfo));
            dimLogMap.put(item.getNumber(), item);
        }
        for (Map.Entry entry : dimLogMap.entrySet()) {
            dimLogList.add((DimensionInfo)entry.getValue());
        }
        return dimMemberMap;
    }

    private int convertToViewDataunit(JSONObject moduleProperties) {
        String dataPatternType = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "styleData", "unit", "0");
        int viewDataUnit = 1;
        if (DataPatternEnum.THOUSAND_YUAN.getType().equalsIgnoreCase(dataPatternType)) {
            viewDataUnit = 3;
        } else if (DataPatternEnum.TEN_THOUSAND_YUAN.getType().equalsIgnoreCase(dataPatternType)) {
            viewDataUnit = 4;
        } else if (DataPatternEnum.MILLION_YUAN.getType().equalsIgnoreCase(dataPatternType)) {
            viewDataUnit = 6;
        } else if (DataPatternEnum.BILLION_YUAN.getType().equalsIgnoreCase(dataPatternType)) {
            viewDataUnit = 8;
        } else if (DataPatternEnum.YUAN.getType().equalsIgnoreCase(dataPatternType)) {
            viewDataUnit = 0;
        }
        return viewDataUnit;
    }

    private int convertToScale(JSONObject moduleProperties) {
        int scale = -1;
        boolean decimalEnable = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "styleData", "decimalEnable", false);
        if (decimalEnable) {
            scale = DisclosureJsonHelper.getValue(moduleProperties, "reportSection", "styleData", "decimal", 2);
        }
        if (scale < 0) {
            scale = -1;
        }
        return scale;
    }
}

