/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DisclosureSortEnum;
import kd.epm.far.business.fidm.base.DisclosureConstants;
import kd.epm.far.business.fidm.util.TypeUtils;
import org.apache.commons.collections.CollectionUtils;

public class SortHelper {
    public static void sortByValue(Map<String, Object> data, String typeStr, Map<String, Object> sortSetting) {
        if (sortSetting == null) {
            return;
        }
        String sortType = sortSetting.get("type") == null ? "" : sortSetting.get("type").toString();
        final DisclosureSortEnum sortEnum = DisclosureSortEnum.getEnumByName(sortType);
        if (sortEnum == null) {
            return;
        }
        List adllSeriesList = (List)data.get(DisclosureConstants.ECHARTS_SERIES_NAME);
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)adllSeriesList)) {
            return;
        }
        ArrayList seriesList = adllSeriesList.stream().filter(m -> typeStr.equals(m.get("type"))).collect(Collectors.toList());
        if (kd.bos.util.CollectionUtils.isEmpty(seriesList)) {
            return;
        }
        adllSeriesList.removeAll(seriesList);
        switch (sortEnum) {
            case NAME_ASC: 
            case NAME_DESC: {
                seriesList.sort(new Comparator<Map<String, Object>>(){

                    @Override
                    public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                        String name1 = TypeUtils.toPinYinString((String)o1.get(DisclosureConstants.ECHARTS_NAME_NAME));
                        String name2 = TypeUtils.toPinYinString((String)o2.get(DisclosureConstants.ECHARTS_NAME_NAME));
                        return name1.compareTo(name2) * sortEnum.getOrderBy();
                    }
                });
                break;
            }
            case MONEY_ASC: 
            case MONEY_DESC: {
                seriesList.sort(new Comparator<Map<String, Object>>(){

                    @Override
                    public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                        List data1 = (List)o1.get(DisclosureConstants.ECHARTS_DATA_NAME);
                        List data2 = (List)o2.get(DisclosureConstants.ECHARTS_DATA_NAME);
                        BigDecimal totalMoney1 = BigDecimal.ZERO;
                        BigDecimal totalMoney2 = BigDecimal.ZERO;
                        for (Object data : data1) {
                            totalMoney1 = totalMoney1.add(new BigDecimal(data.toString()));
                        }
                        for (Object data : data2) {
                            totalMoney2 = totalMoney2.add(new BigDecimal(data.toString()));
                        }
                        return totalMoney1.compareTo(totalMoney2) * sortEnum.getOrderBy();
                    }
                });
                break;
            }
            case CUSTOM: {
                String custom;
                String string = custom = sortSetting.get("customValue") == null ? "" : sortSetting.get("customValue").toString().trim();
                if (StringUtils.isEmpty((String)custom)) break;
                List<String> customList = Arrays.stream(custom.split(";")).distinct().collect(Collectors.toList());
                Map<String, Map> nameMap = seriesList.stream().collect(Collectors.toMap(t -> (String)t.get(DisclosureConstants.ECHARTS_NAME_NAME), k -> k, (v1, v2) -> v2));
                customList.retainAll(nameMap.keySet());
                if (CollectionUtils.isEmpty(customList)) break;
                ArrayList newSeriesList = Lists.newArrayList();
                customList.forEach(t -> newSeriesList.add(nameMap.get(t)));
                for (Map seriesMap : seriesList) {
                    String name = (String)seriesMap.get(DisclosureConstants.ECHARTS_NAME_NAME);
                    if (customList.contains(name)) continue;
                    newSeriesList.add(nameMap.get(name));
                }
                seriesList = newSeriesList;
                break;
            }
        }
        adllSeriesList.addAll(seriesList);
        data.put(DisclosureConstants.ECHARTS_SERIES_NAME, adllSeriesList);
    }

    protected static void sortByKey(Map<String, Object> data, Map<String, Object> sortSetting) {
        if (sortSetting == null) {
            return;
        }
        String sortType = sortSetting.get("type") == null ? "" : sortSetting.get("type").toString();
        DisclosureSortEnum sortEnum = DisclosureSortEnum.getEnumByName(sortType);
        if (sortEnum == null) {
            return;
        }
        String sortKey = DisclosureConstants.ECHARTS_XAXIS_NAME;
        List axis = (List)data.get(sortKey);
        List seriesList = (List)data.get(DisclosureConstants.ECHARTS_SERIES_NAME);
        if (CollectionUtils.isEmpty((Collection)seriesList)) {
            return;
        }
        HashMap sortMap = Maps.newHashMapWithExpectedSize((int)axis.size());
        switch (sortEnum) {
            case NAME_ASC: 
            case NAME_DESC: {
                ArrayList axisCopy = Lists.newArrayList((Iterable)axis);
                SortHelper.buildSortMapByString(sortEnum, axis, sortMap, axisCopy);
                data.put(sortKey, axisCopy);
                SortHelper.sortValue(seriesList, sortMap);
                break;
            }
            case MONEY_ASC: 
            case MONEY_DESC: {
                ArrayList totalMoney = Lists.newArrayListWithCapacity((int)axis.size());
                for (Map series : seriesList) {
                    List fMoney = (List)series.get(DisclosureConstants.ECHARTS_DATA_NAME);
                    for (int i = 0; i < fMoney.size(); ++i) {
                        if (totalMoney.size() > i) {
                            BigDecimal money = ((BigDecimal)totalMoney.get(i)).add(new BigDecimal(fMoney.get(i).toString()));
                            totalMoney.set(i, money);
                            continue;
                        }
                        totalMoney.add(new BigDecimal(fMoney.get(i).toString()));
                    }
                }
                ArrayList totalMoneyCopy = Lists.newArrayList((Iterable)totalMoney);
                SortHelper.buildSortMapByBigDecimal(sortEnum, totalMoney, sortMap, totalMoneyCopy);
                ArrayList axisCopy = Lists.newArrayListWithCapacity((int)axis.size());
                for (int i = 0; i < axis.size(); ++i) {
                    axisCopy.add(axis.get((Integer)sortMap.get(i)));
                }
                data.put(sortKey, axisCopy);
                SortHelper.sortValue(seriesList, sortMap);
                break;
            }
            case CUSTOM: {
                int i;
                String custom;
                String string = custom = sortSetting.get("customValue") == null ? "" : sortSetting.get("customValue").toString().trim();
                if (StringUtils.isEmpty((String)custom)) break;
                List customList = Arrays.stream(custom.split(";")).distinct().collect(Collectors.toList());
                customList.retainAll(axis);
                if (CollectionUtils.isEmpty(customList)) break;
                for (i = 0; i < customList.size(); ++i) {
                    int index = axis.indexOf(customList.get(i));
                    sortMap.put(i, index);
                }
                ArrayList axisCopy = Lists.newArrayList(customList);
                for (i = 0; i < axis.size(); ++i) {
                    String value = (String)axis.get(i);
                    if (customList.contains(value)) continue;
                    axisCopy.add(value);
                    sortMap.put(axisCopy.size() - 1, i);
                }
                data.put(sortKey, axisCopy);
                SortHelper.sortValue(seriesList, sortMap);
                break;
            }
        }
    }

    private static void sortValue(List<Map<String, Object>> seriesList, Map<Integer, Integer> sortMap) {
        for (Map<String, Object> series : seriesList) {
            List fMoney = (List)series.get(DisclosureConstants.ECHARTS_DATA_NAME);
            ArrayList newFMoney = Lists.newArrayListWithCapacity((int)fMoney.size());
            for (int i = 0; i < fMoney.size(); ++i) {
                newFMoney.add(new BigDecimal(fMoney.get(sortMap.get(i)).toString()));
            }
            series.put(DisclosureConstants.ECHARTS_DATA_NAME, newFMoney);
        }
    }

    private static void buildSortMapByBigDecimal(final DisclosureSortEnum sortEnum, List<BigDecimal> oldMoney, Map<Integer, Integer> sortMap, List<BigDecimal> newMoney) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)oldMoney.size());
        newMoney.sort(new Comparator<BigDecimal>(){

            @Override
            public int compare(BigDecimal o1, BigDecimal o2) {
                return o1.compareTo(o2) * sortEnum.getOrderBy();
            }
        });
        for (int i = 0; i < oldMoney.size(); ++i) {
            BigDecimal old = oldMoney.get(i);
            Integer integer = map.getOrDefault(old, 1);
            sortMap.put(SortHelper.findByOrderNumber(newMoney, old, integer), i);
            map.put(old, integer + 1);
        }
    }

    private static <T> Integer findByOrderNumber(List<T> newList, T value, int orderNumber) {
        int order = 1;
        for (int i = 0; i < newList.size(); ++i) {
            if (!newList.get(i).equals(value)) continue;
            if (order == orderNumber) {
                return i;
            }
            ++order;
        }
        return order;
    }

    private static void buildSortMapByString(final DisclosureSortEnum sortEnum, List<String> oldStr, Map<Integer, Integer> sortMap, List<String> newStr) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)oldStr.size());
        newStr.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return TypeUtils.toPinYinString(o1).compareTo(TypeUtils.toPinYinString(o2)) * sortEnum.getOrderBy();
            }
        });
        for (int i = 0; i < oldStr.size(); ++i) {
            String old = oldStr.get(i);
            Integer integer = map.getOrDefault(old, 1);
            sortMap.put(SortHelper.findByOrderNumber(newStr, old, integer), i);
            map.put(old, integer + 1);
        }
    }
}

