/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.module.calculate.ModuleDataGeneralHelper;
import kd.epm.far.business.fidm.module.calculate.dto.TableCalCellData;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;

public class TableCalculate {
    public static JSONObject createTable(Long dmModelId, Long chapterId, List<DimensionInfo> dimDefaultMembers, JSONObject moduleProperties) {
        String msg = "";
        String moduleName = moduleProperties.getString("name");
        long moduleId = DisclosureJsonHelper.getValue(moduleProperties, "dataset", "id", 0L);
        Set<String> moneyKeySet = DatasetFilterHelper.getMoneyKeySet(dmModelId, moduleId);
        JSONArray tableProperty = DisclosureJsonHelper.getJSONArray(moduleProperties, "table", "property");
        String[] fields = new String[tableProperty.size() - 1];
        int index = 0;
        ArrayList<String> moneyList = new ArrayList<String>(2);
        for (Object columnObject : tableProperty) {
            JSONObject column = (JSONObject)columnObject;
            String columnName = column.getString("column");
            if (moneyList.contains(columnName)) continue;
            if (moneyKeySet.contains(columnName)) {
                moneyList.add(columnName);
                continue;
            }
            fields[index] = columnName;
            ++index;
        }
        JSONObject specialMap = moduleProperties.getJSONObject("specialMap");
        if (specialMap == null) {
            msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u7ec4\u4ef6\u6570\u636e\u683c\u5f0f\u7b49\u8bbe\u7f6e\u4e0d\u5b58\u5728\u3002", (String)"ModuleDataGeneralHelper_7", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            throw new KDBizException(msg);
        }
        specialMap.put("y", (Object)moneyList.toArray(new String[0]));
        specialMap.put("fields", (Object)fields);
        Map<String, Object> dataMap = ModuleDataGeneralHelper.getDataSetInfo(dmModelId, chapterId, moduleProperties, dimDefaultMembers);
        String errorInfo = CalculateHelper.getDataError(moduleName, dataMap);
        if (!StringUtils.isEmpty((String)errorInfo)) {
            return ModuleDataGeneralHelper.dataResultFail(errorInfo);
        }
        Tuple<WordTableNode, Integer> tableNodeTuple = TableCalculate.createTableNode(moduleProperties, dataMap);
        if (tableNodeTuple != null) {
            dataMap.put("tableNode", JSON.toJSONString((Object)tableNodeTuple.item1));
            dataMap.put("displayTextNode", JSON.toJSONString((Object)TableCalculate.convertToString(moduleProperties, tableNodeTuple)));
        }
        return ModuleDataGeneralHelper.dataResultSuccess(dataMap);
    }

    private static Tuple<WordTableNode, Integer> createTableNode(JSONObject moduleProperties, Map<String, Object> dataMap) {
        int headRows = 0;
        String tips = "";
        ArrayList array = (ArrayList)dataMap.get("list");
        if (array == null) {
            tips = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WebHtmlService_4", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        double tableAllWidth = (double)DisclosureJsonHelper.getValue(moduleProperties, "width", 15) * 558.0;
        WordConstants.WordWidthType tableWithType = WordConstants.WordWidthType.Absolute;
        if (tableAllWidth <= 0.0) {
            tableWithType = WordConstants.WordWidthType.Percentage;
        }
        String title = TableCalculate.getTitle(moduleProperties);
        JSONObject textStyle = DisclosureJsonHelper.getJsonObject(moduleProperties, "table", "textStyle");
        String textAlign = "center";
        String numberAlign = "center";
        JSONObject font = null;
        if (textStyle != null) {
            numberAlign = DisclosureJsonHelper.getValue(textStyle, "align", "number", "");
            textAlign = DisclosureJsonHelper.getValue(textStyle, "align", "text", "");
            font = DisclosureJsonHelper.getJsonObject(textStyle, "font");
        }
        List<TableCalCellData[]> tableList = TableCalculate.getCellData(moduleProperties, array);
        List<Double> colWidths = TableCalculate.getColWidths(moduleProperties);
        if (tableList == null || tableList.size() == 0 || colWidths == null || colWidths.size() == 0) {
            tips = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WebHtmlService_4", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        if (tableList.size() > 0) {
            ++headRows;
        }
        String alignment = DisclosureJsonHelper.getValue(moduleProperties, "alignment", "1");
        WordTableNode tableNode = new WordTableNode();
        tableNode.setAlignment(TypeUtils.convertValueToInt(alignment, 1));
        if (tableWithType == WordConstants.WordWidthType.Percentage) {
            tableNode.setWidth(1.0);
            tableNode.setWidthType(WordConstants.WordWidthType.Percentage.getType());
        } else {
            tableNode.setWidth(1.0 * tableAllWidth);
            tableNode.setWidthType(WordConstants.WordWidthType.Absolute.getType());
        }
        tableNode.setId(DisclosureJsonHelper.getValue(moduleProperties, "bookmark", "key", ""));
        if (StringUtils.isNotEmpty((String)title) && colWidths.size() > 0) {
            WordTableRowNode rowNode = new WordTableRowNode();
            tableNode.getChilds().add(rowNode);
            WordTableCellNode cellNode = new WordTableCellNode();
            if (tableWithType == WordConstants.WordWidthType.Percentage) {
                cellNode.setWidth(1.0);
                cellNode.setWidthType(WordConstants.WordWidthType.Percentage.getType());
            } else {
                cellNode.setWidth(1.0 * tableAllWidth);
                cellNode.setWidthType(WordConstants.WordWidthType.Absolute.getType());
            }
            if (colWidths.size() > 1) {
                cellNode.setColumnSpan(colWidths.size());
            }
            rowNode.getChilds().add(cellNode);
            ++headRows;
            WordParagraphNode paragraphNode = new WordParagraphNode();
            paragraphNode.setAlignment(ParagraphAlignment.CENTER);
            cellNode.getChilds().add(paragraphNode);
            WordTextNode textNode = new WordTextNode();
            textNode.setContent(title);
            TableCalculate.setTextNode(paragraphNode, textNode, font, textAlign);
            paragraphNode.getChilds().add(textNode);
        }
        for (TableCalCellData[] cells : tableList) {
            if (cells == null) continue;
            WordTableRowNode rowNode = new WordTableRowNode();
            for (int j = 0; j < cells.length; ++j) {
                WordTableCellNode cellNode = new WordTableCellNode();
                if (tableWithType == WordConstants.WordWidthType.Percentage) {
                    cellNode.setWidth(colWidths.get(j));
                    cellNode.setWidthType(WordConstants.WordWidthType.Percentage.getType());
                } else {
                    cellNode.setWidth(colWidths.get(j) * tableAllWidth);
                    cellNode.setWidthType(WordConstants.WordWidthType.Absolute.getType());
                }
                rowNode.getChilds().add(cellNode);
                WordParagraphNode paragraphNode = new WordParagraphNode();
                cellNode.getChilds().add(paragraphNode);
                WordTextNode textNode = new WordTextNode();
                TableCalCellData tableCalCellData = cells[j];
                if (tableCalCellData.getType() == 1) {
                    textNode.setContent(tableCalCellData.getContent());
                    paragraphNode.setAlignment(ParagraphAlignment.RIGHT);
                    TableCalculate.setTextNode(paragraphNode, textNode, font, numberAlign);
                } else {
                    textNode.setContent(tableCalCellData.getContent());
                    TableCalculate.setTextNode(paragraphNode, textNode, font, textAlign);
                }
                paragraphNode.getChilds().add(textNode);
            }
            tableNode.getChilds().add(rowNode);
        }
        return new Tuple((Object)tableNode, (Object)headRows);
    }

    private static void setTextNode(WordParagraphNode paragraphNode, WordTextNode textNode, JSONObject font, String align) {
        if (textNode == null || font == null || StringUtils.isEmpty((String)align)) {
            return;
        }
        double fontSize = DisclosureJsonHelper.getValue(font, "size", 12.0);
        boolean bold = !"normal".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "weight", " normal"));
        boolean underline = !"normal".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "underline", "normal"));
        boolean italic = !"normal".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "style", "normal"));
        String color = DisclosureJsonHelper.getValue(font, "color", "");
        textNode.setBold(bold);
        textNode.setUnderline(underline);
        textNode.setItalic(italic);
        if (fontSize > 0.0) {
            textNode.setFontSize(fontSize);
        }
        if (StringUtils.isNotEmpty((String)color)) {
            textNode.setFontColor(color);
        }
        if (paragraphNode != null) {
            if ("left".equalsIgnoreCase(align)) {
                paragraphNode.setAlignment(ParagraphAlignment.LEFT);
            } else if ("right".equalsIgnoreCase(align)) {
                paragraphNode.setAlignment(ParagraphAlignment.RIGHT);
            } else {
                paragraphNode.setAlignment(ParagraphAlignment.CENTER);
            }
        }
    }

    private static String getTitle(JSONObject moduleProperties) {
        boolean titleVisible = DisclosureJsonHelper.getValue(moduleProperties, "title", "visible", true);
        String titleName = DisclosureJsonHelper.getValue(moduleProperties, "title", "name", "");
        return titleVisible ? titleName : "";
    }

    private static String numberFormat(JSONObject moduleProperties, BigDecimal number) {
        if (number == null) {
            return "";
        }
        JSONObject dataPattern = DisclosureJsonHelper.getJsonObject(moduleProperties, "dataFormat", "table");
        if (dataPattern == null) {
            return number.toString();
        }
        BigDecimal newNumber = CalculateHelper.convertValueToDecimal(number.toString(), dataPattern);
        DecimalFormat df = new DecimalFormat(CalculateHelper.getNumberFormatCode(dataPattern));
        return df.format(newNumber);
    }

    private static List<Double> getColWidths(JSONObject moduleProperties) {
        ArrayList<Double> colWidths = new ArrayList<Double>(2);
        JSONArray tableProp = DisclosureJsonHelper.getJSONArray(moduleProperties, "table", "property");
        if (tableProp == null || tableProp.size() == 0) {
            return colWidths;
        }
        boolean is_column_width = DisclosureJsonHelper.getValue(moduleProperties, "table", "columnVisible", "column_width", true);
        boolean is_show = DisclosureJsonHelper.getValue(moduleProperties, "table", "columnVisible", "show", false);
        for (Object columnObject : tableProp) {
            JSONObject column = (JSONObject)columnObject;
            Double width = TypeUtils.convertValueToDoule(column.get((Object)"column_width")) / 100.0;
            boolean columnShow = TypeUtils.getMapValueBool((Map)column, "show", true);
            if (!is_show) {
                columnShow = true;
            }
            if (!columnShow) continue;
            if (is_column_width) {
                if (width == null || width <= 0.0) {
                    colWidths.add(null);
                    continue;
                }
                colWidths.add(width);
                continue;
            }
            colWidths.add(null);
        }
        if (colWidths.size() == 0) {
            return colWidths;
        }
        long nullCount = 0L;
        double sumVal = 0.0;
        for (Double v : colWidths) {
            if (v == null) {
                ++nullCount;
                continue;
            }
            sumVal += v.doubleValue();
        }
        if (nullCount > 0L) {
            ArrayList<Double> widths = new ArrayList<Double>(colWidths.size());
            Double w = (1.0 - sumVal) / (double)nullCount;
            if (w < 0.0) {
                w = 0.0;
            }
            for (Double v : colWidths) {
                if (v == null) {
                    widths.add(w);
                    continue;
                }
                widths.add(v);
            }
            colWidths = widths;
        } else if (colWidths.size() > 0) {
            double all = 0.0;
            for (Double v : colWidths) {
                if (v == null) continue;
                all += v.doubleValue();
            }
            if (all > 0.0) {
                ArrayList<Double> widths = new ArrayList<Double>(colWidths.size());
                for (Double v : colWidths) {
                    if (v == null) {
                        widths.add(0.0);
                        continue;
                    }
                    widths.add(v + (1.0 - sumVal) * (v / all));
                }
                colWidths = widths;
            }
        }
        return colWidths;
    }

    private static List<TableCalCellData[]> getCellData(JSONObject moduleProperties, ArrayList array) {
        String tips = "";
        LinkedList<TableCalCellData[]> cellData = new LinkedList<TableCalCellData[]>();
        JSONArray tableProp = DisclosureJsonHelper.getJSONArray(moduleProperties, "table", "property");
        if (tableProp == null || tableProp.size() == 0) {
            tips = ResManager.loadKDString((String)"\u8868\u683c\u7684\u5217\u6570\u636e\u672a\u8bbe\u7f6e\u3002", (String)"WebHtmlService_5", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        boolean is_column_name = DisclosureJsonHelper.getValue(moduleProperties, "table", "columnVisible", "column_name", true);
        boolean is_prefix = DisclosureJsonHelper.getValue(moduleProperties, "table", "columnVisible", "prefix", false);
        boolean is_suffix = DisclosureJsonHelper.getValue(moduleProperties, "table", "columnVisible", "suffix", false);
        boolean is_show = DisclosureJsonHelper.getValue(moduleProperties, "table", "columnVisible", "show", false);
        ArrayList<TableCalCellData> renameTitles = new ArrayList<TableCalCellData>(tableProp.size());
        for (Object columnObject : tableProp) {
            Map column = (Map)columnObject;
            String column_name = TypeUtils.getMapValueString(column, "column_name");
            String column_default_name = TypeUtils.getMapValueString(column, "column_default_name");
            String columnStr = TypeUtils.getMapValueString(column, "column");
            boolean columnShow = TypeUtils.getMapValueBool(column, "show", true);
            if (!is_show) {
                columnShow = true;
            }
            if (!columnShow) continue;
            if (StringUtils.isNotEmpty((String)column_name) && is_column_name) {
                renameTitles.add(new TableCalCellData(column_name));
                continue;
            }
            if (StringUtils.isNotEmpty((String)column_default_name)) {
                renameTitles.add(new TableCalCellData(column_default_name));
                continue;
            }
            renameTitles.add(new TableCalCellData(columnStr));
        }
        cellData.add(renameTitles.toArray(new TableCalCellData[renameTitles.size()]));
        for (Object rowItem : array) {
            Map row = (Map)rowItem;
            if (row == null) continue;
            ArrayList<TableCalCellData> cellVals = new ArrayList<TableCalCellData>(tableProp.size());
            for (Object columnObject : tableProp) {
                String suffix;
                Map column = (Map)columnObject;
                String columnName = TypeUtils.getMapValueString(column, "column");
                boolean columnShow = TypeUtils.getMapValueBool(column, "show", true);
                String prefix = is_prefix ? TypeUtils.getMapValueString(column, "prefix") : "";
                String string = suffix = is_suffix ? TypeUtils.getMapValueString(column, "suffix") : "";
                if (!is_show) {
                    columnShow = true;
                }
                if (!columnShow) continue;
                if (row.containsKey(columnName)) {
                    Object val = row.get(columnName);
                    if (val instanceof BigDecimal) {
                        BigDecimal varDecimal = (BigDecimal)val;
                        String cellValue = TableCalculate.numberFormat(moduleProperties, varDecimal);
                        cellVals.add(new TableCalCellData(varDecimal, cellValue, prefix, suffix));
                        continue;
                    }
                    cellVals.add(new TableCalCellData(row.get(columnName) == null ? "" : row.get(columnName).toString(), prefix, suffix));
                    continue;
                }
                cellVals.add(new TableCalCellData(""));
            }
            cellData.add(cellVals.toArray(new TableCalCellData[cellVals.size()]));
        }
        return cellData;
    }

    private static WordTextNode convertToString(JSONObject moduleProperties, Tuple<WordTableNode, Integer> tableNodeTuple) {
        String separator = DisclosureJsonHelper.getValue(moduleProperties, "table", "separator", "");
        int displayType = DisclosureJsonHelper.getValue(moduleProperties, "table", "displayType", 0);
        if (separator == null) {
            separator = "";
        }
        WordTableNode tableNode = (WordTableNode)tableNodeTuple.item1;
        int headRows = (Integer)tableNodeTuple.item2;
        String content = "";
        ArrayList<String> allStrList = new ArrayList<String>(1000);
        if (displayType == 1) {
            for (int i = headRows; i < tableNode.getChilds().size(); ++i) {
                WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(i);
                ArrayList<String> rowStrs = new ArrayList<String>(rowNode.getChilds().size());
                if (rowNode == null) continue;
                for (WordNode cellNodeItem : rowNode.getChilds()) {
                    WordTableCellNode cellNode = (WordTableCellNode)cellNodeItem;
                    if (cellNode == null) continue;
                    for (WordNode paragrapItem : cellNode.getChilds()) {
                        WordParagraphNode paragraphNode = (WordParagraphNode)paragrapItem;
                        if (paragraphNode == null) continue;
                        for (WordNode textItem : paragraphNode.getChilds()) {
                            WordTextNode textNode = (WordTextNode)textItem;
                            if (textNode == null || !StringUtils.isNotEmpty((String)textNode.getContent())) continue;
                            rowStrs.add(textNode.getContent());
                        }
                    }
                }
                if (rowStrs.size() <= 0) continue;
                allStrList.add(String.join((CharSequence)"", rowStrs.toArray(new String[0])));
            }
            if (allStrList.size() > 0) {
                content = String.join((CharSequence)separator, allStrList.toArray(new String[0]));
            }
        }
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        JSONObject textStyle = DisclosureJsonHelper.getJsonObject(moduleProperties, "table", "textStyle");
        JSONObject font = null;
        if (textStyle != null) {
            font = DisclosureJsonHelper.getJsonObject(textStyle, "font");
        }
        WordTextNode textNode = new WordTextNode();
        textNode.setContent(content);
        TableCalculate.setTextNode(null, textNode, font, "left");
        return textNode;
    }
}

