/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.AbstractCalculate;
import kd.epm.far.business.fidm.module.calculate.VarHelper;

public class VarCalculate
extends AbstractCalculate {
    public VarCalculate(Long dmModelId, Object sourceData, JSONObject moduleProperties, List<DatasetFilterItem> filterItems) {
        super(dmModelId, sourceData, moduleProperties, filterItems);
    }

    @Override
    protected Map<String, Object> getSingleValue() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        Object obj = this.sourceData;
        returnData.put("singleValue", obj);
        this.addPrefixAndSuffix(returnData, obj);
        return returnData;
    }

    @Override
    protected Map<String, Object> getMultiValue() {
        HashMap mapData;
        Object obj;
        String datasetMultiNumber;
        DynamicObject multiValueEntry;
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        if (Objects.nonNull(this.datasetMultiId) && this.datasetMultiId > 0L && Objects.nonNull(multiValueEntry = DatasetDataReader.getMultiDataSetValue(this.datasetMultiId, false)) && !StringUtils.isEmpty((String)(datasetMultiNumber = multiValueEntry.getString("number"))) && Objects.nonNull(obj = (mapData = (HashMap)this.sourceData).get(datasetMultiNumber))) {
            returnData.put("singleValue", obj);
            this.addPrefixAndSuffix(returnData, obj);
            return returnData;
        }
        String errorMsg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u5f02\u5e38\uff0c\u9009\u62e9\u7684\u591a\u503c\u6570\u636e\u96c6\u7684\u516c\u5f0f\u4e0d\u5b58\u5728\u6216\u672a\u9009\u62e9\u3002", (String)"FidmCalculate_3", (String)"epm-far-business", (Object[])new Object[0]);
        returnData.put("errorMsg", errorMsg);
        return returnData;
    }

    private void addPrefixAndSuffix(Map<String, Object> returnData, Object singleValue) {
        String suffix;
        String prefix = DisclosureJsonHelper.getValue(this.moduleProperties, "dataPoint", "prefix", "");
        if (!StringUtils.isEmpty((String)prefix)) {
            String prefixResult = VarHelper.calculate(prefix, singleValue == null ? new BigDecimal(0) : singleValue, false);
            returnData.put("singleValue_prefix", prefixResult);
        }
        if (!StringUtils.isEmpty((String)(suffix = DisclosureJsonHelper.getValue(this.moduleProperties, "dataPoint", "suffix", "")))) {
            String suffixResult = VarHelper.calculate(suffix, singleValue == null ? new BigDecimal(0) : singleValue, false);
            returnData.put("singleValue_suffix", suffixResult);
        }
    }
}

