/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.calculate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.module.calculate.dto.VarResult;
import kd.epm.far.business.fidm.util.TypeUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class VarHelper {
    private static final String CurrentVarName = "$RS";
    private static final String NotCurrentVarName = "$$RS";

    public static void checkExpression(JSONObject itemObject) {
        String suffix;
        if (itemObject == null) {
            return;
        }
        String moduleType = itemObject.getString("type");
        if (!ModuleEnum.VAR.getType().equalsIgnoreCase(moduleType)) {
            return;
        }
        String prefix = DisclosureJsonHelper.getValue(itemObject, "dataPoint", "prefix", "");
        if (!StringUtils.isEmpty((String)prefix)) {
            VarHelper.checkExpression(prefix);
        }
        if (!StringUtils.isEmpty((String)(suffix = DisclosureJsonHelper.getValue(itemObject, "dataPoint", "suffix", "")))) {
            VarHelper.checkExpression(suffix);
        }
    }

    public static void checkExpression(String expression) {
        VarHelper.calculate(expression, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String calculate(String expression, Object varValue, boolean showKDBizExceptio) {
        XSSFCell expressioncell;
        XSSFCell cell;
        if (StringUtils.isEmpty((String)expression)) {
            return "";
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("calulate");
        XSSFRow row = sheet.getRow(0);
        if (row == null) {
            row = sheet.createRow(0);
        }
        if ((cell = row.getCell(0)) == null) {
            cell = row.createCell(0, CellType.NUMERIC);
        }
        if (varValue == null) {
            cell.setCellValue(0.0);
        } else if (TypeUtils.isNumber(varValue)) {
            cell.setCellValue(TypeUtils.convertValueToDoule(varValue).doubleValue());
        } else {
            cell.setCellValue(varValue.toString());
        }
        XSSFRow expressionRow = sheet.getRow(1);
        if (expressionRow == null) {
            expressionRow = sheet.createRow(1);
        }
        if ((expressioncell = expressionRow.getCell(1)) == null) {
            expressioncell = row.createCell(1, CellType.FORMULA);
        }
        if (expression.toUpperCase().contains(NotCurrentVarName)) {
            if (!showKDBizExceptio) return expression;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f[%1$s]\u8bbe\u7f6e\u6709\u8bef,\u4e0d\u80fd\u5305\u542b$$RS\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VarHelper_2", (String)"epm-far-business", (Object[])new Object[0]), expression));
        }
        try {
            String realExpresstion = expression.replaceAll("(?i)" + Pattern.quote(CurrentVarName), "A1");
            expressioncell.setCellFormula(realExpresstion);
        }
        catch (Exception ex) {
            if (!showKDBizExceptio) return expression;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f[%1$s]\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VarHelper_0", (String)"epm-far-business", (Object[])new Object[0]), expression));
        }
        String result = "";
        CellValue cellVal = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluate((Cell)expressioncell);
        if (cellVal == null) {
            return "";
        }
        if (cellVal.getCellType() == CellType.NUMERIC) {
            return String.valueOf(cellVal.getNumberValue());
        }
        if (cellVal.getCellType() != CellType.ERROR) return cellVal.getStringValue();
        if (varValue != null) return cellVal.formatAsString();
        if (!Objects.equals(cellVal.getErrorValue(), (byte)7)) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f[%1$s]\u8bbe\u7f6e\u6709\u8bef:%2$s\u3002", (String)"VarHelper_1", (String)"epm-far-business", (Object[])new Object[0]), expression, cellVal.formatAsString()));
        return "";
    }

    public static VarResult getVar(JSONObject itemObject, Map varDataObject) {
        String result = "";
        String color = "";
        if (varDataObject != null) {
            Object singleValue = varDataObject.get("singleValue");
            String singleValueStr = singleValue == null ? "0" : singleValue.toString();
            String specialFormula = DisclosureJsonHelper.getValue(itemObject, "dataPoint", "specialFormula", "");
            if (StringUtils.isEmpty((String)specialFormula)) {
                if (TypeUtils.isNumber(singleValue)) {
                    JSONObject dataFormat = CalculateHelper.getDataFormart(itemObject, "dataFormat", "dataPoint");
                    singleValue = CalculateHelper.convertValueToDecimal(singleValueStr, dataFormat);
                    DecimalFormat df = new DecimalFormat(CalculateHelper.getNumberFormatCode(dataFormat));
                    singleValueStr = df.format(singleValue);
                }
            } else {
                singleValueStr = VarHelper.calculate(specialFormula, singleValue == null ? new BigDecimal(0) : singleValue, true);
            }
            color = VarHelper.getColor(itemObject, varDataObject);
            String prefixValue = varDataObject.get("singleValue_prefix") == null ? "" : varDataObject.get("singleValue_prefix").toString();
            String suffixValue = varDataObject.get("singleValue_suffix") == null ? "" : varDataObject.get("singleValue_suffix").toString();
            result = prefixValue + singleValueStr + suffixValue;
        }
        return new VarResult(result, color);
    }

    private static String getColor(JSONObject itemObject, Map varDataObject) {
        String fontColor = "";
        if (itemObject == null || varDataObject == null) {
            return fontColor;
        }
        JSONObject dataPoint = itemObject.getJSONObject("dataPoint");
        if (dataPoint == null) {
            return fontColor;
        }
        JSONArray conditions = dataPoint.getJSONArray("conditions");
        if (conditions == null || conditions.size() == 0) {
            return fontColor;
        }
        Object singleValue = varDataObject.get("singleValue");
        if (!TypeUtils.isNumber(singleValue)) {
            return fontColor;
        }
        BigDecimal nowVal = TypeUtils.convertToDecimal(singleValue);
        for (Object c : conditions) {
            JSONObject cObject = (JSONObject)c;
            if (cObject == null) continue;
            String color = cObject.getString("color");
            String value = cObject.getString("value");
            String value2 = cObject.getString("value2");
            String condition = cObject.getString("condition");
            if (StringUtils.isEmpty((String)"color") || StringUtils.isEmpty((String)"value") || StringUtils.isEmpty((String)"condition")) continue;
            BigDecimal conditionVal = TypeUtils.convertToDecimal(value);
            BigDecimal conditionVal2 = TypeUtils.convertToDecimal(value2);
            if ("==".equalsIgnoreCase(condition = condition.trim()) && conditionVal.equals(nowVal)) {
                fontColor = color;
            } else if ("!=".equalsIgnoreCase(condition) && !conditionVal.equals(nowVal)) {
                fontColor = color;
            } else if (">".equalsIgnoreCase(condition) && nowVal.compareTo(conditionVal) > 0) {
                fontColor = color;
            } else if (">=".equalsIgnoreCase(condition) && nowVal.compareTo(conditionVal) >= 0) {
                fontColor = color;
            } else if ("<".equalsIgnoreCase(condition) && nowVal.compareTo(conditionVal) < 0) {
                fontColor = color;
            } else if ("<=".equalsIgnoreCase(condition) && nowVal.compareTo(conditionVal) <= 0) {
                fontColor = color;
            } else if ("between".equalsIgnoreCase(condition) && nowVal.compareTo(conditionVal) >= 0 && nowVal.compareTo(conditionVal2) <= 0) {
                fontColor = color;
            }
            if (StringUtils.isEmpty((String)fontColor)) continue;
            return fontColor;
        }
        return fontColor;
    }
}

