/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.enums.AxisConfigParamsEnum;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.common.common.Pair;

public class CommonProperty {
    private final Map<String, String> dataPattern = new HashMap<String, String>(8);
    private final Map<String, String> axisDataPattern = new HashMap<String, String>(8);
    private String title;
    private int width;
    private int height;
    private String alignment = "2";
    private String dataLabel = "0";
    private long datasetId;
    private long datasetMultiId;
    private List<DatasetFilterItem> datasetFilterItems;
    private Map<String, Pair<Long, String>> dimInfos = new HashMap<String, Pair<Long, String>>(16);
    private Map<String, Object> varParams = new HashMap<String, Object>();
    private List<Map<String, String>> reportDims = new ArrayList<Map<String, String>>();
    private Long varDatasetId;
    private Long dimDatasetId;
    private int titileSize = 10;
    private int axisSize = 10;
    private int legendSize = 10;
    private boolean legendVisibale;
    private boolean legendOverlay;
    private String legendPosition;
    private String columntype = "1";
    private BigDecimal widthrate = new BigDecimal("1.0");
    private boolean cbxShownetline;
    private boolean leftAxisTitleVisible;
    private boolean bottomAxisTitleVisible;

    public CommonProperty() {
    }

    public CommonProperty(String title, int width, int height, long datasetId, List<DatasetFilterItem> datasetFilterItems) {
        this.title = title;
        this.width = width;
        this.height = height;
        this.datasetId = datasetId;
        this.datasetFilterItems = datasetFilterItems;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(long datasetId) {
        this.datasetId = datasetId;
    }

    public long getDatasetMultiId() {
        return this.datasetMultiId;
    }

    public void setDatasetMultiId(long datasetMultiId) {
        this.datasetMultiId = datasetMultiId;
    }

    public List<DatasetFilterItem> getDatesetFilterItems() {
        return this.datasetFilterItems;
    }

    public void setDatesetFilterItems(List<DatasetFilterItem> datasetFilterItems) {
        this.datasetFilterItems = datasetFilterItems;
    }

    public Map<String, Pair<Long, String>> getDimInfos() {
        return this.dimInfos;
    }

    public void setDimInfos(Map<String, Pair<Long, String>> dimInfos) {
        this.dimInfos = dimInfos;
    }

    public void addDimInfo(String dimNumber, Long memId, String memNum) {
        if (this.dimInfos == null) {
            this.dimInfos = new HashMap<String, Pair<Long, String>>(16);
        }
        this.dimInfos.put(dimNumber, (Pair<Long, String>)new Pair((Object)memId, (Object)memNum));
    }

    public Map<String, Object> getVarParams() {
        return this.varParams;
    }

    public void setVarParams(Map<String, Object> varParams) {
        this.varParams = varParams;
    }

    public void setDataPattern(String unit, int decimal, boolean thousandth, String currencysign) {
        this.setDataPattern(unit, decimal, thousandth, currencysign, "1");
    }

    public void setDataPattern(String unit, int decimal, boolean thousandth, String currencysign, String numbertype) {
        if (this.dataPattern.size() != 0) {
            this.dataPattern.clear();
        }
        this.dataPattern.put("unit", unit);
        this.dataPattern.put("decimal", String.valueOf(decimal));
        this.dataPattern.put("thousandth", String.valueOf(thousandth));
        this.dataPattern.put("currencysign", currencysign);
        this.dataPattern.put("numbertype", numbertype);
    }

    public String getUnit() {
        if (this.dataPattern.size() == 0) {
            return DataPatternEnum.YUAN.getType();
        }
        return this.dataPattern.get("unit");
    }

    public String getUnitName() {
        if (this.dataPattern.size() == 0) {
            return DataPatternEnum.YUAN.getName();
        }
        return DataPatternEnum.getDataPatternByType(this.dataPattern.get("unit")).getName();
    }

    public int getDecimal() {
        if (this.dataPattern.size() == 0) {
            return 2;
        }
        return Integer.parseInt(this.dataPattern.get("decimal"));
    }

    public boolean getThousandth() {
        if (this.dataPattern.size() == 0) {
            return false;
        }
        return Boolean.parseBoolean(this.dataPattern.get("thousandth"));
    }

    public String getCurrencysign() {
        if (this.dataPattern.size() == 0) {
            return "";
        }
        return Objects.nonNull(this.dataPattern.get("currencysign")) ? this.dataPattern.get("currencysign") : "";
    }

    public String getNumbertype() {
        if (this.dataPattern.size() == 0) {
            return "1";
        }
        return Objects.nonNull(this.dataPattern.get("numbertype")) ? this.dataPattern.get("numbertype") : "1";
    }

    public List<DatasetFilterItem> getDatasetFilterItems() {
        return this.datasetFilterItems;
    }

    public void setDatasetFilterItems(List<DatasetFilterItem> datasetFilterItems) {
        this.datasetFilterItems = datasetFilterItems;
    }

    public Map<String, String> getDataPattern() {
        return this.dataPattern;
    }

    public void setDataPattern(Map<String, String> map) {
        this.dataPattern.clear();
        this.dataPattern.putAll(map);
    }

    public Long getVarDatasetId() {
        return this.varDatasetId;
    }

    public void setVarDatasetId(Long varDatasetId) {
        this.varDatasetId = varDatasetId;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public String getDataLabel() {
        return this.dataLabel;
    }

    public void setDataLabel(String dataLabel) {
        this.dataLabel = dataLabel;
    }

    public List<Map<String, String>> getReportDims() {
        return this.reportDims;
    }

    public void setReportDims(List<Map<String, String>> reportDims) {
        this.reportDims = reportDims;
    }

    public String getColumntype() {
        return this.columntype;
    }

    public void setColumntype(String columntype) {
        this.columntype = columntype;
    }

    public BigDecimal getWidthrate() {
        return this.widthrate;
    }

    public void setWidthrate(BigDecimal widthrate) {
        this.widthrate = widthrate;
    }

    public int getTitileSize() {
        return this.titileSize;
    }

    public void setTitileSize(int titileSize) {
        this.titileSize = titileSize;
    }

    public int getAxisSize() {
        return this.axisSize;
    }

    public void setAxisSize(int axisSize) {
        this.axisSize = axisSize;
    }

    public int getLegendSize() {
        return this.legendSize;
    }

    public void setLegendSize(int legendSize) {
        this.legendSize = legendSize;
    }

    public Long getDimDatasetId() {
        return this.dimDatasetId;
    }

    public void setDimDatasetId(Long dimDatasetId) {
        this.dimDatasetId = dimDatasetId;
    }

    public boolean getLegendVisibale() {
        return this.legendVisibale;
    }

    public void setLegendVisibale(boolean visibale) {
        this.legendVisibale = visibale;
    }

    public boolean getLegendOverlay() {
        return this.legendOverlay;
    }

    public void setLegendOverlay(boolean legendOverlay) {
        this.legendOverlay = legendOverlay;
    }

    public String getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(String legendPosition) {
        this.legendPosition = legendPosition;
    }

    public boolean getCbxShownetline() {
        return this.cbxShownetline;
    }

    public void setCbxShownetline(boolean show) {
        this.cbxShownetline = show;
    }

    public boolean getLeftAxisTitleVisible() {
        return this.leftAxisTitleVisible;
    }

    public void setLeftAxisTitleVisible(boolean visible) {
        this.leftAxisTitleVisible = visible;
    }

    public boolean getBottomAxisTitleVisible() {
        return this.bottomAxisTitleVisible;
    }

    public void setBottomAxisTitleVisible(boolean visible) {
        this.bottomAxisTitleVisible = visible;
    }

    public void setAxisDataPattern(String unit, int decimal, boolean thousandth, String currencysign) {
        this.setAxisDataPattern(unit, decimal, thousandth, currencysign, "1");
    }

    public void setAxisDataPattern(String unit, int decimal, boolean thousandth, String currencysign, String numbertype) {
        if (this.axisDataPattern.size() != 0) {
            this.axisDataPattern.clear();
        }
        this.axisDataPattern.put("axis_unit", unit);
        this.axisDataPattern.put("axis_decimal", String.valueOf(decimal));
        this.axisDataPattern.put("axis_thousand_enabled", String.valueOf(thousandth));
        this.axisDataPattern.put("axis_currencysign", currencysign);
        this.axisDataPattern.put("axis_number_type", numbertype);
    }

    public Map<String, String> getAxisDataPattern() {
        HashMap<String, String> rst = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : this.axisDataPattern.entrySet()) {
            rst.put(entry.getKey(), entry.getValue());
        }
        return rst;
    }

    public <T> T getAxisFntParamsValue(AxisConfigParamsEnum ps) {
        boolean isNull = this.axisDataPattern.size() == 0;
        switch (ps) {
            case axisUnit: {
                if (isNull) {
                    return (T)DataPatternEnum.YUAN.getType();
                }
                return (T)this.axisDataPattern.get(ps.getCode());
            }
            case axisUnitName: {
                if (isNull) {
                    return (T)DataPatternEnum.YUAN.getName();
                }
                return (T)DataPatternEnum.getDataPatternByType(this.axisDataPattern.get(ps.getCode())).getName();
            }
            case axisDecimal: {
                Integer obj = isNull ? Integer.valueOf(2) : Integer.valueOf(Integer.parseInt(this.axisDataPattern.get(ps.getCode())));
                return (T)obj;
            }
            case axisThousandEnabled: {
                Boolean obj = isNull ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(this.axisDataPattern.get(ps.getCode())));
                return (T)obj;
            }
            case axisCurrencySign: {
                if (isNull) {
                    return (T)"";
                }
                return (T)(Objects.nonNull(this.axisDataPattern.get(ps.getCode())) ? this.axisDataPattern.get(ps.getCode()) : "");
            }
            case axisNumberType: {
                String obj = isNull ? "1" : (Objects.nonNull(this.dataPattern.get(ps.getCode())) ? this.dataPattern.get(ps.getCode()) : "1");
                return (T)obj;
            }
        }
        return null;
    }
}

