/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.BCMSectionShareModule;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureDefaultJsonHelper;
import kd.epm.far.business.fidm.module.ReportSectionHelper;
import kd.epm.far.business.fidm.module.middle.helper.BCMSectionMiddleConvertHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureJsonToMiddleHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;

public class BCMSectionModuleConvert
implements IMiddleModuleConvert<BCMSectionShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public BCMSectionShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        this.tips = new ArrayList<String>(100);
        BCMSectionShareModule middle = new BCMSectionShareModule();
        middle.info = DisclosureJsonToMiddleHelper.createInfoNode(module);
        middle.layout = this.createLayoutNode(module);
        middle.format = this.createFormatNode(module);
        return middle;
    }

    private BCMSectionShareModule.LayoutNode createLayoutNode(JSONObject module) {
        BCMSectionShareModule.LayoutNode layout = new BCMSectionShareModule.LayoutNode();
        layout.bcmTemplateId = ReportSectionHelper.getBCMTemplateId(module);
        layout.bcmTemplateName = DisclosureJsonHelper.getValue(module, "reportSection", "report", "name", "");
        layout.area = DisclosureJsonHelper.getValue(module, "reportSection", "report", "range", "");
        layout.dimMemberMap = ReportSectionHelper.createReportDims(module);
        return layout;
    }

    public BCMSectionShareModule.FormatNode createFormatNode(JSONObject module) {
        BCMSectionShareModule.FormatNode formatNode = new BCMSectionShareModule.FormatNode();
        formatNode.body = DisclosureJsonToMiddleHelper.createBodyNode(module);
        formatNode.styleNode = this.createStyleNode(module);
        formatNode.tableNode = this.createTableFormatNode(module);
        formatNode.cellFormatNode = this.createCellFormatNode(module);
        return formatNode;
    }

    private BCMSectionShareModule.StyleNode createStyleNode(JSONObject module) {
        BCMSectionShareModule.StyleNode styleNode = new BCMSectionShareModule.StyleNode();
        JSONObject styleData = DisclosureJsonHelper.getJsonObject(module, "reportSection", "styleData");
        if (styleData == null) {
            return styleNode;
        }
        styleNode.styleSource = BCMSectionMiddleConvertHelper.createStyleEnum(DisclosureJsonHelper.getValue(styleData, "styleSource", "1"));
        styleNode.floatDisplay = BCMSectionMiddleConvertHelper.createDisplayEnum(DisclosureJsonHelper.getValue(styleData, "floatDisplay", "3"));
        styleNode.unit = BCMSectionMiddleConvertHelper.createUnitEnum(DisclosureJsonHelper.getValue(styleData, "unit", "2"));
        styleNode.decimalEnable = DisclosureJsonHelper.getValue(styleData, "decimalEnable", true);
        styleNode.decimalPlaces = DisclosureJsonHelper.getValue(styleData, "decimal", 2);
        return styleNode;
    }

    private BCMSectionShareModule.TableFormatNode createTableFormatNode(JSONObject module) {
        BCMSectionShareModule.TableFormatNode tableFormatNode = new BCMSectionShareModule.TableFormatNode();
        tableFormatNode.cellFontFit = DisclosureJsonHelper.getValue(module, "reportSection", "cellFontFit", false);
        tableFormatNode.ignoreEmptyRowCol = DisclosureJsonHelper.getValue(module, "reportSection", "ignoreEmptyRowCol", false);
        tableFormatNode.widthRate = DisclosureJsonHelper.getValue(module, "reportSection", "widthRate", 1.0);
        tableFormatNode.columnType = BCMSectionMiddleConvertHelper.createColumnTypeEnum(DisclosureJsonHelper.getValue(module, "reportSection", "columnType", "1"));
        return tableFormatNode;
    }

    private BCMSectionShareModule.CellFormatNode createCellFormatNode(JSONObject module) {
        BCMSectionShareModule.CellFormatNode cellFormatNode = new BCMSectionShareModule.CellFormatNode();
        cellFormatNode.top = DisclosureJsonHelper.getValue(module, "reportSection", "cell", "top", 0.0);
        cellFormatNode.bottom = DisclosureJsonHelper.getValue(module, "reportSection", "cell", "bottom", 0.0);
        cellFormatNode.left = DisclosureJsonHelper.getValue(module, "reportSection", "cell", "left", 0.0);
        cellFormatNode.right = DisclosureJsonHelper.getValue(module, "reportSection", "cell", "right", 0.0);
        return cellFormatNode;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, BCMSectionShareModule middle) {
        this.tips = new ArrayList<String>(100);
        ModuleEnum moduleEnum = ModuleEnum.REPORT_SECTION;
        JSONObject module = DisclosureDefaultJsonHelper.getDefaultJsonObejct(moduleEnum);
        this.createInfo(moduleEnum, module, middle.info);
        this.createLayout(input.getDmModelId(), module, middle.layout);
        this.createFormat(module, middle.format);
        return module;
    }

    public void createInfo(ModuleEnum moduleEnum, JSONObject module, InfoNode infoNode) {
        DisclosureMiddleToJsonHelper.createInfo(module, infoNode);
        module.put("type", (Object)moduleEnum.getType());
        if (StringUtils.isEmpty((String)infoNode.number)) {
            module.put("number", (Object)(moduleEnum.getNumber() + "01"));
        }
    }

    public void createLayout(Long dmModelId, JSONObject module, BCMSectionShareModule.LayoutNode layoutNode) {
        if (layoutNode == null || layoutNode.dimMemberMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e03\u5c40\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"DisclosureMiddleJsonHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject bcmTemplateDy = ReportSectionHelper.getTemplateId(layoutNode.bcmTemplateId);
        JSONObject specialMap = new JSONObject();
        specialMap.put("componentId", (Object)layoutNode.bcmTemplateId.toString());
        module.put("specialMap", (Object)specialMap);
        JSONObject report = new JSONObject();
        report.put("name", (Object)bcmTemplateDy.getString("name"));
        report.put("range", (Object)bcmTemplateDy.getString("selectedarea"));
        module.put("report", (Object)report);
        JSONObject reportSection = DisclosureJsonHelper.getJsonObject(module, "reportSection");
        if (reportSection != null) {
            reportSection.put("reportDims", (Object)ReportSectionHelper.createReportDims(dmModelId, layoutNode.dimMemberMap));
        }
    }

    public void createFormat(JSONObject module, BCMSectionShareModule.FormatNode formatNode) {
        DisclosureMiddleToJsonHelper.createBody(module, formatNode.body);
        this.createStyleNode(module, formatNode.styleNode);
        this.createTableFormatNode(module, formatNode.tableNode);
        this.createCellFormatNode(module, formatNode.cellFormatNode);
    }

    private void createStyleNode(JSONObject module, BCMSectionShareModule.StyleNode styleNode) {
        JSONObject styleData = DisclosureJsonHelper.getJsonObject(module, "reportSection", "styleData");
        if (styleData == null) {
            return;
        }
        styleData.put("styleSource", (Object)BCMSectionMiddleConvertHelper.createStyleEnum(styleNode.styleSource));
        styleData.put("floatDisplay", (Object)BCMSectionMiddleConvertHelper.createDisplayEnum(styleNode.floatDisplay));
        styleData.put("unit", (Object)BCMSectionMiddleConvertHelper.createUnitEnum(styleNode.unit));
        styleData.put("decimalEnable", (Object)styleNode.decimalEnable);
        styleData.put("decimalPlaces", (Object)styleNode.decimalPlaces);
    }

    private void createTableFormatNode(JSONObject module, BCMSectionShareModule.TableFormatNode tableFormatNode) {
        JSONObject reportSection = DisclosureJsonHelper.getJsonObject(module, "reportSection");
        if (reportSection == null) {
            return;
        }
        reportSection.put("cellFontFit", (Object)tableFormatNode.cellFontFit);
        reportSection.put("ignoreEmptyRowCol", (Object)tableFormatNode.ignoreEmptyRowCol);
        reportSection.put("cellFontFit", (Object)tableFormatNode.cellFontFit);
        reportSection.put("widthRate", (Object)tableFormatNode.widthRate);
        reportSection.put("columnType", (Object)BCMSectionMiddleConvertHelper.createColumnTypeEnum(tableFormatNode.columnType));
    }

    private void createCellFormatNode(JSONObject module, BCMSectionShareModule.CellFormatNode cellFormatNode) {
        JSONObject cell = DisclosureJsonHelper.getJsonObject(module, "reportSection", "cell");
        if (cell == null) {
            return;
        }
        cell.put("top", (Object)cellFormatNode.top);
        cell.put("bottom", (Object)cellFormatNode.bottom);
        cell.put("left", (Object)cellFormatNode.left);
        cell.put("right", (Object)cellFormatNode.right);
    }
}

