/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.EBSectionShareModule;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.eb.EBReportsectionReader;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureDefaultJsonHelper;
import kd.epm.far.business.fidm.module.EBReportSectionHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureJsonToMiddleHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.EBSectionMiddleConvertHelper;

public class EBSectionModuleConvert
implements IMiddleModuleConvert<EBSectionShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public EBSectionShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        this.tips = new ArrayList<String>(100);
        EBSectionShareModule middle = new EBSectionShareModule();
        middle.info = DisclosureJsonToMiddleHelper.createInfoNode(module);
        middle.layout = this.createLayoutNode(module);
        middle.format = this.createFormatNode(module);
        return middle;
    }

    private EBSectionShareModule.LayoutNode createLayoutNode(JSONObject module) {
        EBSectionShareModule.LayoutNode layout = new EBSectionShareModule.LayoutNode();
        layout.ebTemplateId = EBReportSectionHelper.getEbTemplateId(module);
        layout.ebTemplateName = DisclosureJsonHelper.getValue(module, "reportSection", "report", "name", "");
        layout.dimMemberMap = EBReportSectionHelper.createReportDims(module, "reportDims");
        layout.varMemberMap = EBReportSectionHelper.createReportDims(module, "reportVars");
        layout.defaultDataSet = DisclosureJsonHelper.getValue(module, "reportSection", "defaultDataSet", "");
        return layout;
    }

    public EBSectionShareModule.FormatNode createFormatNode(JSONObject module) {
        EBSectionShareModule.FormatNode formatNode = new EBSectionShareModule.FormatNode();
        formatNode.body = DisclosureJsonToMiddleHelper.createBodyNode(module);
        formatNode.tableNode = this.createTableFormatNode(module);
        formatNode.cellFormatNode = this.createCellFormatNode(module);
        return formatNode;
    }

    private EBSectionShareModule.TableFormatNode createTableFormatNode(JSONObject module) {
        EBSectionShareModule.TableFormatNode tableFormatNode = new EBSectionShareModule.TableFormatNode();
        tableFormatNode.cellFontFit = DisclosureJsonHelper.getValue(module, "reportSection", "cellFontFit", false);
        tableFormatNode.ignoreEmptyRowCol = DisclosureJsonHelper.getValue(module, "reportSection", "ignoreEmptyRowCol", false);
        tableFormatNode.widthRate = DisclosureJsonHelper.getValue(module, "reportSection", "widthRate", 1.0);
        tableFormatNode.columnType = EBSectionMiddleConvertHelper.createColumnTypeEnum(DisclosureJsonHelper.getValue(module, "reportSection", "columnType", "1"));
        return tableFormatNode;
    }

    private EBSectionShareModule.CellFormatNode createCellFormatNode(JSONObject module) {
        EBSectionShareModule.CellFormatNode cellFormatNode = new EBSectionShareModule.CellFormatNode();
        cellFormatNode.top = DisclosureJsonHelper.getValue(module, "reportSection", "cell", "top", 0.0);
        cellFormatNode.bottom = DisclosureJsonHelper.getValue(module, "reportSection", "cell", "bottom", 0.0);
        cellFormatNode.left = DisclosureJsonHelper.getValue(module, "reportSection", "cell", "left", 0.0);
        cellFormatNode.right = DisclosureJsonHelper.getValue(module, "reportSection", "cell", "right", 0.0);
        return cellFormatNode;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, EBSectionShareModule middle) {
        this.tips = new ArrayList<String>(100);
        ModuleEnum moduleEnum = ModuleEnum.EB_REPORT_SECTION;
        JSONObject module = DisclosureDefaultJsonHelper.getDefaultJsonObejct(moduleEnum);
        this.createInfo(moduleEnum, module, middle.info);
        this.createLayout(input.getDmModelId(), module, middle.layout);
        this.createFormat(module, middle.format);
        return module;
    }

    public void createInfo(ModuleEnum moduleEnum, JSONObject module, InfoNode infoNode) {
        DisclosureMiddleToJsonHelper.createInfo(module, infoNode);
        module.put("type", (Object)moduleEnum.getType());
        if (StringUtils.isEmpty((String)infoNode.number)) {
            module.put("number", (Object)(moduleEnum.getNumber() + "01"));
        }
    }

    public void createLayout(Long dmModelId, JSONObject module, EBSectionShareModule.LayoutNode layoutNode) {
        if (layoutNode == null || layoutNode.dimMemberMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e03\u5c40\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"DisclosureMiddleJsonHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject ebTemplateDy = EBReportsectionReader.getRptsection(layoutNode.ebTemplateId, true);
        JSONObject specialMap = new JSONObject();
        specialMap.put("componentId", (Object)layoutNode.ebTemplateId.toString());
        module.put("specialMap", (Object)specialMap);
        JSONObject report = new JSONObject();
        report.put("name", (Object)ebTemplateDy.getString("name"));
        report.put("range", (Object)"");
        module.put("report", (Object)report);
        JSONObject reportSection = DisclosureJsonHelper.getJsonObject(module, "reportSection");
        if (reportSection != null) {
            reportSection.put("defaultDataSet", (Object)layoutNode.defaultDataSet);
            reportSection.put("reportDims", (Object)EBReportSectionHelper.createReportDims(dmModelId, layoutNode.dimMemberMap));
            reportSection.put("reportVars", (Object)EBReportSectionHelper.createReportDims(dmModelId, layoutNode.varMemberMap));
        }
    }

    public void createFormat(JSONObject module, EBSectionShareModule.FormatNode formatNode) {
        DisclosureMiddleToJsonHelper.createBody(module, formatNode.body);
        this.createTableFormatNode(module, formatNode.tableNode);
        this.createCellFormatNode(module, formatNode.cellFormatNode);
    }

    private void createTableFormatNode(JSONObject module, EBSectionShareModule.TableFormatNode tableFormatNode) {
        JSONObject reportSection = DisclosureJsonHelper.getJsonObject(module, "reportSection");
        if (reportSection == null) {
            return;
        }
        reportSection.put("cellFontFit", (Object)tableFormatNode.cellFontFit);
        reportSection.put("ignoreEmptyRowCol", (Object)tableFormatNode.ignoreEmptyRowCol);
        reportSection.put("cellFontFit", (Object)tableFormatNode.cellFontFit);
        reportSection.put("widthRate", (Object)tableFormatNode.widthRate);
        reportSection.put("columnType", (Object)EBSectionMiddleConvertHelper.createColumnTypeEnum(tableFormatNode.columnType));
    }

    private void createCellFormatNode(JSONObject module, EBSectionShareModule.CellFormatNode cellFormatNode) {
        JSONObject cell = DisclosureJsonHelper.getJsonObject(module, "reportSection", "cell");
        if (cell == null) {
            return;
        }
        cell.put("top", (Object)cellFormatNode.top);
        cell.put("bottom", (Object)cellFormatNode.bottom);
        cell.put("left", (Object)cellFormatNode.left);
        cell.put("right", (Object)cellFormatNode.right);
    }
}

