/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.LineShareModule;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureDefaultJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureJsonToMiddleHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.LineMiddleConvertHelper;

public class LineModuleConvert
implements IMiddleModuleConvert<LineShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public LineShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        this.tips = new ArrayList<String>(100);
        LineShareModule.TypeEnum typeEnum = LineShareModule.TypeEnum.BAR;
        String moduleType = module.getString("type");
        if (ModuleEnum.LINE.getType().equalsIgnoreCase(moduleType)) {
            typeEnum = LineShareModule.TypeEnum.LINE;
        } else if (ModuleEnum.AREA.getType().equalsIgnoreCase(moduleType)) {
            typeEnum = LineShareModule.TypeEnum.AREA;
        } else if (ModuleEnum.CLUSTERED_COLUMNAR.getType().equalsIgnoreCase(moduleType)) {
            typeEnum = LineShareModule.TypeEnum.BAR_AREA;
        } else if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equalsIgnoreCase(moduleType)) {
            typeEnum = LineShareModule.TypeEnum.POLYLINE_STACK;
        } else if (ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equalsIgnoreCase(moduleType)) {
            typeEnum = LineShareModule.TypeEnum.POLYLINE_AREA;
        } else if (ModuleEnum.CLUSTERED_BAR.getType().equalsIgnoreCase(moduleType)) {
            typeEnum = LineShareModule.TypeEnum.AREATA_BAR;
        }
        LineShareModule middle = new LineShareModule();
        middle.type = typeEnum;
        middle.info = DisclosureJsonToMiddleHelper.createInfoNode(module);
        middle.dataset = DisclosureJsonToMiddleHelper.createDatasetNode(module);
        middle.layout = this.createLayoutNode(typeEnum, module);
        middle.format = LineModuleConvert.createFormatNode(module);
        return middle;
    }

    private LineShareModule.LayoutNode createLayoutNode(LineShareModule.TypeEnum typeEnum, JSONObject module) {
        LineShareModule.LayoutNode layout = new LineShareModule.LayoutNode();
        layout.xAxisNumber = DisclosureJsonHelper.getValue(module, "specialMap", "x", "");
        layout.xSort = DisclosureJsonToMiddleHelper.createSortNode(DisclosureJsonHelper.getJsonObject(module, "specialMap", "xSort"));
        layout.y1AxisNumber = DisclosureJsonHelper.getValue(module, "specialMap", "y", "");
        layout.y1Legend = DisclosureJsonHelper.getValue(module, "specialMap", "legend", "");
        layout.y1LegendSort = DisclosureJsonToMiddleHelper.createSortNode(DisclosureJsonHelper.getJsonObject(module, "specialMap", "legendSort"));
        if (typeEnum.getType() == LineShareModule.TypeEnum.POLYLINE_STACK.getType() || typeEnum.getType() == LineShareModule.TypeEnum.POLYLINE_AREA.getType()) {
            layout.y1AxisNumber = DisclosureJsonHelper.getValue(module, "specialMap", "y", "");
            layout.y1Legend = DisclosureJsonHelper.getValue(module, "specialMap", "columnarlegend", "");
            layout.y1LegendSort = DisclosureJsonToMiddleHelper.createSortNode(DisclosureJsonHelper.getJsonObject(module, "specialMap", "columnarlegendSort"));
        }
        layout.y2AxisNumber = DisclosureJsonHelper.getValue(module, "specialMap", "y1", "");
        layout.y2Legend = DisclosureJsonHelper.getValue(module, "specialMap", "linelegend", "");
        layout.y2LegendSort = DisclosureJsonToMiddleHelper.createSortNode(DisclosureJsonHelper.getJsonObject(module, "specialMap", "linelegendSort"));
        return layout;
    }

    public static LineShareModule.FormatNode createFormatNode(JSONObject module) {
        LineShareModule.FormatNode formatNode = new LineShareModule.FormatNode();
        formatNode.title = DisclosureJsonToMiddleHelper.createTitleNode(module);
        formatNode.dataFormat = LineModuleConvert.createDataFormatNode(module);
        formatNode.border = DisclosureJsonToMiddleHelper.createBorderNode(module);
        formatNode.body = DisclosureJsonToMiddleHelper.createBodyNode(module);
        return formatNode;
    }

    private static DataFormatNode createDataFormatNode(JSONObject module) {
        JSONObject dataFormat = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "pie");
        if (dataFormat == null) {
            return null;
        }
        DataFormatNode dataFormatNode = DisclosureJsonToMiddleHelper.createDataFormatNode(dataFormat);
        return dataFormatNode;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, LineShareModule middle) {
        this.tips = new ArrayList<String>(100);
        ModuleEnum moduleEnum = ModuleEnum.STACKED_COLUMNAR;
        LineShareModule.TypeEnum typeEnum = middle.type;
        if (LineShareModule.TypeEnum.LINE.getType() == typeEnum.getType()) {
            moduleEnum = ModuleEnum.LINE;
        } else if (LineShareModule.TypeEnum.AREA.getType() == typeEnum.getType()) {
            moduleEnum = ModuleEnum.AREA;
        } else if (LineShareModule.TypeEnum.BAR_AREA.getType() == typeEnum.getType()) {
            moduleEnum = ModuleEnum.CLUSTERED_COLUMNAR;
        } else if (LineShareModule.TypeEnum.POLYLINE_STACK.getType() == typeEnum.getType()) {
            moduleEnum = ModuleEnum.LINE_STACKED_COLUMNAR;
        } else if (LineShareModule.TypeEnum.POLYLINE_AREA.getType() == typeEnum.getType()) {
            moduleEnum = ModuleEnum.LINE_CLUSTERED_COLUMNAR;
        } else if (LineShareModule.TypeEnum.AREATA_BAR.getType() == typeEnum.getType()) {
            moduleEnum = ModuleEnum.CLUSTERED_BAR;
        } else if (LineShareModule.TypeEnum.STACKED_BAR.getType() == typeEnum.getType()) {
            moduleEnum = ModuleEnum.STACKED_BAR;
        }
        JSONObject module = DisclosureDefaultJsonHelper.getDefaultJsonObejct(moduleEnum);
        LineModuleConvert.createInfo(moduleEnum, module, middle.info);
        DisclosureMiddleToJsonHelper.createDataset(input.getDmModelId(), this.tips, module, middle.dataset);
        LineModuleConvert.createLayout(input.isPropertyCheck(), moduleEnum, module, middle.layout);
        LineModuleConvert.createFormat(moduleEnum, module, middle.format);
        return module;
    }

    public static void createInfo(ModuleEnum moduleEnum, JSONObject module, InfoNode infoNode) {
        DisclosureMiddleToJsonHelper.createInfo(module, infoNode);
        module.put("type", (Object)moduleEnum.getType());
        if (StringUtils.isEmpty((String)infoNode.number)) {
            module.put("number", (Object)(moduleEnum.getNumber() + "01"));
        }
    }

    public static void createLayout(boolean propertyCheck, ModuleEnum moduleEnum, JSONObject module, LineShareModule.LayoutNode layoutNode) {
        if (layoutNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e03\u5c40\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"DisclosureMiddleJsonHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        JSONObject specialMap = DisclosureJsonHelper.getJsonObject(module, "specialMap");
        if (specialMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e03\u5c40\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"DisclosureMiddleJsonHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (propertyCheck && (moduleEnum == ModuleEnum.STACKED_COLUMNAR || moduleEnum == ModuleEnum.CLUSTERED_COLUMNAR || moduleEnum == ModuleEnum.CLUSTERED_BAR || moduleEnum == ModuleEnum.AREA || moduleEnum == ModuleEnum.LINE) && StringUtils.isEmpty((String)layoutNode.y1Legend)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e03\u5c40\u6570\u636e\u7684\u56fe\u4f8b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"DisclosureMiddleJsonHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        specialMap.put("x", (Object)layoutNode.xAxisNumber);
        specialMap.put("xSort", (Object)DisclosureMiddleToJsonHelper.createSort(layoutNode.xSort));
        if (moduleEnum.getType().equalsIgnoreCase(ModuleEnum.LINE_STACKED_COLUMNAR.getType()) || moduleEnum.getType().equalsIgnoreCase(ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType())) {
            specialMap.put("y", (Object)layoutNode.y1AxisNumber);
            specialMap.put("columnarlegend", (Object)layoutNode.y1Legend);
            specialMap.put("columnarlegendSort", (Object)DisclosureMiddleToJsonHelper.createSort(layoutNode.y1LegendSort));
        } else {
            specialMap.put("y", (Object)layoutNode.y1AxisNumber);
            specialMap.put("legend", (Object)layoutNode.y1Legend);
            specialMap.put("legendSort", (Object)DisclosureMiddleToJsonHelper.createSort(layoutNode.y1LegendSort));
        }
        specialMap.put("y1", (Object)layoutNode.y2AxisNumber);
        specialMap.put("linelegend", (Object)layoutNode.y2Legend);
        specialMap.put("linelegendSort", (Object)DisclosureMiddleToJsonHelper.createSort(layoutNode.y2LegendSort));
    }

    private static void createFormat(ModuleEnum moduleEnum, JSONObject module, LineShareModule.FormatNode formatNode) {
        JSONObject titleObj;
        JSONObject y1DataFormat = DisclosureMiddleToJsonHelper.createDataFormat(formatNode.dataFormat);
        if (y1DataFormat != null) {
            JSONObject dataFormat = module.getJSONObject("dataFormat");
            if (dataFormat == null) {
                dataFormat = new JSONObject();
            }
            y1DataFormat.put("dataLabel", (Object)LineMiddleConvertHelper.getDataLabelEnum(formatNode.dataFormat.dataLabelType));
            dataFormat.put("y1", (Object)y1DataFormat);
            if (moduleEnum.getType().equalsIgnoreCase(ModuleEnum.LINE_STACKED_COLUMNAR.getType()) || moduleEnum.getType().equalsIgnoreCase(ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType())) {
                dataFormat.put("y2", (Object)y1DataFormat);
            }
            module.put("dataFormat", (Object)dataFormat);
        }
        if ((titleObj = DisclosureMiddleToJsonHelper.createTitle(formatNode.title)) != null) {
            titleObj.put("align", (Object)"center");
            titleObj.put("style", (Object)"normal");
            module.put("title", (Object)titleObj);
        }
        DisclosureMiddleToJsonHelper.createBody(module, formatNode.body);
        DisclosureMiddleToJsonHelper.createBoder(module, formatNode.border);
    }
}

