/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.PieShareModule;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureDefaultJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureJsonToMiddleHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.PieMiddleConvertHelper;

public class PieModuleConvert
implements IMiddleModuleConvert<PieShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public PieShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        this.tips = new ArrayList<String>(100);
        PieShareModule.TypeEnum typeEnum = PieShareModule.TypeEnum.PIE;
        String moduleType = module.getString("type");
        if (ModuleEnum.DOUGHNUT.getType().equalsIgnoreCase(moduleType)) {
            typeEnum = PieShareModule.TypeEnum.DOUGHNUT;
        }
        PieShareModule middle = new PieShareModule();
        middle.type = typeEnum;
        middle.info = DisclosureJsonToMiddleHelper.createInfoNode(module);
        middle.dataset = DisclosureJsonToMiddleHelper.createDatasetNode(module);
        middle.layout = this.createLayoutNode(module);
        middle.format = PieModuleConvert.createFormatNode(module);
        return middle;
    }

    private PieShareModule.LayoutNode createLayoutNode(JSONObject module) {
        PieShareModule.LayoutNode layout = new PieShareModule.LayoutNode();
        layout.legendNumber = DisclosureJsonHelper.getValue(module, "specialMap", "legend", "");
        layout.displayValueNumber = DisclosureJsonHelper.getValue(module, "specialMap", "detail", "");
        layout.legendSort = DisclosureJsonToMiddleHelper.createSortNode(DisclosureJsonHelper.getJsonObject(module, "specialMap", "legendSort"));
        return layout;
    }

    public static PieShareModule.FormatNode createFormatNode(JSONObject module) {
        PieShareModule.FormatNode formatNode = new PieShareModule.FormatNode();
        formatNode.title = DisclosureJsonToMiddleHelper.createTitleNode(module);
        formatNode.legend = PieMiddleConvertHelper.createLegendNode(module);
        formatNode.dataFormat = PieModuleConvert.createDataFormatNode(module);
        formatNode.border = DisclosureJsonToMiddleHelper.createBorderNode(module);
        formatNode.body = DisclosureJsonToMiddleHelper.createBodyNode(module);
        return formatNode;
    }

    private static DataFormatNode createDataFormatNode(JSONObject module) {
        JSONObject dataFormat = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "pie");
        if (dataFormat == null) {
            return null;
        }
        DataFormatNode dataFormatNode = DisclosureJsonToMiddleHelper.createDataFormatNode(dataFormat);
        if (dataFormatNode != null) {
            dataFormatNode.dataLabelType = PieMiddleConvertHelper.getDataLabelEnumNode(dataFormat.getString("dataLabel"));
        }
        return dataFormatNode;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, PieShareModule middle) {
        this.tips = new ArrayList<String>(100);
        ModuleEnum moduleEnum = ModuleEnum.PIE;
        if (PieShareModule.TypeEnum.DOUGHNUT.getType() == middle.type.getType()) {
            moduleEnum = ModuleEnum.DOUGHNUT;
        }
        JSONObject module = DisclosureDefaultJsonHelper.getDefaultJsonObejct(moduleEnum);
        PieModuleConvert.createInfo(moduleEnum, module, middle.info);
        DisclosureMiddleToJsonHelper.createDataset(input.getDmModelId(), this.tips, module, middle.dataset);
        PieModuleConvert.createLayout(input.isPropertyCheck(), module, middle.layout);
        PieModuleConvert.createFormat(moduleEnum, module, middle.format);
        return module;
    }

    public static void createInfo(ModuleEnum moduleEnum, JSONObject module, InfoNode infoNode) {
        DisclosureMiddleToJsonHelper.createInfo(module, infoNode);
        module.put("type", (Object)moduleEnum.getType());
        if (StringUtils.isEmpty((String)infoNode.number)) {
            module.put("number", (Object)(moduleEnum.getNumber() + "01"));
        }
    }

    public static void createLayout(boolean propertyCheck, JSONObject module, PieShareModule.LayoutNode layoutNode) {
        if (layoutNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e03\u5c40\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"DisclosureMiddleJsonHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (propertyCheck && (StringUtils.isEmpty((String)layoutNode.legendNumber) || StringUtils.isEmpty((String)layoutNode.displayValueNumber))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e03\u5c40\u6570\u636e\u7684\u56fe\u4f8b/\u5c55\u793a\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"DisclosureMiddleJsonHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        JSONObject specialMap = new JSONObject();
        specialMap.put("legendSort", (Object)DisclosureMiddleToJsonHelper.createSort(layoutNode.legendSort));
        specialMap.put("legend", (Object)layoutNode.legendNumber);
        specialMap.put("detail", (Object)layoutNode.displayValueNumber);
        module.put("specialMap", (Object)specialMap);
    }

    private static void createFormat(ModuleEnum moduleEnum, JSONObject module, PieShareModule.FormatNode formatNode) {
        JSONObject legendObj;
        JSONObject titleObj;
        if (formatNode == null) {
            return;
        }
        JSONObject pieDataFormat = DisclosureMiddleToJsonHelper.createDataFormat(formatNode.dataFormat);
        if (pieDataFormat != null) {
            pieDataFormat.put("visible", (Object)true);
            pieDataFormat.put("dataLabel", (Object)PieMiddleConvertHelper.getDataLabelEnum(formatNode.dataFormat.dataLabelType));
            if (ModuleEnum.DOUGHNUT.getType().equalsIgnoreCase(moduleEnum.getType())) {
                pieDataFormat.put("dataLabel", (Object)"ctr");
            }
            JSONObject dataFormat = new JSONObject();
            dataFormat.put("pie", (Object)pieDataFormat);
            module.put("dataFormat", (Object)dataFormat);
        }
        if ((titleObj = DisclosureMiddleToJsonHelper.createTitle(formatNode.title)) != null) {
            module.put("title", (Object)titleObj);
        }
        if ((legendObj = PieMiddleConvertHelper.createLegend(formatNode.legend)) != null) {
            module.put("legend", (Object)legendObj);
        }
        DisclosureMiddleToJsonHelper.createBody(module, formatNode.body);
        DisclosureMiddleToJsonHelper.createBoder(module, formatNode.border);
    }
}

