/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.PointShareModule;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureDefaultJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureJsonToMiddleHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.PointMiddleConvertHelper;

public class PointModuleConvert
implements IMiddleModuleConvert<PointShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public PointShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        this.tips = new ArrayList<String>(100);
        PointShareModule middle = new PointShareModule();
        middle.info = DisclosureJsonToMiddleHelper.createInfoNode(module);
        middle.dataset = DisclosureJsonToMiddleHelper.createDatasetNode(module);
        middle.layout = this.createLayoutNode(module);
        middle.format = PointModuleConvert.createFormatNode(module);
        return middle;
    }

    private PointShareModule.LayoutNode createLayoutNode(JSONObject module) {
        PointShareModule.LayoutNode layout = new PointShareModule.LayoutNode();
        layout.prefix = DisclosureJsonHelper.getValue(module, "dataPoint", "prefix", "");
        layout.suffix = DisclosureJsonHelper.getValue(module, "dataPoint", "suffix", "");
        layout.expression = DisclosureJsonHelper.getValue(module, "dataPoint", "specialFormula", "");
        return layout;
    }

    public static PointShareModule.FormatNode createFormatNode(JSONObject module) {
        PointShareModule.FormatNode formatNode = new PointShareModule.FormatNode();
        formatNode.dataFormat = PointModuleConvert.createDataFormatNode(module);
        formatNode.conditions = PointMiddleConvertHelper.createPointConditionNode(module);
        return formatNode;
    }

    private static DataFormatNode createDataFormatNode(JSONObject module) {
        JSONObject dataFormat = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "dataPoint");
        if (dataFormat == null) {
            return null;
        }
        DataFormatNode dataFormatNode = DisclosureJsonToMiddleHelper.createDataFormatNode(dataFormat);
        return dataFormatNode;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, PointShareModule middle) {
        this.tips = new ArrayList<String>(100);
        JSONObject module = DisclosureDefaultJsonHelper.getDefaultJsonObejct(ModuleEnum.VAR);
        PointModuleConvert.createInfo(module, middle.info);
        DisclosureMiddleToJsonHelper.createDataset(input.getDmModelId(), this.tips, module, middle.dataset);
        PointModuleConvert.createLayout(module, middle.layout);
        PointModuleConvert.createFormat(module, middle.format);
        return module;
    }

    public static void createInfo(JSONObject module, InfoNode infoNode) {
        DisclosureMiddleToJsonHelper.createInfo(module, infoNode);
        module.put("type", (Object)ModuleEnum.VAR.getType());
        if (StringUtils.isEmpty((String)infoNode.number)) {
            module.put("number", (Object)(ModuleEnum.VAR.getNumber() + "01"));
        }
    }

    public static void createLayout(JSONObject module, PointShareModule.LayoutNode layoutNode) {
        if (layoutNode == null) {
            return;
        }
        JSONObject dataPoint = new JSONObject();
        dataPoint.put("prefix", (Object)layoutNode.prefix);
        dataPoint.put("suffix", (Object)layoutNode.suffix);
        dataPoint.put("specialFormula", (Object)layoutNode.expression);
        module.put("dataPoint", (Object)dataPoint);
    }

    private static void createFormat(JSONObject module, PointShareModule.FormatNode formatNode) {
        JSONArray conditions;
        JSONObject dataPoint;
        if (formatNode == null) {
            return;
        }
        JSONObject pieDataFormat = DisclosureMiddleToJsonHelper.createDataFormat(formatNode.dataFormat);
        if (pieDataFormat != null) {
            pieDataFormat.put("visible", (Object)true);
            JSONObject dataFormat = new JSONObject();
            dataFormat.put("dataPoint", (Object)pieDataFormat);
            module.put("dataFormat", (Object)dataFormat);
        }
        if ((dataPoint = module.getJSONObject("dataPoint")) != null && (conditions = PointMiddleConvertHelper.createPointCondition(formatNode.conditions)) != null) {
            dataPoint.put("conditions", (Object)conditions);
        }
    }
}

