/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.ReportInfoShareModule;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureDefaultJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureJsonToMiddleHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;

public class ReportInfoModuleConvert
implements IMiddleModuleConvert<ReportInfoShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public ReportInfoShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        this.tips = new ArrayList<String>(100);
        ReportInfoShareModule.TypeEnum typeEnum = ReportInfoShareModule.TypeEnum.Date;
        ReportInfoShareModule middle = new ReportInfoShareModule();
        middle.info = DisclosureJsonToMiddleHelper.createInfoNode(module);
        middle.layout = this.createLayoutNode(module);
        return middle;
    }

    private ReportInfoShareModule.LayoutNode createLayoutNode(JSONObject module) {
        ReportInfoShareModule.LayoutNode layout = new ReportInfoShareModule.LayoutNode();
        layout.prefix = DisclosureJsonHelper.getValue(module, "specialMap", "rptPrefix", "");
        layout.suffix = DisclosureJsonHelper.getValue(module, "specialMap", "rptSuffix", "");
        layout.type = this.getTypeEnum(module);
        layout.dateFormat = this.getDateFormat(module);
        return layout;
    }

    private ReportInfoShareModule.TypeEnum getTypeEnum(JSONObject module) {
        ReportInfoShareModule.TypeEnum typeEnum = ReportInfoShareModule.TypeEnum.Date;
        String rptInfoNumber = DisclosureJsonHelper.getValue(module, "specialMap", "rptInfoNumber", "");
        if ("entity.name".equalsIgnoreCase(rptInfoNumber)) {
            typeEnum = ReportInfoShareModule.TypeEnum.EntityName;
        } else if ("entity.number".equalsIgnoreCase(rptInfoNumber)) {
            typeEnum = ReportInfoShareModule.TypeEnum.EntityNumber;
        } else if ("modifyname".equalsIgnoreCase(rptInfoNumber)) {
            typeEnum = ReportInfoShareModule.TypeEnum.UserName;
        }
        return typeEnum;
    }

    private String getDateFormat(JSONObject module) {
        String rptInfoNumber = DisclosureJsonHelper.getValue(module, "specialMap", "rptDateFormatNumber", "");
        if (StringUtils.isEmpty((String)rptInfoNumber)) {
            rptInfoNumber = "YYYY-MM-DD";
        }
        return rptInfoNumber;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, ReportInfoShareModule middle) {
        this.tips = new ArrayList<String>(100);
        JSONObject module = DisclosureDefaultJsonHelper.getDefaultJsonObejct(ModuleEnum.REPORT_INFO);
        this.createInfo(module, middle.info);
        this.createLayout(module, middle.layout);
        return module;
    }

    public void createInfo(JSONObject module, InfoNode infoNode) {
        DisclosureMiddleToJsonHelper.createInfo(module, infoNode);
        module.put("type", (Object)ModuleEnum.REPORT_INFO.getType());
        if (StringUtils.isEmpty((String)infoNode.number)) {
            module.put("number", (Object)(ModuleEnum.REPORT_INFO.getNumber() + "01"));
        }
    }

    public void createLayout(JSONObject module, ReportInfoShareModule.LayoutNode layoutNode) {
        JSONObject specialMap = module.getJSONObject("specialMap");
        if (specialMap == null) {
            return;
        }
        specialMap.put("rptPrefix", (Object)(StringUtils.isEmpty((String)layoutNode.prefix) ? "" : layoutNode.prefix));
        specialMap.put("rptInfoNumber", (Object)this.getTypeEnum(layoutNode.type));
        specialMap.put("rptDateFormatNumber", (Object)this.getDateFormat(layoutNode.dateFormat));
    }

    private String getTypeEnum(ReportInfoShareModule.TypeEnum typeEnum) {
        if (typeEnum == ReportInfoShareModule.TypeEnum.UserName) {
            return "modifyname";
        }
        if (typeEnum == ReportInfoShareModule.TypeEnum.EntityName) {
            return "entity.name";
        }
        if (typeEnum == ReportInfoShareModule.TypeEnum.EntityNumber) {
            return "entity.number";
        }
        return "modifytime";
    }

    private String getDateFormat(String dateFormat) {
        return dateFormat;
    }
}

