/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.TableShareModule;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.common.module.middle.node.layout.table.TableColumnNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureDefaultJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureJsonToMiddleHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.TableMiddleConvertHelper;

public class TableModuleConvert
implements IMiddleModuleConvert<TableShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public TableShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        this.tips = new ArrayList<String>(100);
        TableShareModule middle = new TableShareModule();
        middle.info = DisclosureJsonToMiddleHelper.createInfoNode(module);
        middle.dataset = DisclosureJsonToMiddleHelper.createDatasetNode(module);
        middle.layout = this.createLayoutNode(module);
        middle.format = TableModuleConvert.createFormatNode(module);
        return middle;
    }

    private TableShareModule.LayoutNode createLayoutNode(JSONObject module) {
        JSONObject table = DisclosureJsonHelper.getJsonObject(module, "table");
        TableShareModule.LayoutNode layout = new TableShareModule.LayoutNode();
        layout.tableColumns = new ArrayList<TableColumnNode>(TableMiddleConvertHelper.getTableColumnNodes(module));
        layout.display = TableMiddleConvertHelper.getTableDisplayNode(module);
        layout.isAggregation = DisclosureJsonHelper.getValue(module, "table", "isAggregation", true);
        layout.top = DisclosureJsonHelper.getValue(module, "table", "top", 10);
        if (table != null) {
            layout.textColumnAlign = TableMiddleConvertHelper.getAlignmentEnum(DisclosureJsonHelper.getValue(table, "textStyle", "align", "text", "left"));
            layout.numberColumnAlign = TableMiddleConvertHelper.getAlignmentEnum(DisclosureJsonHelper.getValue(table, "textStyle", "align", "number", "right"));
            layout.isShowText = "1".equalsIgnoreCase(DisclosureJsonHelper.getValue(module, "table", "displayType", "0"));
        }
        return layout;
    }

    public static TableShareModule.FormatNode createFormatNode(JSONObject module) {
        TableShareModule.FormatNode formatNode = new TableShareModule.FormatNode();
        formatNode.title = DisclosureJsonToMiddleHelper.createTitleNode(module);
        formatNode.dataFormat = TableModuleConvert.createDataFormatNode(module);
        formatNode.font = DisclosureJsonToMiddleHelper.createFontNode(DisclosureJsonHelper.getJsonObject(module, "table", "textStyle", "font"));
        formatNode.border = DisclosureJsonToMiddleHelper.createBorderNode(module);
        formatNode.body = DisclosureJsonToMiddleHelper.createBodyNode(module);
        return formatNode;
    }

    private static DataFormatNode createDataFormatNode(JSONObject module) {
        JSONObject dataFormat = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "table");
        if (dataFormat == null) {
            return null;
        }
        DataFormatNode dataFormatNode = DisclosureJsonToMiddleHelper.createDataFormatNode(dataFormat);
        return dataFormatNode;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, TableShareModule middle) {
        this.tips = new ArrayList<String>(100);
        ModuleEnum moduleEnum = ModuleEnum.TABLE;
        JSONObject module = DisclosureDefaultJsonHelper.getDefaultJsonObejct(ModuleEnum.TABLE);
        TableModuleConvert.createInfo(moduleEnum, module, middle.info);
        DisclosureMiddleToJsonHelper.createDataset(input.getDmModelId(), this.tips, module, middle.dataset);
        TableModuleConvert.createLayout(module, middle.layout);
        TableModuleConvert.createFormat(module, middle.format);
        return module;
    }

    public static void createInfo(ModuleEnum moduleEnum, JSONObject module, InfoNode infoNode) {
        DisclosureMiddleToJsonHelper.createInfo(module, infoNode);
        module.put("type", (Object)moduleEnum.getType());
        if (StringUtils.isEmpty((String)infoNode.number)) {
            module.put("number", (Object)(moduleEnum.getNumber() + "01"));
        }
    }

    public static void createLayout(JSONObject module, TableShareModule.LayoutNode layoutNode) {
        JSONObject display;
        if (layoutNode == null) {
            return;
        }
        JSONObject table = DisclosureJsonHelper.getJsonObject(module, "table");
        if (table == null) {
            return;
        }
        JSONArray tableColumns = TableMiddleConvertHelper.getTableColumns(layoutNode.tableColumns);
        if (tableColumns != null) {
            table.put("property", (Object)tableColumns);
        }
        if ((display = TableMiddleConvertHelper.getTableDisplay(layoutNode.display)) != null) {
            table.put("columnVisible", (Object)display);
        }
        table.put("isAggregation", (Object)layoutNode.isAggregation);
        table.put("top", (Object)layoutNode.top);
        JSONObject textStyleAlign = DisclosureJsonHelper.getJsonObject(table, "textStyle", "align");
        if (textStyleAlign != null) {
            textStyleAlign.put("number", (Object)TableMiddleConvertHelper.getAlignmentEnum(layoutNode.numberColumnAlign));
            textStyleAlign.put("text", (Object)TableMiddleConvertHelper.getAlignmentEnum(layoutNode.textColumnAlign));
        }
        table.put("displayType", (Object)(layoutNode.isShowText ? 1 : 0));
    }

    private static void createFormat(JSONObject module, TableShareModule.FormatNode formatNode) {
        JSONObject titleObj;
        if (formatNode == null) {
            return;
        }
        JSONObject pieDataFormat = DisclosureMiddleToJsonHelper.createDataFormat(formatNode.dataFormat);
        if (pieDataFormat != null) {
            pieDataFormat.put("visible", (Object)true);
            JSONObject dataFormat = new JSONObject();
            dataFormat.put("pie", (Object)pieDataFormat);
            module.put("dataFormat", (Object)dataFormat);
        }
        JSONObject font = DisclosureMiddleToJsonHelper.createFontNode(formatNode.font);
        JSONObject textStyle = DisclosureJsonHelper.getJsonObject(module, "table", "textStyle");
        if (textStyle != null) {
            textStyle.put("font", (Object)font);
        }
        if ((titleObj = DisclosureMiddleToJsonHelper.createTitle(formatNode.title)) != null) {
            module.put("title", (Object)titleObj);
        }
        DisclosureMiddleToJsonHelper.createBody(module, formatNode.body);
        DisclosureMiddleToJsonHelper.createBoder(module, formatNode.border);
    }
}

