/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetNode;
import kd.epm.far.business.common.module.middle.node.format.base.BackgroundNode;
import kd.epm.far.business.common.module.middle.node.format.base.BodyNode;
import kd.epm.far.business.common.module.middle.node.format.base.BorderNode;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.FontNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.common.module.middle.node.format.base.TextNode;
import kd.epm.far.business.common.module.middle.node.format.base.TitleNode;
import kd.epm.far.business.common.module.middle.node.layout.SortNode;
import kd.epm.far.business.far.enums.SortEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class DisclosureJsonToMiddleHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DisclosureJsonToMiddleHelper.class);

    public static InfoNode createInfoNode(JSONObject module) {
        InfoNode info = new InfoNode();
        info.id = DisclosureJsonHelper.getValue(module, "id", 0L);
        info.name = DisclosureJsonHelper.getValue(module, "name", "");
        info.number = DisclosureJsonHelper.getValue(module, "number", "");
        return info;
    }

    public static DatasetNode createDatasetNode(JSONObject module) {
        Long datasetId = DisclosureJsonHelper.getValue(module, "dataset", "id", 0L);
        if (!LongUtil.isvalidLong((Object)datasetId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u8282\u70b9\u8f6c\u6362\uff0c\u65e0\u6570\u636e\u96c6\u6570\u636e\u3002", (String)"ModuleMiddleHelper_11", (String)"epm-far-business", (Object[])new Object[0]));
        }
        try {
            return (DatasetNode)JSON.parseObject((String)module.getJSONObject("dataset").toJSONString(), DatasetNode.class);
        }
        catch (Exception ex) {
            logger.error("far createDataset error:" + module.toJSONString(), (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u8282\u70b9\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"ModuleMiddleHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static TitleNode createTitleNode(JSONObject module) {
        TitleNode titleNode = new TitleNode();
        titleNode.visible = DisclosureJsonHelper.getValue(module, "title", "visible", true);
        titleNode.content = DisclosureJsonHelper.getValue(module, "title", "name", "");
        FontNode fontNode = new FontNode();
        fontNode.fontSize = DisclosureJsonHelper.getValue(module, "title", "fontSize", 14);
        fontNode.bold = "bold".equalsIgnoreCase(DisclosureJsonHelper.getValue(module, "title", "weight", ""));
        fontNode.underline = "underline".equalsIgnoreCase(DisclosureJsonHelper.getValue(module, "title", "underline", ""));
        titleNode.font = fontNode;
        return titleNode;
    }

    public static BodyNode createBodyNode(JSONObject module) {
        double width = DisclosureJsonHelper.getValue(module, "width", 15.0);
        double height = DisclosureJsonHelper.getValue(module, "height", 10.0);
        String alignment = DisclosureJsonHelper.getValue(module, "alignment", "2");
        BodyNode bodyNode = new BodyNode();
        if (width > 0.0) {
            bodyNode.width = width / 15.0 * 100.0;
            bodyNode.height = height / width * 100.0;
            bodyNode.positionX = 0.0;
            bodyNode.positionY = 0.0;
        }
        bodyNode.alignment = DisclosureJsonToMiddleHelper.getBodyAlignment(alignment);
        return bodyNode;
    }

    public static BodyNode.AlignmentEnum getBodyAlignment(String alignment) {
        BodyNode.AlignmentEnum val = BodyNode.AlignmentEnum.Center;
        if ("1".equalsIgnoreCase(alignment)) {
            val = BodyNode.AlignmentEnum.Left;
        }
        if ("3".equalsIgnoreCase(alignment)) {
            val = BodyNode.AlignmentEnum.Right;
        }
        return val;
    }

    public static BorderNode createBorderNode(JSONObject module) {
        BorderNode borderNode = new BorderNode();
        borderNode.visible = DisclosureJsonHelper.getValue(module, "border", "visible", true);
        return borderNode;
    }

    public static DataFormatNode createDataFormatNode(JSONObject dataFormat) {
        DataFormatNode dataFormatNode = new DataFormatNode();
        dataFormatNode.visible = DisclosureJsonHelper.getValue(dataFormat, "visible", true);
        dataFormatNode.unit = DataPatternEnum.getDataPatternByType(DisclosureJsonHelper.getValue(dataFormat, "unit", "1"));
        dataFormatNode.thousandth = DisclosureJsonHelper.getValue(dataFormat, "thousandth", false);
        dataFormatNode.currencysign = DisclosureJsonHelper.getValue(dataFormat, "currencysign", "");
        dataFormatNode.dataType = DisclosureJsonToMiddleHelper.getDataTypeEnumNode(DisclosureJsonHelper.getValue(dataFormat, "numbertype", "0"));
        dataFormatNode.showLegendKey = DisclosureJsonHelper.getValue(dataFormat, "showLegendKey", false);
        dataFormatNode.showCategoryName = DisclosureJsonHelper.getValue(dataFormat, "showCategoryName", false);
        dataFormatNode.showDisplayValue = DisclosureJsonHelper.getValue(dataFormat, "showDisplayValue", true);
        dataFormatNode.showPercent = DisclosureJsonHelper.getValue(dataFormat, "showPercent", false);
        dataFormatNode.showSeriesName = DisclosureJsonHelper.getValue(dataFormat, "showSeriesName", false);
        dataFormatNode.decimalPlace = DisclosureJsonHelper.getValue(dataFormat, "decimal", 2);
        return dataFormatNode;
    }

    public static DataFormatNode.DataTypeEnum getDataTypeEnumNode(String dataType) {
        DataFormatNode.DataTypeEnum numberType = DataFormatNode.DataTypeEnum.Number;
        if ("2".equalsIgnoreCase(dataType)) {
            numberType = DataFormatNode.DataTypeEnum.Currency;
        } else if ("3".equalsIgnoreCase(dataType)) {
            numberType = DataFormatNode.DataTypeEnum.Percent;
        }
        return numberType;
    }

    public static SortNode createSortNode(JSONObject sort) {
        if (sort == null) {
            return null;
        }
        SortEnum sortEnum = SortEnum.getEnumByName(DisclosureJsonHelper.getValue(sort, "type", ""));
        SortNode sortNode = new SortNode();
        sortNode.type = sortEnum;
        sortNode.customValue = DisclosureJsonHelper.getValue(sort, "customValue", "");
        sortNode.priority = DisclosureJsonHelper.getValue(sort, "priority", "0");
        return sortNode;
    }

    public static FontNode createFontNode(JSONObject font) {
        if (font == null) {
            return null;
        }
        FontNode fontNode = new FontNode();
        fontNode.fontSize = DisclosureJsonHelper.getValue(font, "size", 18);
        fontNode.foreColor = DisclosureJsonHelper.getValue(font, "color", "");
        fontNode.underline = "underline".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "underline", ""));
        fontNode.bold = "bold".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "weight", ""));
        fontNode.italic = "italic".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "style", ""));
        return fontNode;
    }

    public static TextNode createTextNodeNode(JSONObject text) {
        if (text == null) {
            return new TextNode();
        }
        TextNode textNode = new TextNode();
        textNode.fontSize = DisclosureJsonHelper.getValue(text, "fontSize", 14);
        textNode.bold = "bold".equalsIgnoreCase(DisclosureJsonHelper.getValue(text, "weight", ""));
        textNode.italic = "italic".equalsIgnoreCase(DisclosureJsonHelper.getValue(text, "italic", ""));
        textNode.color = DisclosureJsonHelper.getValue(text, "color", "");
        textNode.enable = DisclosureJsonHelper.getValue(text, "enable", true);
        return textNode;
    }

    public static BackgroundNode createBackgroundNode(JSONObject module) {
        BackgroundNode backgroundNode = new BackgroundNode();
        return backgroundNode;
    }
}

