/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.module.middle.helper.DatasetNodeHelper;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetNode;
import kd.epm.far.business.common.module.middle.node.format.base.BodyNode;
import kd.epm.far.business.common.module.middle.node.format.base.BorderNode;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.FontNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.common.module.middle.node.format.base.TitleNode;
import kd.epm.far.business.common.module.middle.node.layout.SortNode;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosureMiddleToJsonHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DisclosureMiddleToJsonHelper.class);

    public static JSONObject getDefaultJsonObejct(String defaultStr) {
        try {
            return JSON.parseObject((String)defaultStr);
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u7ec4\u4ef6\u9ed8\u8ba4\u5c5e\u6027\u5f02\u5e38\u3002", (String)"DisclosureMiddleJsonHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(msg, (Throwable)ex);
            throw new KDBizException(msg);
        }
    }

    public static void createInfo(JSONObject module, InfoNode infoNode) {
        module.put("id", (Object)infoNode.id.toString());
        module.put("number", (Object)infoNode.number);
        module.put("name", (Object)infoNode.name);
    }

    public static void createDataset(Long dmModelId, List<String> strTips, JSONObject module, DatasetNode datasetNode) {
        if (datasetNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u96c6\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"DisclosureMiddleJsonHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        try {
            DatasetNode newDataset = DatasetNodeHelper.resetDatasetNode(dmModelId, 0L, datasetNode, strTips);
            JSONObject datasetObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)newDataset));
            module.put("dataset", (Object)datasetObj);
        }
        catch (KDBizException bizException) {
            throw bizException;
        }
        catch (Exception ex) {
            logger.error("fidm createDataset error:" + module.toJSONString(), (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"DisclosureMiddleJsonHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static JSONObject createTitle(TitleNode titleNode) {
        if (titleNode == null) {
            return null;
        }
        JSONObject title = new JSONObject();
        title.put("visible", (Object)titleNode.visible);
        title.put("name", (Object)titleNode.content);
        title.put("fontSize", (Object)(titleNode.font == null ? 18 : titleNode.font.fontSize));
        title.put("weight", (Object)(titleNode.font == null ? "" : (titleNode.font.bold ? "bold" : "")));
        title.put("underline", (Object)(titleNode.font == null ? "" : (titleNode.font.underline ? "underline" : "")));
        if (StringUtils.isEmpty((String)title.getString("weight"))) {
            title.put("weight", (Object)"normal");
        }
        if (StringUtils.isEmpty((String)title.getString("underline"))) {
            title.put("underline", (Object)"normal");
        }
        return title;
    }

    public static void createBody(JSONObject module, BodyNode bodyNode) {
        if (module == null || bodyNode == null || bodyNode.width == 0.0 || bodyNode.height == 0.0) {
            return;
        }
        module.put("width", (Object)(15.0 * bodyNode.width / 100.0));
        module.put("height", (Object)(15.0 * bodyNode.height / 100.0));
        module.put("alignment", (Object)DisclosureMiddleToJsonHelper.getBodyAlignment(bodyNode.alignment));
    }

    public static String getBodyAlignment(BodyNode.AlignmentEnum alignment) {
        String val = "2";
        if (alignment == BodyNode.AlignmentEnum.Left) {
            val = "1";
        } else if (alignment == BodyNode.AlignmentEnum.Right) {
            val = "3";
        }
        return val;
    }

    public static void createBoder(JSONObject module, BorderNode borderNode) {
        if (module == null || borderNode == null) {
            return;
        }
        JSONObject borderObj = new JSONObject();
        borderObj.put("visible", (Object)borderNode.visible);
        module.put("border", (Object)borderObj);
    }

    public static JSONObject createDataFormat(DataFormatNode dataFormatNode) {
        if (dataFormatNode == null) {
            return null;
        }
        if (dataFormatNode.decimalPlace < 0 || dataFormatNode.decimalPlace > 10) {
            dataFormatNode.decimalPlace = 2;
        }
        JSONObject dataFormat = new JSONObject();
        dataFormat.put("visible", (Object)dataFormatNode.visible);
        dataFormat.put("unit", (Object)dataFormatNode.unit.getType());
        dataFormat.put("thousandth", (Object)dataFormatNode.thousandth);
        dataFormat.put("currencysign", (Object)dataFormatNode.currencysign);
        dataFormat.put("numbertype", (Object)DisclosureMiddleToJsonHelper.getDataTypeEnum(dataFormatNode.dataType));
        dataFormat.put("showLegendKey", (Object)dataFormatNode.showLegendKey);
        dataFormat.put("showCategoryName", (Object)dataFormatNode.showCategoryName);
        dataFormat.put("showDisplayValue", (Object)dataFormatNode.showDisplayValue);
        dataFormat.put("showPercent", (Object)dataFormatNode.showPercent);
        dataFormat.put("showSeriesName", (Object)dataFormatNode.showSeriesName);
        dataFormat.put("decimal", (Object)dataFormatNode.decimalPlace);
        return dataFormat;
    }

    public static String getDataTypeEnum(DataFormatNode.DataTypeEnum dataTypeEnum) {
        String numberType = "1";
        if (dataTypeEnum.getType() == 1) {
            numberType = "2";
        } else if (dataTypeEnum.getType() == 2) {
            numberType = "3";
        }
        return numberType;
    }

    public static JSONObject createSort(SortNode sortNode) {
        String type = "";
        String customValue = "";
        if (sortNode != null) {
            type = sortNode.type == null ? "" : sortNode.type.getName();
            customValue = sortNode.customValue;
        }
        JSONObject sort = new JSONObject();
        sort.put("type", (Object)type);
        sort.put("customValue", (Object)customValue);
        return sort;
    }

    public static JSONObject createFontNode(FontNode fontNode) {
        if (fontNode == null) {
            return null;
        }
        JSONObject font = new JSONObject();
        font.put("size", (Object)fontNode.fontSize);
        font.put("color", (Object)fontNode.foreColor);
        font.put("underline", (Object)(fontNode.underline ? "underline" : ""));
        font.put("weight", (Object)(fontNode.bold ? "bold" : ""));
        font.put("style", (Object)(fontNode.italic ? "italic" : ""));
        return font;
    }
}

