/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle.helper;

import com.alibaba.fastjson.JSONObject;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.FontNode;
import kd.epm.far.business.common.module.middle.node.format.base.LegendNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;

public class PieMiddleConvertHelper {
    public static String getDataLabelEnum(DataFormatNode.DataLabelEnum dataLabelTypeEnum) {
        String dataLabelType = "outEnd";
        if (dataLabelTypeEnum.getType() == 1) {
            dataLabelType = "inEnd";
        }
        return dataLabelType;
    }

    public static DataFormatNode.DataLabelEnum getDataLabelEnumNode(String dataLabelType) {
        DataFormatNode.DataLabelEnum dataLabelTypeEnum = DataFormatNode.DataLabelEnum.outEnd;
        if ("inEnd".equalsIgnoreCase(dataLabelType)) {
            dataLabelTypeEnum = DataFormatNode.DataLabelEnum.inEnd;
        }
        return dataLabelTypeEnum;
    }

    public static JSONObject createLegend(LegendNode legendNode) {
        JSONObject legend = new JSONObject();
        legend.put("visible", (Object)legendNode.visible);
        legend.put("overlay", (Object)legendNode.overlay);
        legend.put("fontSize", (Object)(legendNode.font == null ? 12 : legendNode.font.fontSize));
        legend.put("position", (Object)PieMiddleConvertHelper.getLegendPosition(legendNode.position));
        return legend;
    }

    public static LegendNode createLegendNode(JSONObject legend) {
        LegendNode legendNode = new LegendNode();
        legendNode.visible = DisclosureJsonHelper.getValue(legend, "visible", true);
        legendNode.overlay = DisclosureJsonHelper.getValue(legend, "overlay", true);
        legendNode.font = new FontNode();
        legendNode.font.fontSize = DisclosureJsonHelper.getValue(legend, "fontSize", 12);
        legendNode.position = PieMiddleConvertHelper.getLegendPosition(DisclosureJsonHelper.getValue(legend, "position", "1"));
        return legendNode;
    }

    public static String getLegendPosition(LegendNode.Alignment position) {
        String val = "1";
        if (position == null) {
            return val;
        }
        if (position == LegendNode.Alignment.DownLeft || position == LegendNode.Alignment.DownCenter || position == LegendNode.Alignment.DownRight) {
            val = "2";
        } else if (position == LegendNode.Alignment.CenterLeft || position == LegendNode.Alignment.LeftUpDui) {
            val = "3";
        } else if (position == LegendNode.Alignment.CenterRight || position == LegendNode.Alignment.RightUpDui) {
            val = "4";
        } else if (position == LegendNode.Alignment.UpRight) {
            val = "5";
        }
        return val;
    }

    public static LegendNode.Alignment getLegendPosition(String position) {
        LegendNode.Alignment val = LegendNode.Alignment.DownCenter;
        if (position == null) {
            return val;
        }
        if (position.equalsIgnoreCase("2")) {
            val = LegendNode.Alignment.DownCenter;
        } else if (position.equalsIgnoreCase("3")) {
            val = LegendNode.Alignment.CenterLeft;
        } else if (position.equalsIgnoreCase("4")) {
            val = LegendNode.Alignment.CenterRight;
        } else if (position.equalsIgnoreCase("5")) {
            val = LegendNode.Alignment.UpRight;
        }
        return val;
    }
}

