/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.module.middle.node.format.base.LegendNode;
import kd.epm.far.business.common.module.middle.node.format.point.PointConditionNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;

public class PointMiddleConvertHelper {
    public static JSONArray createPointCondition(List<PointConditionNode> pointConditionNodes) {
        JSONArray conditions = new JSONArray();
        if (pointConditionNodes == null || pointConditionNodes.size() == 0) {
            return conditions;
        }
        for (PointConditionNode conditionNode : pointConditionNodes) {
            String condition = PointMiddleConvertHelper.getConditionEnum(conditionNode.condition);
            if (StringUtils.isEmpty((String)condition)) continue;
            JSONObject cObject = new JSONObject();
            cObject.put("color", (Object)conditionNode.color);
            cObject.put("value", (Object)conditionNode.value1);
            cObject.put("value2", (Object)conditionNode.value2);
            cObject.put("condition", (Object)condition);
            conditions.add((Object)cObject);
        }
        return conditions;
    }

    public static List<PointConditionNode> createPointConditionNode(JSONObject module) {
        ArrayList<PointConditionNode> pointConditionNodes = new ArrayList<PointConditionNode>(10);
        JSONArray conditions = DisclosureJsonHelper.getJSONArray(module, "dataPoint", "conditions");
        if (conditions == null || conditions.size() == 0) {
            return pointConditionNodes;
        }
        for (Object c : conditions) {
            JSONObject cObject = (JSONObject)c;
            if (cObject == null) continue;
            String color = cObject.getString("color");
            String value = cObject.getString("value");
            String value2 = cObject.getString("value2");
            String condition = cObject.getString("condition");
            PointConditionNode.ConditionEnum conditionEnum = PointMiddleConvertHelper.getConditionEnumNode(condition);
            if (conditionEnum == null) continue;
            PointConditionNode pointConditionNode = new PointConditionNode();
            pointConditionNode.condition = conditionEnum;
            pointConditionNode.color = color;
            pointConditionNode.value1 = value;
            pointConditionNode.value2 = value2;
            pointConditionNodes.add(pointConditionNode);
        }
        return pointConditionNodes;
    }

    public static PointConditionNode.ConditionEnum getConditionEnumNode(String condition) {
        if (StringUtils.isEmpty((String)condition)) {
            return null;
        }
        for (PointConditionNode.ConditionEnum item : PointConditionNode.ConditionEnum.values()) {
            if (!item.getType().equalsIgnoreCase(condition)) continue;
            return item;
        }
        return null;
    }

    public static String getConditionEnum(PointConditionNode.ConditionEnum position) {
        if (position == null) {
            return null;
        }
        return position.getType();
    }

    public static LegendNode.Alignment getLegendPosition(String position) {
        LegendNode.Alignment val = LegendNode.Alignment.DownCenter;
        if (position == null) {
            return val;
        }
        if (position.equalsIgnoreCase("2")) {
            val = LegendNode.Alignment.DownCenter;
        } else if (position.equalsIgnoreCase("3")) {
            val = LegendNode.Alignment.CenterLeft;
        } else if (position.equalsIgnoreCase("4")) {
            val = LegendNode.Alignment.CenterRight;
        } else if (position.equalsIgnoreCase("5")) {
            val = LegendNode.Alignment.UpRight;
        }
        return val;
    }
}

