/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.module.middle.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.epm.far.business.common.module.middle.node.format.base.FontNode;
import kd.epm.far.business.common.module.middle.node.layout.table.TableColumnNode;
import kd.epm.far.business.common.module.middle.node.layout.table.TableDisplayNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureJsonToMiddleHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;

public class TableMiddleConvertHelper {
    public static List<TableColumnNode> getTableColumnNodes(JSONObject module) {
        ArrayList<TableColumnNode> tableColumnNodes = new ArrayList<TableColumnNode>(1);
        if (module == null) {
            return tableColumnNodes;
        }
        JSONArray property = DisclosureJsonHelper.getJSONArray(module, "table", "property");
        if (property == null || property.size() == 0) {
            return tableColumnNodes;
        }
        for (Object itemObject : property) {
            JSONObject column = (JSONObject)itemObject;
            TableColumnNode.ColTypeEnum colTypeEnum = TableMiddleConvertHelper.getConditionEnum(column.getString("col_type"));
            if (colTypeEnum == null) continue;
            TableColumnNode columnNode = new TableColumnNode();
            columnNode.number = column.getString("column");
            columnNode.name = column.getString("column_default_name");
            columnNode.rename = column.getString("column_name");
            columnNode.type = colTypeEnum;
            columnNode.sort = DisclosureJsonToMiddleHelper.createSortNode(DisclosureJsonHelper.getJsonObject(column, "sort"));
            columnNode.prefix = column.getString("prefix");
            columnNode.suffix = column.getString("suffix");
            columnNode.visible = column.getBoolean("show");
            columnNode.width = column.getDouble("column_width");
            tableColumnNodes.add(columnNode);
        }
        return tableColumnNodes;
    }

    public static JSONArray getTableColumns(List<TableColumnNode> tableColumnNodes) {
        JSONArray columns = new JSONArray();
        if (tableColumnNodes == null || tableColumnNodes.size() == 0) {
            return columns;
        }
        for (TableColumnNode columnNode : tableColumnNodes) {
            JSONObject sort;
            JSONObject column = new JSONObject();
            column.put("column", (Object)columnNode.number);
            column.put("column_default_name", (Object)columnNode.name);
            column.put("column_name", (Object)columnNode.rename);
            column.put("prefix", (Object)columnNode.prefix);
            column.put("suffix", (Object)columnNode.suffix);
            column.put("show", (Object)columnNode.visible);
            column.put("col_type", (Object)TableMiddleConvertHelper.getColTypeEnumNode(columnNode.type));
            if (columnNode.width != null) {
                column.put("column_width", (Object)columnNode.width);
            }
            if ((sort = DisclosureMiddleToJsonHelper.createSort(columnNode.sort)) != null) {
                column.put("sort", (Object)sort);
            }
            columns.add((Object)column);
        }
        return columns;
    }

    public static String getColTypeEnumNode(TableColumnNode.ColTypeEnum colTypeEnum) {
        if (colTypeEnum == null) {
            return "1";
        }
        if (colTypeEnum.getType().equalsIgnoreCase("2")) {
            return "2";
        }
        return "1";
    }

    public static TableColumnNode.ColTypeEnum getConditionEnum(String colType) {
        if (colType == null) {
            return null;
        }
        for (TableColumnNode.ColTypeEnum item : TableColumnNode.ColTypeEnum.values()) {
            if (!item.getType().equalsIgnoreCase(colType)) continue;
            return item;
        }
        return null;
    }

    public static TableDisplayNode getTableDisplayNode(JSONObject module) {
        TableDisplayNode displayNode = new TableDisplayNode();
        JSONObject columnVisible = DisclosureJsonHelper.getJsonObject(module, "table", "columnVisible");
        if (columnVisible == null) {
            return displayNode;
        }
        displayNode.top = DisclosureJsonHelper.getValue(columnVisible, "top", false);
        displayNode.prefix = DisclosureJsonHelper.getValue(columnVisible, "prefix", true);
        displayNode.suffix = DisclosureJsonHelper.getValue(columnVisible, "suffix", true);
        displayNode.rename = DisclosureJsonHelper.getValue(columnVisible, "column_name", true);
        displayNode.show = DisclosureJsonHelper.getValue(columnVisible, "show", true);
        displayNode.width = DisclosureJsonHelper.getValue(columnVisible, "column_width", true);
        displayNode.sort = DisclosureJsonHelper.getValue(columnVisible, "sort", false);
        displayNode.priority = DisclosureJsonHelper.getValue(columnVisible, "priority", false);
        return displayNode;
    }

    public static JSONObject getTableDisplay(TableDisplayNode displayNode) {
        JSONObject columnVisible = new JSONObject();
        if (displayNode == null) {
            return null;
        }
        columnVisible.put("top", (Object)displayNode.top);
        columnVisible.put("prefix", (Object)displayNode.prefix);
        columnVisible.put("suffix", (Object)displayNode.suffix);
        columnVisible.put("column_name", (Object)displayNode.rename);
        columnVisible.put("show", (Object)displayNode.show);
        columnVisible.put("column_width", (Object)displayNode.width);
        columnVisible.put("sort", (Object)displayNode.sort);
        columnVisible.put("priority", (Object)displayNode.priority);
        return columnVisible;
    }

    public static FontNode.AlignmentEnum getAlignmentEnum(String align) {
        FontNode.AlignmentEnum alignmentEnum = FontNode.AlignmentEnum.Left;
        if (align == null) {
            return alignmentEnum;
        }
        if ("center".equalsIgnoreCase(align)) {
            alignmentEnum = FontNode.AlignmentEnum.Center;
        } else if ("right".equalsIgnoreCase(align)) {
            alignmentEnum = FontNode.AlignmentEnum.Right;
        }
        return alignmentEnum;
    }

    public static String getAlignmentEnum(FontNode.AlignmentEnum alignmentEnum) {
        String align = "left";
        if (alignmentEnum == null) {
            return align;
        }
        if (FontNode.AlignmentEnum.Center.getType() == alignmentEnum.getType()) {
            align = "center";
        } else if (FontNode.AlignmentEnum.Right.getType() == alignmentEnum.getType()) {
            align = "right";
        }
        return align;
    }
}

