/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.perm;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.fidm.base.DisclosureTreeHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.LongUtil;

public class PermClassBaseHelper {
    public static List<Long> getNoPermIds(Long dmModelId, String appType, String entityName) {
        ArrayList<Long> noPermIds = new ArrayList<Long>();
        noPermIds.addAll(PermClassEntityHelper.getDiscPermissionMap(entityName, dmModelId, LongUtil.toLong((Object)RequestContext.get().getUserId()), appType).get((Object)DataTypeEnum.NO.getIndex()));
        return noPermIds;
    }

    public static List<Long> getReadOnlyIds(Long dmModelId, String appType, String entityName) {
        ArrayList<Long> readOnlyPerms = new ArrayList<Long>();
        readOnlyPerms.addAll(PermClassEntityHelper.getDiscPermissionMap(entityName, dmModelId, LongUtil.toLong((Object)RequestContext.get().getUserId()), appType).get((Object)DataTypeEnum.READ.getIndex()));
        return readOnlyPerms;
    }

    public static List<Long> getReadOnlyAndNoPermIds(Long dmModelId, String appType, String entityName) {
        ArrayListMultimap<String, Long> permMap = PermClassEntityHelper.getDiscPermissionMap(entityName, dmModelId, LongUtil.toLong((Object)RequestContext.get().getUserId()), appType);
        ArrayList<Long> readOnlyPerms = new ArrayList<Long>();
        readOnlyPerms.addAll(permMap.get((Object)DataTypeEnum.NO.getIndex()));
        readOnlyPerms.addAll(permMap.get((Object)DataTypeEnum.READ.getIndex()));
        return readOnlyPerms;
    }

    public static void setReadOnly(Long dmModelId, String appType, String entityName, List<DisclosureTreeDto> rootList, String rootId) {
        List<Long> readOnlyIds = PermClassBaseHelper.getReadOnlyIds(dmModelId, appType, entityName);
        DisclosureTreeHelper.setReadOnly(rootList, rootId, readOnlyIds.stream().map(m -> m.toString()).collect(Collectors.toList()));
    }

    public static boolean isNoPerm(String perm) {
        return DataTypeEnum.NO.getIndex().equalsIgnoreCase(perm);
    }

    public static boolean isReadPerm(String perm) {
        return DataTypeEnum.READ.getIndex().equalsIgnoreCase(perm);
    }

    public static Map<Long, String> getChapterPermMap(Long dmModelId, List<Long> chapterIds, String parentPerm) {
        LinkedHashMap<Long, String> chapterPermMap = new LinkedHashMap<Long, String>(chapterIds.size());
        if (DataTypeEnum.NO.getIndex().equalsIgnoreCase(parentPerm)) {
            for (Long chapterId : chapterIds) {
                chapterPermMap.put(chapterId, DataTypeEnum.NO.getIndex());
            }
            return chapterPermMap;
        }
        ArrayListMultimap<String, Long> allPermIds = PermClassEntityHelper.getDiscPermissionMap("fidm_chapter", dmModelId, LongUtil.toLong((Object)RequestContext.get().getUserId()), "fidm");
        List noPermIds = allPermIds.get((Object)DataTypeEnum.NO.getIndex());
        List readOnlyPermIds = allPermIds.get((Object)DataTypeEnum.READ.getIndex());
        for (Long chapterId : chapterIds) {
            if (noPermIds.contains(chapterId)) {
                chapterPermMap.put(chapterId, DataTypeEnum.NO.getIndex());
                continue;
            }
            if (DataTypeEnum.READ.getIndex().equalsIgnoreCase(parentPerm)) {
                chapterPermMap.put(chapterId, DataTypeEnum.READ.getIndex());
                continue;
            }
            if (readOnlyPermIds.contains(chapterId)) {
                chapterPermMap.put(chapterId, DataTypeEnum.READ.getIndex());
                continue;
            }
            chapterPermMap.put(chapterId, DataTypeEnum.WRITEIN.getIndex());
        }
        return chapterPermMap;
    }
}

