/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.perm;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.fidm.base.DisclosureTreeHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class PermClassChapterRepositoryHelper {
    public static List<DisclosureTreeDto> getChapterRepositoryList(Long dmModelId) {
        List catalogExs = (List)ThreadCache.get((Object)(CacheKey.BasePrefixString + dmModelId + "_getChapterRepositoryList"), () -> {
            List<QFilter> qFilters = PermClassChapterRepositoryHelper.getChapterRepositoryCatalogFilters(dmModelId);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_chaptergroup", (String)"id,name,number,parent,parent.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence");
            ArrayList<DisclosureTreeDto> catalogs = new ArrayList<DisclosureTreeDto>(dys.size());
            for (DynamicObject dy : dys) {
                DisclosureTreeDto catalog = new DisclosureTreeDto();
                catalog.setId(dy.getString("id"));
                catalog.setNumber(dy.getString("number"));
                catalog.setName(dy.getString("name"));
                catalog.setParentId(dy.getString("parent.id"));
                catalogs.add(catalog);
            }
            DisclosureTreeDto rootDto = DisclosureTreeHelper.getRoot(catalogs);
            if (rootDto != null) {
                PermClassBaseHelper.setReadOnly(dmModelId, "fidm", "fidm_chaptergroup", catalogs, rootDto.getId());
            }
            return catalogs;
        });
        return catalogExs;
    }

    public static List<QFilter> getChapterRepositoryCatalogdWritePermFilter(Long dmModelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)dmModelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        List<Long> permIds = PermClassBaseHelper.getReadOnlyAndNoPermIds(dmModelId, "fidm", "fidm_chaptergroup");
        if (permIds.size() > 0) {
            qFilters.add(new QFilter("id", "not in", permIds));
        }
        return qFilters;
    }

    public static List<QFilter> getChapterRepositoryCatalogFilters(Long dmModelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)dmModelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        QFilter permqFilter = PermissionHelper.getReadAndWritePermFilter(dmModelId, "fidm_chaptergroup");
        qFilters.add(permqFilter);
        return qFilters;
    }

    public static List<QFilter> getChapterRepositoryListFilters(Long dmModelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)dmModelId));
        qFilters.add(new QFilter("template", "=", (Object)0));
        qFilters.add(new QFilter("group", "!=", (Object)0));
        List<QFilter> catalogFilters = PermClassChapterRepositoryHelper.getChapterRepositoryCatalogFilters(dmModelId);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_chaptergroup", (String)"id", (QFilter[])catalogFilters.toArray(new QFilter[0]), (String)"sequence");
        List catalogs = dys.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        if (catalogs.size() > 0) {
            qFilters.add(new QFilter("group", "in", catalogs));
        }
        QFilter permqFilter = PermissionHelper.getReadAndWritePermFilter(dmModelId, "fidm_chapter");
        qFilters.add(permqFilter);
        return qFilters;
    }

    public static Map<Long, String> getChapterRepositoryPermMap(Long dmModelId, List<Long> chapterIds) {
        LinkedHashMap<Long, String> chapterPermMap = new LinkedHashMap<Long, String>(chapterIds.size());
        Map<Long, Long> cateLogLMap = PermClassChapterRepositoryHelper.getCataLogList(chapterIds);
        List<DisclosureTreeDto> cateLogList = PermClassChapterRepositoryHelper.getChapterRepositoryList(dmModelId);
        ArrayListMultimap<String, Long> allPermIds = PermClassEntityHelper.getDiscPermissionMap("fidm_chapter", dmModelId, LongUtil.toLong((Object)RequestContext.get().getUserId()), "fidm");
        List noPermIds = allPermIds.get((Object)DataTypeEnum.NO.getIndex());
        List readOnlyPermIds = allPermIds.get((Object)DataTypeEnum.READ.getIndex());
        for (Map.Entry<Long, Long> cateEntry : cateLogLMap.entrySet()) {
            Long chapterId = cateEntry.getKey();
            Long cateLogId = cateEntry.getValue();
            if (noPermIds.contains(chapterId)) {
                chapterPermMap.put(chapterId, DataTypeEnum.NO.getIndex());
                continue;
            }
            DisclosureTreeDto treeDto = DisclosureTreeHelper.findDtoById(cateLogList, cateLogId.toString());
            if (treeDto != null) {
                if (DataTypeEnum.READ.getIndex().equalsIgnoreCase(treeDto.getPermClassType())) {
                    chapterPermMap.put(chapterId, DataTypeEnum.READ.getIndex());
                    continue;
                }
                if (DataTypeEnum.NO.getIndex().equalsIgnoreCase(treeDto.getPermClassType())) {
                    chapterPermMap.put(chapterId, DataTypeEnum.NO.getIndex());
                    continue;
                }
            }
            if (readOnlyPermIds.contains(chapterId)) {
                chapterPermMap.put(chapterId, DataTypeEnum.READ.getIndex());
                continue;
            }
            chapterPermMap.put(chapterId, DataTypeEnum.WRITEIN.getIndex());
        }
        return chapterPermMap;
    }

    public static String getChapterRepositoryPerm(Long dmModelId, Long chapterId) {
        DynamicObject chapterDy = DisclosureChapterHelper.getChapter(chapterId, false);
        if (chapterDy == null) {
            return DataTypeEnum.NO.getIndex();
        }
        Map<Long, String> chapterPermMap = PermClassChapterRepositoryHelper.getChapterRepositoryPermMap(dmModelId, Collections.singletonList(chapterId));
        String perm = chapterPermMap.get(chapterId);
        if (perm == null) {
            return DataTypeEnum.NO.getIndex();
        }
        return perm;
    }

    private static Map<Long, Long> getCataLogList(Collection<Long> chapterIds) {
        String selectField = "id,group.id";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("id", "in", chapterIds));
        DynamicObjectCollection chapters = QueryServiceHelper.query((String)"fidm_chapter", (String)selectField, (QFilter[])qfBuilder.toArray());
        HashMap<Long, Long> catelogMap = new HashMap<Long, Long>(chapters.size());
        for (DynamicObject dy : chapters) {
            catelogMap.put(dy.getLong("id"), dy.getLong("group.id"));
        }
        return catelogMap;
    }
}

