/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.perm;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class PermClassReportHelper {
    public static List<DisclosureTreeDto> getReportTreeList(Long dmModelId, String catalogtype) {
        List<DisclosureTreeDto> catalogs = PermClassTemplateHelper.getTemplateCatalogList(dmModelId, catalogtype);
        HashMap<String, DisclosureTreeDto> catalogMap = new HashMap<String, DisclosureTreeDto>(catalogs.size());
        for (DisclosureTreeDto catalog : catalogs) {
            catalog.setType("catalog");
            catalog.setIcon("kdfont kdfont-wenjianjia");
            catalogMap.put(catalog.getId(), catalog);
        }
        String appId = AppCatalogTypeEnum.getByType(catalogtype).getAppId();
        ArrayListMultimap<String, Long> allPermIds = PermClassEntityHelper.getDiscPermissionMap("fidm_template", dmModelId, LongUtil.toLong((Object)RequestContext.get().getUserId()), appId);
        List noPermIds = allPermIds.get((Object)DataTypeEnum.NO.getIndex());
        List readOnlyPermIds = allPermIds.get((Object)DataTypeEnum.READ.getIndex());
        QFilter qFilter = new QFilter("model", "=", (Object)dmModelId);
        if (noPermIds.size() > 0) {
            qFilter.and(new QFilter("id", "not in", (Object)noPermIds));
        }
        List cataLogIds = catalogs.stream().map(m -> LongUtil.toLong((Object)m.getId())).collect(Collectors.toList());
        qFilter.and(new QFilter("templatecatalog", "in", cataLogIds));
        DynamicObjectCollection templateDys = QueryServiceHelper.query((String)"fidm_template", (String)"id,name,number,templatecatalog", (QFilter[])qFilter.toArray(), (String)"sequence asc, number asc");
        ArrayList<DisclosureTreeDto> templateList = new ArrayList<DisclosureTreeDto>(templateDys.size());
        for (DynamicObject dy : templateDys) {
            DisclosureTreeDto template = new DisclosureTreeDto();
            template.setId(dy.getString("id"));
            template.setNumber(dy.getString("number"));
            template.setName(dy.getString("name"));
            template.setParentId(dy.getString("templatecatalog"));
            template.setType("template");
            templateList.add(template);
        }
        for (DisclosureTreeDto template : templateList) {
            Long templateId = LongUtil.toLong((Object)template.getId());
            if (noPermIds.contains(templateId)) {
                template.setPermClassType(DataTypeEnum.NO.getIndex());
                continue;
            }
            DisclosureTreeDto catalog = (DisclosureTreeDto)catalogMap.get(template.getParentId());
            if (catalog != null) {
                if (DataTypeEnum.READ.getIndex().equalsIgnoreCase(catalog.getPermClassType())) {
                    template.setPermClassType(DataTypeEnum.READ.getIndex());
                    continue;
                }
                if (DataTypeEnum.NO.getIndex().equalsIgnoreCase(catalog.getPermClassType())) {
                    template.setPermClassType(DataTypeEnum.NO.getIndex());
                    continue;
                }
            }
            if (!readOnlyPermIds.contains(templateId)) continue;
            template.setPermClassType(DataTypeEnum.READ.getIndex());
        }
        if (templateList.size() > 0) {
            catalogs.addAll(templateList);
        }
        return catalogs;
    }

    public static Map<Long, String> getReportPermMap(Long dmModelId, List<Long> reportIds) {
        LinkedHashMap<Long, String> reportPermMap = new LinkedHashMap<Long, String>(reportIds.size());
        Map<Long, Long> reportTemplateMap = PermClassReportHelper.getTemplatesByReportIds(reportIds);
        Map<Long, String> templatePermMap = PermClassTemplateHelper.getTemplatePermMap(dmModelId, reportTemplateMap.values());
        ArrayListMultimap<String, Long> allPermIds = PermClassEntityHelper.getDiscPermissionMap("fidm_report", dmModelId, LongUtil.toLong((Object)RequestContext.get().getUserId()), "fidm");
        List noPermIds = allPermIds.get((Object)DataTypeEnum.NO.getIndex());
        List readOnlyPermIds = allPermIds.get((Object)DataTypeEnum.READ.getIndex());
        for (Map.Entry<Long, Long> cateEntry : reportTemplateMap.entrySet()) {
            Long reportId = cateEntry.getKey();
            Long templateId = cateEntry.getValue();
            if (noPermIds.contains(reportId)) {
                reportPermMap.put(reportId, DataTypeEnum.NO.getIndex());
                continue;
            }
            String templatePerm = templatePermMap.get(templateId);
            if (templatePerm != null) {
                if (DataTypeEnum.READ.getIndex().equalsIgnoreCase(templatePerm)) {
                    reportPermMap.put(reportId, DataTypeEnum.READ.getIndex());
                    continue;
                }
                if (DataTypeEnum.NO.getIndex().equalsIgnoreCase(templatePerm)) {
                    reportPermMap.put(reportId, DataTypeEnum.NO.getIndex());
                    continue;
                }
            }
            if (readOnlyPermIds.contains(reportId)) {
                reportPermMap.put(reportId, DataTypeEnum.READ.getIndex());
                continue;
            }
            reportPermMap.put(reportId, DataTypeEnum.WRITEIN.getIndex());
        }
        return reportPermMap;
    }

    private static Map<Long, Long> getTemplatesByReportIds(List<Long> reportIds) {
        String selectField = "id,template.id";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("id", "in", reportIds));
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"fidm_report", (String)selectField, (QFilter[])qfBuilder.toArray());
        HashMap<Long, Long> catelogMap = new HashMap<Long, Long>(templates.size());
        for (DynamicObject dy : templates) {
            catelogMap.put(dy.getLong("id"), dy.getLong("template.id"));
        }
        return catelogMap;
    }

    public static String getReportPerm(Long reportId) {
        String permEx = (String)ThreadCache.get((Object)(CacheKey.BasePrefixString + reportId + "_getReportPerm"), () -> {
            DynamicObject report = DisclosureReportHelper.getReport(reportId, false);
            if (report == null) {
                return DataTypeEnum.NO.getIndex();
            }
            Long dmModelId = report.getLong("model.id");
            Map<Long, String> reportPermMap = PermClassReportHelper.getReportPermMap(dmModelId, Collections.singletonList(reportId));
            String perm = reportPermMap.get(reportId);
            if (perm == null) {
                return DataTypeEnum.NO.getIndex();
            }
            return perm;
        });
        return permEx;
    }

    public static Map<Long, String> getChapterPermMapByReport(Long dmModelId, Long reportId) {
        Map permEx = (Map)ThreadCache.get((Object)(CacheKey.BasePrefixString + reportId + "_getChapterPermMapByReport"), () -> {
            LinkedHashMap chapterPermMap = new LinkedHashMap(10);
            List<Long> chapterIds = DisclosureReportHelper.getChapterInfoByReport(reportId);
            if (chapterIds.size() == 0) {
                return chapterPermMap;
            }
            String reportPerm = PermClassReportHelper.getReportPerm(reportId);
            return PermClassBaseHelper.getChapterPermMap(dmModelId, chapterIds, reportPerm);
        });
        return permEx;
    }

    public static List<Long> getValiadChaptersByReport(Long dmModelId, Long reportId) {
        Map<Long, String> chapterPermMap = PermClassReportHelper.getChapterPermMapByReport(dmModelId, reportId);
        ArrayList<Long> chapterIds = new ArrayList<Long>(chapterPermMap.size());
        for (Map.Entry<Long, String> chapterEntry : chapterPermMap.entrySet()) {
            Long chapterId = chapterEntry.getKey();
            String perm = chapterEntry.getValue();
            if (DataTypeEnum.NO.getIndex().equalsIgnoreCase(perm)) continue;
            chapterIds.add(chapterId);
        }
        return chapterIds;
    }

    public static String getReportChapterPerm(Long dmModelId, Long reportId, Long chapterId) {
        String permEx = (String)ThreadCache.get((Object)(CacheKey.BasePrefixString + reportId + "_getReportChapterPerm"), () -> {
            Map<Long, String> chapterPermMap = PermClassReportHelper.getChapterPermMapByReport(dmModelId, reportId);
            String perm = chapterPermMap.get(chapterId);
            if (perm == null) {
                return DataTypeEnum.NO.getIndex();
            }
            return perm;
        });
        return permEx;
    }
}

