/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.perm;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.fidm.base.DisclosureTreeHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class PermClassTemplateHelper {
    public static List<DisclosureTreeDto> getTemplateCatalogList(Long dmModelId, String catalogtype) {
        List catalogExs = (List)ThreadCache.get((Object)(CacheKey.BasePrefixString + dmModelId + "_getTemplateCatalogList"), () -> {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter("model", "=", (Object)dmModelId));
            qFilters.add(new QFilter("catalogtype", "=", (Object)catalogtype));
            QFilter permqFilter = PermissionHelper.getReadAndWritePermFilter(dmModelId, "fidm_tmplcatalog");
            qFilters.add(permqFilter);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_tmplcatalog", (String)"id,name,number,parent,parent.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence");
            ArrayList<DisclosureTreeDto> catalogs = new ArrayList<DisclosureTreeDto>(dys.size());
            for (DynamicObject dy : dys) {
                DisclosureTreeDto catalog = new DisclosureTreeDto();
                catalog.setId(dy.getString("id"));
                catalog.setNumber(dy.getString("number"));
                catalog.setName(dy.getString("name"));
                catalog.setParentId(dy.getString("parent.id"));
                catalogs.add(catalog);
            }
            DisclosureTreeDto rootDto = DisclosureTreeHelper.getRoot(catalogs);
            if (rootDto != null) {
                PermClassBaseHelper.setReadOnly(dmModelId, "fidm", "fidm_tmplcatalog", catalogs, rootDto.getId());
            }
            return catalogs;
        });
        return catalogExs;
    }

    public static String getTemplatePerm(Long templateId) {
        String permEx = (String)ThreadCache.get((Object)(CacheKey.BasePrefixString + templateId + "_getTemplatePerm"), () -> {
            DynamicObject template = DisclosureTemplateHelper.getTemplate(templateId, false);
            if (template == null) {
                return DataTypeEnum.NO.getIndex();
            }
            Long dmModelId = template.getLong("model.id");
            Map<Long, String> templatePermMap = PermClassTemplateHelper.getTemplatePermMap(dmModelId, Collections.singletonList(templateId));
            String perm = templatePermMap.get(templateId);
            if (perm == null) {
                return DataTypeEnum.NO.getIndex();
            }
            return perm;
        });
        return permEx;
    }

    public static Map<Long, String> getTemplatePermMap(Long dmModelId, Collection<Long> templateIds) {
        LinkedHashMap<Long, String> templatePermMap = new LinkedHashMap<Long, String>(templateIds.size());
        Map<Long, Long> cateLogLMap = PermClassTemplateHelper.getTemplateCataLogList(templateIds);
        List<DisclosureTreeDto> cateLogList = PermClassTemplateHelper.getTemplateCatalogList(dmModelId, AppCatalogTypeEnum.FIDM_CATALOG.getType());
        ArrayListMultimap<String, Long> allPermIds = PermClassEntityHelper.getDiscPermissionMap("fidm_template", dmModelId, LongUtil.toLong((Object)RequestContext.get().getUserId()), "fidm");
        List noPermIds = allPermIds.get((Object)DataTypeEnum.NO.getIndex());
        List readOnlyPermIds = allPermIds.get((Object)DataTypeEnum.READ.getIndex());
        for (Map.Entry<Long, Long> cateEntry : cateLogLMap.entrySet()) {
            Long templateId = cateEntry.getKey();
            Long cateLogId = cateEntry.getValue();
            if (noPermIds.contains(templateId)) {
                templatePermMap.put(templateId, DataTypeEnum.NO.getIndex());
                continue;
            }
            DisclosureTreeDto treeDto = DisclosureTreeHelper.findDtoById(cateLogList, cateLogId.toString());
            if (treeDto != null) {
                if (DataTypeEnum.READ.getIndex().equalsIgnoreCase(treeDto.getPermClassType())) {
                    templatePermMap.put(templateId, DataTypeEnum.READ.getIndex());
                    continue;
                }
                if (DataTypeEnum.NO.getIndex().equalsIgnoreCase(treeDto.getPermClassType())) {
                    templatePermMap.put(templateId, DataTypeEnum.NO.getIndex());
                    continue;
                }
            }
            if (readOnlyPermIds.contains(templateId)) {
                templatePermMap.put(templateId, DataTypeEnum.READ.getIndex());
                continue;
            }
            templatePermMap.put(templateId, DataTypeEnum.WRITEIN.getIndex());
        }
        return templatePermMap;
    }

    private static Map<Long, Long> getTemplateCataLogList(Collection<Long> templateIds) {
        String selectField = "id,templatecatalog.id";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("id", "in", templateIds));
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"fidm_template", (String)selectField, (QFilter[])qfBuilder.toArray());
        HashMap<Long, Long> catelogMap = new HashMap<Long, Long>(templates.size());
        for (DynamicObject dy : templates) {
            catelogMap.put(dy.getLong("id"), dy.getLong("templatecatalog.id"));
        }
        return catelogMap;
    }

    public static Map<Long, String> getChapterPermMap(Long dmModelId, Long templateId) {
        Map permEx = (Map)ThreadCache.get((Object)(CacheKey.BasePrefixString + templateId + "_getChapterPermMap"), () -> {
            LinkedHashMap chapterPermMap = new LinkedHashMap(10);
            List<Long> chapterIds = DisclosureTemplateHelper.getChapterInfoByTemplate(templateId);
            if (chapterIds.size() == 0) {
                return chapterPermMap;
            }
            String templatePerm = PermClassTemplateHelper.getTemplatePerm(templateId);
            return PermClassBaseHelper.getChapterPermMap(dmModelId, chapterIds, templatePerm);
        });
        return permEx;
    }

    public static List<Long> getValiadChaptersByTemplate(Long dmModelId, Long templateId) {
        Map<Long, String> chapterPermMap = PermClassTemplateHelper.getChapterPermMap(dmModelId, templateId);
        ArrayList<Long> chapterIds = new ArrayList<Long>(chapterPermMap.size());
        for (Map.Entry<Long, String> chapterEntry : chapterPermMap.entrySet()) {
            Long chapterId = chapterEntry.getKey();
            String perm = chapterEntry.getValue();
            if (DataTypeEnum.NO.getIndex().equalsIgnoreCase(perm)) continue;
            chapterIds.add(chapterId);
        }
        return chapterIds;
    }
}

