/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.report;

import com.alibaba.fastjson.JSONObject;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.report.dto.GenerateInputFormular;

public class DisclosureGenerateModuleHelper {
    public static void resetModuleProperty(GenerateInputFormular generateInputFormula, JSONObject module) {
        if (module == null) {
            return;
        }
        if (generateInputFormula == null) {
            return;
        }
        String moduleType = module.getString("type");
        if (!generateInputFormula.getModuleRange().contains(moduleType)) {
            return;
        }
        if (ModuleEnum.VAR.getType().equalsIgnoreCase(moduleType)) {
            DisclosureGenerateModuleHelper.resetVar(generateInputFormula, module);
        } else if (ModuleEnum.PIE.getType().equalsIgnoreCase(moduleType) || ModuleEnum.DOUGHNUT.getType().equalsIgnoreCase(moduleType)) {
            DisclosureGenerateModuleHelper.resetPie(generateInputFormula, module);
        } else if (ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.STACKED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType) || ModuleEnum.LINE.getType().equals(moduleType) || ModuleEnum.AREA.getType().equals(moduleType)) {
            DisclosureGenerateModuleHelper.resetBar(generateInputFormula, module);
        } else if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equals(moduleType)) {
            DisclosureGenerateModuleHelper.resetLineColumnar(generateInputFormula, module);
        } else if (ModuleEnum.TABLE.getType().equals(moduleType)) {
            DisclosureGenerateModuleHelper.resetTable(generateInputFormula, module);
        } else if (ModuleEnum.REPORT_SECTION.getType().equals(moduleType)) {
            DisclosureGenerateModuleHelper.resetReportSection(generateInputFormula, module);
        }
    }

    private static void resetReportSection(GenerateInputFormular generateInputFormula, JSONObject module) {
        if (StringUtils.isEmpty((String)generateInputFormula.getUnit()) || "0".equalsIgnoreCase(generateInputFormula.getUnit())) {
            return;
        }
        if (!DataPatternEnum.containsType(generateInputFormula.getUnit())) {
            return;
        }
        if (generateInputFormula.getDecimal() > 10 || generateInputFormula.getDecimal() < 0) {
            return;
        }
        JSONObject reportSection = DisclosureJsonHelper.getJsonObject(module, "reportSection");
        if (reportSection == null) {
            return;
        }
        JSONObject styleData = reportSection.getJSONObject("styleData");
        if (styleData == null) {
            styleData = new JSONObject();
            reportSection.put("styleData", (Object)styleData);
        }
        styleData.put("unit", (Object)generateInputFormula.getUnit());
        if (generateInputFormula.getDecimalEnable()) {
            styleData.put("decimal", (Object)generateInputFormula.getDecimal());
        }
    }

    private static void resetVar(GenerateInputFormular generateInputFormula, JSONObject module) {
        JSONObject dataPoint = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "dataPoint");
        if (dataPoint != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, dataPoint);
        }
    }

    private static void resetPie(GenerateInputFormular generateInputFormula, JSONObject module) {
        JSONObject pie = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "pie");
        if (pie != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, pie);
        }
    }

    private static void resetTable(GenerateInputFormular generateInputFormula, JSONObject module) {
        JSONObject table = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "table");
        if (table != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, table);
        }
    }

    private static void resetBar(GenerateInputFormular generateInputFormula, JSONObject module) {
        JSONObject yDataFormat1;
        JSONObject y1 = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "y1");
        if (y1 != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, y1);
        }
        if ((yDataFormat1 = DisclosureJsonHelper.getJsonObject(module, "axis", "y1", "dataFormat")) != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, yDataFormat1);
        }
    }

    private static void resetLineColumnar(GenerateInputFormular generateInputFormula, JSONObject module) {
        JSONObject yDataFormat2;
        JSONObject yDataFormat1;
        JSONObject y2;
        JSONObject y1 = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "y1");
        if (y1 != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, y1);
        }
        if ((y2 = DisclosureJsonHelper.getJsonObject(module, "dataFormat", "y2")) != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, y2);
        }
        if ((yDataFormat1 = DisclosureJsonHelper.getJsonObject(module, "axis", "y1", "dataFormat")) != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, yDataFormat1);
        }
        if ((yDataFormat2 = DisclosureJsonHelper.getJsonObject(module, "axis", "y2", "dataFormat")) != null) {
            DisclosureGenerateModuleHelper.resetDataFormart(generateInputFormula, yDataFormat2);
        }
    }

    private static void resetDataFormart(GenerateInputFormular generateInputFormula, JSONObject dataFormatChild) {
        if (StringUtils.isEmpty((String)generateInputFormula.getUnit()) || "0".equalsIgnoreCase(generateInputFormula.getUnit())) {
            return;
        }
        if (!DataPatternEnum.containsType(generateInputFormula.getUnit())) {
            return;
        }
        if (generateInputFormula.getDecimal() > 10 || generateInputFormula.getDecimal() < 0) {
            return;
        }
        String numbertype = dataFormatChild.getString("numbertype");
        if ("1".equalsIgnoreCase(numbertype) || "2".equalsIgnoreCase(numbertype)) {
            dataFormatChild.put("unit", (Object)generateInputFormula.getUnit());
            if (generateInputFormula.getDecimalEnable()) {
                dataFormatChild.put("decimal", (Object)generateInputFormula.getDecimal());
            }
        }
    }
}

