/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.report;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.MyReportStatusEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.base.ICopyOperation;
import kd.epm.far.business.fidm.chapter.DisclosureCopyHelper;
import kd.epm.far.business.fidm.chapter.dto.ChapterModuleCopyResult;
import kd.epm.far.business.fidm.design.DisclosurePreviewService;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.dto.PreviewResult;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.business.fidm.report.DisclosureGenerateModuleHelper;
import kd.epm.far.business.fidm.report.dto.GenerateInput;
import kd.epm.far.business.fidm.report.dto.GenerateInputFormular;
import kd.epm.far.business.fidm.report.dto.GenerateResult;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.template.dto.DefaultDimensionEntry;
import kd.epm.far.business.fidm.template.dto.DiscTemplateModel;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.web.WebServiceHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class DisclosureGenerateService {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureGenerateService.class);
    private static final String MODELD = "model";
    private static final String TEMPLATED = "template";
    private static final String ISEDIT = "isedit";
    private static final String NAME = "name";
    private static final String STATUES = "status";
    private static final String REPORT = "report";
    private static final String DIMENSIONID = "dimid";
    private static final String MEMBERID = "dimmemberid";
    private static final String TEMPLATECATALOG = "templatecatalog";
    private static final String CREATOR = "creator";
    private static final String CREATETIME = "createtime";
    private static final String MODIFIER = "modifier";
    private static final String MODIFYTIME = "modifytime";
    private static final String ISARCHIVED = "isarchived";
    private static final String DIMTYPE = "dimtype";
    private static final String BCMENTITY = "bcmentity";
    private static final String EPMENTITY = "epmentity";
    private static final String BCMFY = "year";
    private static final String EPMPERIOD = "budgetperiod";
    private static final String BCMPERIOD = "period";
    private static final String VERSION = "version";
    private static final String SCENARIO = "scenario";
    private static final String DATATYPE = "datatype";
    private static final String ISPREVIEW = "ispreview";
    private static final String PERMCLASS = "permclass";
    private static final String DESQ = "desq";

    public static GenerateResult createReport(GenerateInput input, GenerateInputFormular generateInputFormula, Consumer<TaskMessage> taskConsumer, int reportCount) {
        Long reportId = GlobalIdUtil.genGlobalLongId();
        DynamicObject templateReport = null;
        DynamicObject template = null;
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(input.getDmModelId());
        try {
            ArrayList<DynamicObject> reportDims = new ArrayList<DynamicObject>(100);
            String userId = RequestContext.get().getUserId();
            String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
            List<DimensionInfo> dimensionInfos = new ModelStrategyEx(input.getDmModelId()).getDim().getDimList();
            template = DisclosureTemplateHelper.getTemplate(input.getTemplateId(), false);
            templateReport = BusinessDataServiceHelper.newDynamicObject((String)"fidm_report");
            templateReport.set("id", (Object)reportId);
            templateReport.set(MODELD, (Object)input.getDmModelId());
            templateReport.set(NAME, (Object)input.getReportName());
            templateReport.set(DESQ, (Object)input.getDesq());
            templateReport.set(STATUES, (Object)MyReportStatusEnum.UNCOMMIT.getValue());
            templateReport.set(ISEDIT, (Object)(input.isEdit() ? "0" : "1"));
            templateReport.set(CREATOR, (Object)userId);
            templateReport.set(CREATETIME, (Object)input.getCreateTime());
            templateReport.set(MODIFIER, (Object)userId);
            templateReport.set(MODIFYTIME, (Object)input.getCreateTime());
            templateReport.set(ISARCHIVED, (Object)MyReportStatusEnum.UNARCHIVE.getValue());
            templateReport.set(ISPREVIEW, (Object)Boolean.FALSE);
            templateReport.set(TEMPLATED, (Object)input.getTemplateId());
            DynamicObject templateCatalog = DisclosureTemplateHelper.getTemplateCataLog(input.getTemplateId());
            if (templateCatalog != null) {
                templateReport.set(TEMPLATECATALOG, (Object)templateCatalog.getLong("id"));
            }
            List<DimensionInfo> saveDimList = DisclosureGenerateService.saveReportDim(modelStrategyEx, input, templateReport, dimensionInfos, reportDims);
            if (DisModelTypeEnum.EB.getType().equals(modelType)) {
                DisclosureGenerateService.saveReportDimForEB(input, saveDimList, templateReport);
            } else {
                DisclosureGenerateService.saveReportDimForBCM(input, saveDimList, templateReport);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{templateReport});
            if (reportDims.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])reportDims.toArray(new DynamicObject[reportDims.size()]));
            }
            List<Long> chapterIds = DisclosureGenerateService.copyReportChapter(input.getDmModelId(), reportId, input.getTemplateId(), input.getCreateTime(), generateInputFormula);
            PermClassEntityHelper.savePermClass("fidm_report", reportId, input.getDmModelId(), input.getPermClassId());
            ChapterPreviewResult previewResult = DisclosurePreviewService.reportGeneral(input.getDmModelId(), reportId, input.getMembers(), taskConsumer, reportCount);
            DisclosureGenerateService.resetChapterInfo(reportId, chapterIds, previewResult);
            WebServiceHelper.createReportHtml(input.getDmModelId(), reportId, previewResult);
            DisclosureLogHelper.writeReportCreate(OperationResult.SUCCESS, modelStrategyEx.getModel().getModelInfo(), template, reportId);
            GenerateResult generateResult = new GenerateResult();
            generateResult.setReportId(reportId);
            generateResult.setInput(input);
            return generateResult;
        }
        catch (KDBizException bizException) {
            throw bizException;
        }
        catch (Exception ex) {
            DisclosureLogHelper.writeReportCreate(OperationResult.FAILURE, modelStrategyEx.getModel().getModelInfo(), template, reportId);
            throw ex;
        }
    }

    private static void resetChapterInfo(Long reportId, List<Long> chapterIds, ChapterPreviewResult previewResult) {
        if (chapterIds == null || chapterIds.size() == 0) {
            return;
        }
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        DynamicObject[] chapters = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,number,url,name,previewurl,entryentity,entryentity.module", (QFilter[])new QFilter("id", "in", chapterIds).toArray(), (String)"sequence");
        ArrayList<DynamicObject> saveNewModules = new ArrayList<DynamicObject>(1000);
        for (DynamicObject chapter : chapters) {
            DynamicObject[] moduleList;
            Long chapterId = chapter.getLong("id");
            PreviewResult chapterResult = previewResult.getPreviewResults().stream().filter(m -> m.getInput().getChapterId().equals(chapterId)).findFirst().orElse(null);
            if (chapterResult != null && StringUtils.isNotEmpty((String)chapterResult.getPreviewUrl())) {
                chapter.set("previewurl", (Object)chapterResult.getPreviewUrl());
            }
            if (chapterResult == null || chapterResult.getInput() == null || chapterResult.getInput().getModuleList().size() <= 0) continue;
            List<JSONObject> itemList = chapterResult.getInput().getModuleList();
            DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
            List moduleIds = chapterModules.stream().map(e -> e.getLong("module.id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
            for (DynamicObject module : moduleList = BusinessDataServiceHelper.load((Object[])moduleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_modulerepository"))) {
                String moduleId = module.getString("id");
                JSONObject itemObject = itemList.stream().filter(m -> moduleId.equalsIgnoreCase(m.getString("id"))).findFirst().orElse(null);
                if (itemObject == null) continue;
                module.set("properties", (Object)itemObject.toJSONString());
                saveNewModules.add(module);
            }
        }
        if (StringUtils.isNotEmpty((String)previewResult.getPreviewUrl())) {
            report.set("docurl", (Object)previewResult.getPreviewUrl());
        }
        SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])chapters);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
    }

    private static List<DimensionInfo> saveReportDim(ModelStrategyEx modelStrategyEx, GenerateInput input, DynamicObject templateReport, List<DimensionInfo> allDimensionInfos, List<DynamicObject> reportDims) {
        StringBuilder paramName = new StringBuilder();
        StringBuilder paramNumber = new StringBuilder();
        ArrayList<DimensionInfo> saveDimList = new ArrayList<DimensionInfo>(allDimensionInfos.size());
        for (Map.Entry<String, DimMemberInfo> member : input.getMembers().entrySet()) {
            DimensionInfo dim = DimensionUtils.getDimByNumber(allDimensionInfos, member.getKey());
            if (dim == null) continue;
            dim.setMembers(Collections.singletonList(member.getValue()));
            saveDimList.add(dim);
        }
        DiscTemplateModel discTemplateModel = DiscTemplateModel.genTemplateModelById(input.getTemplateId());
        if (discTemplateModel != null) {
            for (DefaultDimensionEntry p : discTemplateModel.getDefaultDimensionEntries()) {
                DimensionInfo dimensionInfo;
                DimensionInfo find;
                if (p.getMember() == null || p.getMember().getId() <= 0L || (find = DimensionUtils.getDimByNumber(saveDimList, p.getDimension().getNumber())) != null || (dimensionInfo = DimensionUtils.getDimByNumber(allDimensionInfos, p.getDimension().getNumber())) == null) continue;
                DimMemberInfo memberInfo = new DimMemberInfo();
                memberInfo.setId(p.getMember().getId());
                memberInfo.setNumber(p.getMember().getNumber());
                memberInfo.setName(p.getMember().getName());
                dimensionInfo.setMembers(Collections.singletonList(memberInfo));
                saveDimList.add(dimensionInfo);
            }
        }
        for (DimensionInfo dim : saveDimList) {
            if (dim == null || dim.getMembers() == null || dim.getMembers().size() == 0) continue;
            DimMemberInfo member = dim.getMembers().get(0);
            DynamicObject reportDim = BusinessDataServiceHelper.newDynamicObject((String)"fidm_report_dim");
            reportDim.set(REPORT, (Object)templateReport.getLong("id"));
            reportDim.set(DIMENSIONID, (Object)(dim == null ? Long.valueOf(0L) : dim.getId()));
            reportDim.set(MEMBERID, (Object)member.getId());
            reportDim.set(DIMTYPE, (Object)modelStrategyEx.getDim().getDimEntity());
            reportDims.add(reportDim);
            StringBuilder nameStr = new StringBuilder();
            nameStr.append(dim.getName());
            nameStr.append(".");
            nameStr.append(member.getName());
            nameStr.append(";");
            paramName.append((CharSequence)nameStr);
            StringBuilder numberStr = new StringBuilder();
            numberStr.append(dim.getNumber());
            numberStr.append(".");
            numberStr.append(member.getNumber());
            numberStr.append(";");
            paramNumber.append((CharSequence)numberStr);
        }
        templateReport.set("param", (Object)new LocaleString(DisclosureGenerateService.getParamName(paramName.toString())));
        templateReport.set("paramnumber", (Object)new LocaleString(DisclosureGenerateService.getParamName(paramNumber.toString())));
        return saveDimList;
    }

    private static void saveReportDimForEB(GenerateInput input, List<DimensionInfo> saveDimList, DynamicObject templateReport) {
        DimMemberInfo entity = DisclosureGenerateService.getDimMemberInfo(input.getMembers(), saveDimList, "entity");
        DimMemberInfo budgetPeriod = DisclosureGenerateService.getDimMemberInfo(input.getMembers(), saveDimList, EPMPERIOD);
        DimMemberInfo version = DisclosureGenerateService.getDimMemberInfo(input.getMembers(), saveDimList, VERSION);
        DimMemberInfo datatype = DisclosureGenerateService.getDimMemberInfo(input.getMembers(), saveDimList, DATATYPE);
        if (entity != null) {
            templateReport.set(EPMENTITY, (Object)entity.getId());
        }
        if (budgetPeriod != null) {
            templateReport.set(EPMPERIOD, (Object)budgetPeriod.getId());
        }
        if (version != null) {
            templateReport.set(VERSION, (Object)version.getId());
        }
        if (datatype != null) {
            templateReport.set(DATATYPE, (Object)datatype.getId());
        }
    }

    private static DimMemberInfo getDimMemberInfo(Map<String, DimMemberInfo> memberInfoMap, List<DimensionInfo> saveDimList, String dimNumebr) {
        DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(saveDimList, dimNumebr);
        if (dimensionInfo != null && dimensionInfo.getMembers().size() > 0) {
            return dimensionInfo.getMembers().get(0);
        }
        return memberInfoMap.get(dimNumebr.toLowerCase(Locale.ROOT));
    }

    private static void saveReportDimForBCM(GenerateInput input, List<DimensionInfo> saveDimList, DynamicObject templateReport) {
        DimMemberInfo entity = DisclosureGenerateService.getDimMemberInfo(input.getMembers(), saveDimList, "entity");
        DimMemberInfo period = DisclosureGenerateService.getDimMemberInfo(input.getMembers(), saveDimList, BCMPERIOD);
        DimMemberInfo year = DisclosureGenerateService.getDimMemberInfo(input.getMembers(), saveDimList, BCMFY);
        DimMemberInfo scenario = DisclosureGenerateService.getDimMemberInfo(input.getMembers(), saveDimList, SCENARIO);
        if (entity != null) {
            templateReport.set(BCMENTITY, (Object)entity.getId());
        }
        if (period != null) {
            templateReport.set(BCMPERIOD, (Object)period.getId());
        }
        if (year != null) {
            templateReport.set(BCMFY, (Object)year.getId());
        }
        if (scenario != null) {
            templateReport.set(SCENARIO, (Object)scenario.getId());
        }
    }

    private static String getParamName(String paramName) {
        if (StringUtils.isEmpty((String)paramName)) {
            return paramName;
        }
        if (paramName.length() != 0) {
            paramName = paramName.substring(0, paramName.length() - 1);
        }
        if (paramName.length() > 2000) {
            paramName = paramName.substring(0, 2000);
        }
        return paramName;
    }

    private static ICopyOperation resetModuleProperty(GenerateInputFormular generateInputFormula) {
        if (generateInputFormula == null) {
            return null;
        }
        if (generateInputFormula.getModuleRange() == null || generateInputFormula.getModuleRange().size() == 0) {
            return null;
        }
        if (generateInputFormula.getUnit() == null || "0".equalsIgnoreCase(generateInputFormula.getUnit())) {
            return null;
        }
        ICopyOperation copyOperation = (chapterId, module) -> DisclosureGenerateModuleHelper.resetModuleProperty(generateInputFormula, module);
        return copyOperation;
    }

    private static List<Long> copyReportChapter(Long dmModelId, Long reportId, Long currTemplateId, Date date, GenerateInputFormular generateInputFormula) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)RequestContext.get().getCurrUserId());
        ArrayList<Long> newChapterIds = new ArrayList<Long>(100);
        ICopyOperation copyOperation = DisclosureGenerateService.resetModuleProperty(generateInputFormula);
        List<Long> oldChapterIds = PermClassTemplateHelper.getValiadChaptersByTemplate(dmModelId, currTemplateId);
        if (oldChapterIds.size() == 0) {
            return newChapterIds;
        }
        int index = 0;
        DynamicObject[] oldChapters = BusinessDataServiceHelper.load((Object[])TypeUtils.convertToObject(oldChapterIds), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_chapter"));
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
                DynamicObjectCollection entryentitys = report.getDynamicObjectCollection("entryentity");
                DynamicObjectType dynamicObjectType = entryentitys.getDynamicObjectType();
                ArrayList<DynamicObject> newChapterList = new ArrayList<DynamicObject>(oldChapters.length);
                for (DynamicObject oldChapter : oldChapters) {
                    if (!"1".equals(oldChapter.getString("enable"))) continue;
                    DynamicObject newChapter = (DynamicObject)cloneUtils.clone((IDataEntityBase)oldChapter);
                    long oldChapterId = oldChapter.getLong("id");
                    DisclosureGenerateService.buildNewInstanceParams(newChapter);
                    long newChapterId = newChapter.getLong("id");
                    newChapterList.add(newChapter);
                    DisclosureCopyHelper.copyVariable(cloneUtils, oldChapterId, newChapterId, user, date);
                    DisclosureCopyHelper.copyDataSet(cloneUtils, oldChapterId, newChapterId, user, date);
                    List<ChapterModuleCopyResult> moduleMap = DisclosureCopyHelper.copyChapterModule(cloneUtils, oldChapterId, newChapter, user, date, copyOperation);
                    DisclosureCopyHelper.copyChapterHtml(oldChapterId, newChapterId, user, date, moduleMap);
                    DisclosureCopyHelper.copyChapterFile(oldChapterId, newChapterId, newChapter, moduleMap);
                    DynamicObject reportChapter = (DynamicObject)dynamicObjectType.createInstance();
                    reportChapter.set("chapter", (Object)newChapter);
                    reportChapter.set("ischeck", (Object)"0");
                    reportChapter.set("seq", (Object)(++index));
                    entryentitys.add((Object)reportChapter);
                    newChapterIds.add(newChapterId);
                }
                report.set("entryentity", (Object)entryentitys);
                if (newChapterList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])newChapterList.toArray(new DynamicObject[0]));
                    DisclosureGenerateService.batchSavePermClass(newChapterList);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
            }
            catch (Exception ex) {
                tx.markRollback();
                logger.error("dm copyChapter error", (Throwable)ex);
            }
        }
        return newChapterIds;
    }

    private static void buildNewInstanceParams(DynamicObject newChapter) {
        Long newChapterId = GlobalIdUtil.genGlobalLongId();
        newChapter.set("id", (Object)newChapterId);
        newChapter.set(TEMPLATED, null);
        newChapter.set("previewurl", null);
        newChapter.set(CREATOR, (Object)RequestContext.get().getCurrUserId());
        newChapter.set(CREATETIME, (Object)new Date());
        newChapter.set(MODIFIER, (Object)RequestContext.get().getCurrUserId());
        newChapter.set(MODIFYTIME, (Object)new Date());
        newChapter.set("commitstatus", (Object)"A");
        newChapter.set("commitor", null);
        newChapter.set("committime", null);
        newChapter.set("sendbacker", null);
        newChapter.set("sendbacktime", null);
    }

    private static void batchSavePermClass(List<DynamicObject> newChapterDynList) {
        ArrayList<DynamicObject> entityList = new ArrayList<DynamicObject>(newChapterDynList.size());
        for (DynamicObject newChapterDyn : newChapterDynList) {
            if (newChapterDyn.get(PERMCLASS) == null) continue;
            DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            entity.set("entityname", (Object)newChapterDyn.getDataEntityType().getName());
            entity.set("fidmmodel", (Object)newChapterDyn.getLong("model.id"));
            entity.set("entityid", (Object)newChapterDyn.getLong("id"));
            entity.set(PERMCLASS, newChapterDyn.get(PERMCLASS));
            entityList.add(entity);
        }
        if (entityList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])entityList.toArray(new DynamicObject[0]));
        }
    }
}

